/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model.runtime.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.runtime.callback.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.contexts.IAsyncRefreshableCtx;
import org.eclipse.tcf.te.runtime.services.ServiceUtils;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.core.async.CallbackInvocationDelegate;
import org.eclipse.tcf.te.tcf.core.model.interfaces.IModel;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelChannelService;
import org.eclipse.tcf.te.tcf.core.model.services.AbstractModelService;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModelRefreshService;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModelUpdateService;
import org.eclipse.tcf.te.tcf.processes.core.nls.Messages;

public class RuntimeModelRefreshService
extends AbstractModelService<IRuntimeModel>
implements IRuntimeModelRefreshService {
    private final Map<IModelNode, List<ICallback>> ctx2cb = new HashMap<IModelNode, List<ICallback>>();
    final IRuntimeModelRefreshService.IDelegate defaultDelegate = new DefaultDelegate();

    public RuntimeModelRefreshService(IRuntimeModel model) {
        super((IModel)model);
    }

    public void refresh(ICallback callback) {
        this.refresh(callback, 2);
    }

    @Override
    public void refresh(ICallback callback, int depth) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        final IRuntimeModel model = (IRuntimeModel)this.getModel();
        Assert.isNotNull((Object)model);
        if (model.isDisposed()) {
            if (callback != null) {
                callback.done((Object)this, Status.OK_STATUS);
            }
            return;
        }
        boolean isRefreshAlreadyRunning = this.ctx2cb.containsKey(model);
        List<ICallback> callbacks = this.ctx2cb.get(model);
        if (callbacks == null) {
            callbacks = new ArrayList<ICallback>();
            this.ctx2cb.put((IModelNode)model, callbacks);
        }
        Assert.isNotNull(callbacks);
        if (callback != null) {
            callbacks.add(callback);
        }
        if (isRefreshAlreadyRunning) {
            return;
        }
        final IProcessContextNode container = (IProcessContextNode)model.getFactory().newInstance(IProcessContextNode.class);
        final IAsyncRefreshableCtx containerRefreshable = (IAsyncRefreshableCtx)container.getAdapter(IAsyncRefreshableCtx.class);
        Assert.isNotNull((Object)containerRefreshable);
        containerRefreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.IN_PROGRESS);
        this.refreshChildrenLevel1(null, depth, container, (ICallback)new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                containerRefreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.DONE);
                if (status.isOK()) {
                    ((IRuntimeModelUpdateService)model.getService(IRuntimeModelUpdateService.class)).updateChildren((IContainerModelNode)model, container);
                    ArrayList<IProcessContextNode> children = new ArrayList<IProcessContextNode>();
                    List candidates = model.getChildren(IProcessContextNode.class);
                    for (IProcessContextNode candidate : candidates) {
                        IAsyncRefreshableCtx refreshable = (IAsyncRefreshableCtx)candidate.getAdapter(IAsyncRefreshableCtx.class);
                        Assert.isNotNull((Object)refreshable);
                        if (refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST) != IAsyncRefreshableCtx.QueryState.DONE) continue;
                        List candidates2 = candidate.getChildren(IProcessContextNode.class);
                        for (IProcessContextNode candidate2 : candidates2) {
                            refreshable = (IAsyncRefreshableCtx)candidate2.getAdapter(IAsyncRefreshableCtx.class);
                            Assert.isNotNull((Object)refreshable);
                            if (refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST) != IAsyncRefreshableCtx.QueryState.DONE) continue;
                            children.add(candidate2);
                        }
                    }
                    Callback callback = new Callback(){

                        protected void internalDone(Object caller, IStatus status) {
                            RuntimeModelRefreshService.this.invokeCallbacks((IModelNode)model, RuntimeModelRefreshService.this, status);
                        }
                    };
                    AsyncCallbackCollector collector = new AsyncCallbackCollector((ICallback)callback, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
                    if (children.size() > 0) {
                        RuntimeModelRefreshService.this.doAutoRefresh(model, children.toArray(new IProcessContextNode[children.size()]), 0, collector);
                    }
                    collector.initDone();
                } else {
                    RuntimeModelRefreshService.this.invokeCallbacks((IModelNode)model, RuntimeModelRefreshService.this, status);
                }
            }
        });
    }

    public void refresh(final IModelNode node, ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)node);
        final IRuntimeModel model = (IRuntimeModel)this.getModel();
        Assert.isNotNull((Object)model);
        if (model.isDisposed() || !(node instanceof IProcessContextNode)) {
            if (callback != null) {
                callback.done((Object)this, Status.OK_STATUS);
            }
            return;
        }
        String contextId = node.getStringProperty("id");
        if (contextId == null) {
            if (callback != null) {
                callback.done((Object)this, Status.OK_STATUS);
            }
            return;
        }
        boolean isRefreshAlreadyRunning = this.ctx2cb.containsKey(node);
        List<ICallback> callbacks = this.ctx2cb.get(node);
        if (callbacks == null) {
            callbacks = new ArrayList<ICallback>();
            this.ctx2cb.put(node, callbacks);
        }
        Assert.isNotNull(callbacks);
        if (callback != null) {
            callbacks.add(callback);
        }
        if (isRefreshAlreadyRunning) {
            return;
        }
        final IProcessContextNode container = (IProcessContextNode)model.getFactory().newInstance(IProcessContextNode.class);
        final IAsyncRefreshableCtx containerRefreshable = (IAsyncRefreshableCtx)container.getAdapter(IAsyncRefreshableCtx.class);
        Assert.isNotNull((Object)containerRefreshable);
        containerRefreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.IN_PROGRESS);
        container.setProperty("id", contextId);
        container.setType(((IProcessContextNode)node).getType());
        this.refreshContextLevel1(contextId, 2, container, (ICallback)new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                containerRefreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.DONE);
                if (status.isOK()) {
                    ((IRuntimeModelUpdateService)model.getService(IRuntimeModelUpdateService.class)).update(node, (IModelNode)container);
                    ArrayList<IProcessContextNode> children = new ArrayList<IProcessContextNode>();
                    List candidates = ((IProcessContextNode)node).getChildren(IProcessContextNode.class);
                    for (IProcessContextNode candidate : candidates) {
                        IAsyncRefreshableCtx refreshable = (IAsyncRefreshableCtx)candidate.getAdapter(IAsyncRefreshableCtx.class);
                        Assert.isNotNull((Object)refreshable);
                        if (refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST) != IAsyncRefreshableCtx.QueryState.DONE) continue;
                        List candidates2 = candidate.getChildren(IProcessContextNode.class);
                        for (IProcessContextNode candidate2 : candidates2) {
                            refreshable = (IAsyncRefreshableCtx)candidate2.getAdapter(IAsyncRefreshableCtx.class);
                            Assert.isNotNull((Object)refreshable);
                            if (refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST) != IAsyncRefreshableCtx.QueryState.DONE) continue;
                            children.add(candidate2);
                        }
                    }
                    Callback callback = new Callback(){

                        protected void internalDone(Object caller, IStatus status) {
                            RuntimeModelRefreshService.this.invokeCallbacks(node, RuntimeModelRefreshService.this, status);
                        }
                    };
                    AsyncCallbackCollector collector = new AsyncCallbackCollector((ICallback)callback, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
                    if (children.size() > 0) {
                        RuntimeModelRefreshService.this.doAutoRefresh(model, children.toArray(new IProcessContextNode[children.size()]), 0, collector);
                    }
                    collector.initDone();
                } else {
                    RuntimeModelRefreshService.this.invokeCallbacks(node, RuntimeModelRefreshService.this, status);
                }
            }
        });
    }

    @Override
    public void autoRefresh(ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        final IRuntimeModel model = (IRuntimeModel)this.getModel();
        if (model.isDisposed()) {
            if (callback != null) {
                callback.done((Object)this, Status.OK_STATUS);
            }
            return;
        }
        boolean isRefreshAlreadyRunning = this.ctx2cb.containsKey(model);
        List<ICallback> callbacks = this.ctx2cb.get(model);
        if (callbacks == null) {
            callbacks = new ArrayList<ICallback>();
            this.ctx2cb.put((IModelNode)model, callbacks);
        }
        Assert.isNotNull(callbacks);
        if (callback != null) {
            callbacks.add(callback);
        }
        if (isRefreshAlreadyRunning) {
            return;
        }
        Callback innerCallback = new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                RuntimeModelRefreshService.this.invokeCallbacks((IModelNode)model, RuntimeModelRefreshService.this, status);
            }
        };
        AsyncCallbackCollector collector = new AsyncCallbackCollector((ICallback)innerCallback, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
        List children = model.getChildren(IProcessContextNode.class);
        if (children.size() > 0) {
            this.doAutoRefresh(model, children.toArray(new IProcessContextNode[children.size()]), 0, collector);
        }
        collector.initDone();
    }

    void doAutoRefresh(final IRuntimeModel model, final IProcessContextNode[] nodes, final int index, final AsyncCallbackCollector collector) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)model);
        Assert.isNotNull((Object)nodes);
        Assert.isTrue((index >= 0 && index < nodes.length ? 1 : 0) != 0);
        Assert.isNotNull((Object)collector);
        final IProcessContextNode node = nodes[index];
        IAsyncRefreshableCtx refreshable = (IAsyncRefreshableCtx)node.getAdapter(IAsyncRefreshableCtx.class);
        if (refreshable != null && refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST).equals((Object)IAsyncRefreshableCtx.QueryState.DONE)) {
            Callback callback = new Callback(){

                protected void internalDone(Object caller, IStatus status) {
                    4 outerCallback = this;
                    Callback innerCallback = new Callback((ICallback)outerCallback){
                        private final /* synthetic */ ICallback val$outerCallback;
                        {
                            this.val$outerCallback = iCallback;
                        }

                        protected void internalDone(Object caller, IStatus status) {
                            int newIndex = index + 1;
                            if (newIndex < nodes.length && status.isOK()) {
                                RuntimeModelRefreshService.this.doAutoRefresh(model, nodes, newIndex, collector);
                            }
                            collector.removeCallback(this.val$outerCallback);
                        }
                    };
                    List children = node.getChildren(IProcessContextNode.class);
                    if (children.size() > 0) {
                        AsyncCallbackCollector childCollector = new AsyncCallbackCollector((ICallback)innerCallback, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
                        RuntimeModelRefreshService.this.doAutoRefresh(model, children.toArray(new IProcessContextNode[children.size()]), 0, childCollector);
                        childCollector.initDone();
                    } else {
                        innerCallback.done((Object)this, status);
                    }
                }
            };
            collector.addCallback((ICallback)callback);
            String contextId = node.getStringProperty("id");
            if (contextId == null) {
                callback.done((Object)this, Status.OK_STATUS);
                return;
            }
            final IProcessContextNode container = (IProcessContextNode)model.getFactory().newInstance(IProcessContextNode.class);
            final IAsyncRefreshableCtx containerRefreshable = (IAsyncRefreshableCtx)container.getAdapter(IAsyncRefreshableCtx.class);
            Assert.isNotNull((Object)containerRefreshable);
            containerRefreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.IN_PROGRESS);
            container.setProperty("id", contextId);
            container.setType(node.getType());
            this.refreshContextLevel1(contextId, 1, container, (ICallback)new Callback((ICallback)callback, contextId){
                private final /* synthetic */ ICallback val$callback;
                private final /* synthetic */ String val$contextId;
                {
                    this.val$callback = iCallback;
                    this.val$contextId = string;
                }

                protected void internalDone(Object caller, IStatus status) {
                    containerRefreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.DONE);
                    if (status.isOK()) {
                        List oldChildren = node.getChildren(IProcessContextNode.class);
                        List newChildren = container.getChildren(IProcessContextNode.class);
                        for (IProcessContextNode child : oldChildren) {
                            String id = child.getStringProperty("id");
                            if (id == null) continue;
                            IProcessContextNode node2 = null;
                            for (IProcessContextNode candidate : newChildren) {
                                if (!id.equals(candidate.getStringProperty("id"))) continue;
                                node2 = candidate;
                                break;
                            }
                            if (node2 == null) continue;
                            newChildren.remove(node2);
                        }
                        ((IRuntimeModelUpdateService)model.getService(IRuntimeModelUpdateService.class)).update((IModelNode)node, (IModelNode)container);
                        if (newChildren.size() > 0) {
                            final AsyncCallbackCollector collector = new AsyncCallbackCollector(this.val$callback, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
                            oldChildren = node.getChildren(IProcessContextNode.class);
                            for (IProcessContextNode child : newChildren) {
                                String id = child.getStringProperty("id");
                                if (id == null) continue;
                                IProcessContextNode realChild = null;
                                for (IProcessContextNode candidate : oldChildren) {
                                    if (!id.equals(candidate.getStringProperty("id"))) continue;
                                    realChild = candidate;
                                    break;
                                }
                                if (realChild == null) continue;
                                final IProcessContextNode container2 = (IProcessContextNode)model.getFactory().newInstance(IProcessContextNode.class);
                                final IAsyncRefreshableCtx containerRefreshable2 = (IAsyncRefreshableCtx)container2.getAdapter(IAsyncRefreshableCtx.class);
                                Assert.isNotNull((Object)containerRefreshable2);
                                containerRefreshable2.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.IN_PROGRESS);
                                container2.setProperty("id", this.val$contextId);
                                container2.setType(node.getType());
                                final IProcessContextNode finRealChild = realChild;
                                Callback cb = new Callback(){

                                    protected void internalDone(Object caller, IStatus status) {
                                        containerRefreshable2.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.DONE);
                                        if (status.isOK()) {
                                            ((IRuntimeModelUpdateService)model.getService(IRuntimeModelUpdateService.class)).updateChildren(finRealChild, container2);
                                        }
                                        if (status.getException() != null) {
                                            collector.handleError(status.getException());
                                        } else {
                                            collector.removeCallback((ICallback)this);
                                        }
                                    }
                                };
                                collector.addCallback((ICallback)cb);
                                RuntimeModelRefreshService.this.refreshChildrenLevel1(id, 1, container2, (ICallback)cb);
                            }
                            collector.initDone();
                        } else {
                            this.val$callback.done((Object)RuntimeModelRefreshService.this, status);
                        }
                    } else {
                        this.val$callback.done((Object)RuntimeModelRefreshService.this, status);
                    }
                }
            });
        }
    }

    protected void refreshContextLevel1(final String contextId, final int maxDepth, final IProcessContextNode container, final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)contextId);
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)callback);
        try {
            IModelChannelService channelService = (IModelChannelService)((IRuntimeModel)this.getModel()).getService(IModelChannelService.class);
            channelService.openChannel(new IModelChannelService.DoneOpenChannel(){

                public void doneOpenChannel(Throwable error, final IChannel channel) {
                    if (error == null) {
                        RuntimeModelRefreshService.this.refreshContext(channel, contextId, container, (ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                if (status.isOK()) {
                                    RuntimeModelRefreshService.this.refreshChildContexts(channel, contextId, container, (ICallback)new Callback(){

                                        protected void internalDone(Object caller, IStatus status) {
                                            if (maxDepth < 0 || maxDepth - 1 > 0) {
                                                List children = container.getChildren(IProcessContextNode.class);
                                                Assert.isNotNull((Object)children);
                                                RuntimeModelRefreshService.this.refreshChildrenLevelN(channel, children.toArray(new IProcessContextNode[children.size()]), maxDepth - 1, callback);
                                            } else {
                                                callback.done((Object)RuntimeModelRefreshService.this, status);
                                            }
                                        }
                                    });
                                } else {
                                    callback.done((Object)RuntimeModelRefreshService.this, status);
                                }
                            }
                        });
                    } else {
                        callback.done((Object)RuntimeModelRefreshService.this, (IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), error.getLocalizedMessage(), error));
                    }
                }
            });
        }
        catch (Throwable e) {
            callback.done((Object)this, (IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), e));
        }
    }

    void refreshChildrenLevel1(final String parentContextId, final int maxDepth, final IProcessContextNode container, final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)callback);
        try {
            IModelChannelService channelService = (IModelChannelService)((IRuntimeModel)this.getModel()).getService(IModelChannelService.class);
            channelService.openChannel(new IModelChannelService.DoneOpenChannel(){

                public void doneOpenChannel(Throwable error, final IChannel channel) {
                    if (error == null) {
                        RuntimeModelRefreshService.this.refreshChildContexts(channel, parentContextId, container, (ICallback)new Callback(){

                            protected void internalDone(Object caller, IStatus status) {
                                if (maxDepth < 0 || maxDepth - 1 > 0) {
                                    List children = container.getChildren(IProcessContextNode.class);
                                    Assert.isNotNull((Object)children);
                                    RuntimeModelRefreshService.this.refreshChildrenLevelN(channel, children.toArray(new IProcessContextNode[children.size()]), maxDepth - 1, callback);
                                } else {
                                    callback.done((Object)RuntimeModelRefreshService.this, status);
                                }
                            }
                        });
                    } else {
                        callback.done((Object)RuntimeModelRefreshService.this, (IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), error.getLocalizedMessage(), error));
                    }
                }
            });
        }
        catch (Throwable e) {
            callback.done((Object)this, (IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), e.getLocalizedMessage(), e));
        }
    }

    void refreshChildrenLevelN(final IChannel channel, final IProcessContextNode[] parents, final int maxDepth, final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)channel);
        Assert.isNotNull((Object)parents);
        Assert.isNotNull((Object)callback);
        if (channel.getState() != 1) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.RuntimeModelRefreshService_error_channelClosed);
            callback.done((Object)this, (IStatus)status);
            return;
        }
        if (parents.length == 0) {
            callback.done((Object)this, Status.OK_STATUS);
            return;
        }
        AsyncCallbackCollector collector = new AsyncCallbackCollector((ICallback)new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                if (maxDepth < 0 || maxDepth - 1 > 0) {
                    AsyncCallbackCollector collector2 = new AsyncCallbackCollector(callback, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
                    IProcessContextNode[] iProcessContextNodeArray = parents;
                    int n = parents.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcessContextNode parent = iProcessContextNodeArray[n2];
                        List children = parent.getChildren(IProcessContextNode.class);
                        Assert.isNotNull((Object)children);
                        RuntimeModelRefreshService.this.refreshChildrenLevelN(channel, children.toArray(new IProcessContextNode[children.size()]), maxDepth - 1, (ICallback)new AsyncCallbackCollector.SimpleCollectorCallback(collector2));
                        ++n2;
                    }
                    collector2.initDone();
                } else {
                    callback.done((Object)RuntimeModelRefreshService.this, status);
                }
            }
        }, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
        IProcessContextNode[] iProcessContextNodeArray = parents;
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            final IProcessContextNode parent = iProcessContextNodeArray[n2];
            String parentContextId = parent.getStringProperty("id");
            if (parentContextId != null) {
                AsyncCallbackCollector.SimpleCollectorCallback cb = new AsyncCallbackCollector.SimpleCollectorCallback(collector);
                final IAsyncRefreshableCtx refreshable = (IAsyncRefreshableCtx)parent.getAdapter(IAsyncRefreshableCtx.class);
                Assert.isNotNull((Object)refreshable);
                if (!refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST).equals((Object)IAsyncRefreshableCtx.QueryState.IN_PROGRESS)) {
                    refreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.IN_PROGRESS);
                    final boolean changed = parent.setChangeEventsEnabled(false);
                    this.refreshChildContexts(channel, parentContextId, parent, (ICallback)new Callback((ICallback)cb){
                        private final /* synthetic */ ICallback val$cb;
                        {
                            this.val$cb = iCallback;
                        }

                        protected void internalDone(Object caller, IStatus status) {
                            refreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.DONE);
                            if (changed) {
                                parent.setChangeEventsEnabled(true);
                            }
                            this.val$cb.done((Object)RuntimeModelRefreshService.this, status);
                        }
                    });
                } else {
                    cb.done((Object)this, Status.OK_STATUS);
                }
            }
            ++n2;
        }
        collector.initDone();
    }

    void refreshContext(final IChannel channel, String contextId, final IProcessContextNode node, final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)channel);
        Assert.isNotNull((Object)contextId);
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)callback);
        if (channel.getState() != 1) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.RuntimeModelRefreshService_error_channelClosed);
            callback.done((Object)this, (IStatus)status);
            return;
        }
        IProcesses service = (IProcesses)channel.getRemoteService(IProcesses.class);
        ISysMonitor sysMonService = (ISysMonitor)channel.getRemoteService(ISysMonitor.class);
        if (service == null || sysMonService == null) {
            callback.done((Object)this, Status.OK_STATUS);
            return;
        }
        AsyncCallbackCollector collector = new AsyncCallbackCollector((ICallback)new Callback(){

            protected void internalDone(Object caller, IStatus status) {
                IRuntimeModelRefreshService.IDelegate delegate = (IRuntimeModelRefreshService.IDelegate)ServiceUtils.getDelegateServiceDelegate((Object)channel.getRemotePeer(), (Object)channel.getRemotePeer(), IRuntimeModelRefreshService.IDelegate.class);
                if (delegate == null) {
                    delegate = RuntimeModelRefreshService.this.defaultDelegate;
                }
                Assert.isNotNull((Object)delegate);
                delegate.postRefreshContext(channel, node, callback);
            }
        }, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
        AsyncCallbackCollector.SimpleCollectorCallback cb1 = new AsyncCallbackCollector.SimpleCollectorCallback(collector);
        sysMonService.getContext(contextId, new ISysMonitor.DoneGetContext((ICallback)cb1){
            private final /* synthetic */ ICallback val$cb1;
            {
                this.val$cb1 = iCallback;
            }

            public void doneGetContext(IToken token, Exception error, ISysMonitor.SysMonitorContext context) {
                node.setSysMonitorContext(context);
                this.val$cb1.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
            }
        });
        AsyncCallbackCollector.SimpleCollectorCallback cb2 = new AsyncCallbackCollector.SimpleCollectorCallback(collector);
        service.getContext(contextId, new IProcesses.DoneGetContext((ICallback)cb2){
            private final /* synthetic */ ICallback val$cb2;
            {
                this.val$cb2 = iCallback;
            }

            public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                node.setProcessContext(context);
                if (context != null) {
                    node.setProperty("name", context.getName());
                }
                this.val$cb2.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
            }
        });
        collector.initDone();
    }

    void refreshChildContexts(final IChannel channel, final String parentContextId, final IContainerModelNode container, final ICallback callback) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)channel);
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)callback);
        if (channel.getState() != 1) {
            Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.RuntimeModelRefreshService_error_channelClosed);
            callback.done((Object)this, (IStatus)status);
            return;
        }
        final IProcesses service = (IProcesses)channel.getRemoteService(IProcesses.class);
        final ISysMonitor sysMonService = (ISysMonitor)channel.getRemoteService(ISysMonitor.class);
        if (service == null || sysMonService == null) {
            callback.done((Object)this, Status.OK_STATUS);
            return;
        }
        sysMonService.getChildren(parentContextId, new ISysMonitor.DoneGetChildren(){

            public void doneGetChildren(IToken token, Exception error, String[] context_ids) {
                if (error == null) {
                    if (context_ids != null && context_ids.length > 0) {
                        AsyncCallbackCollector collector = new AsyncCallbackCollector(callback, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
                        String[] stringArray = context_ids;
                        int n = context_ids.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String id;
                            String contextId = id = stringArray[n2];
                            final IProcessContextNode node = RuntimeModelRefreshService.this.createContextNodeFrom(contextId);
                            Assert.isNotNull((Object)node);
                            container.add((IModelNode)node);
                            AsyncCallbackCollector.SimpleCollectorCallback innerCallback = new AsyncCallbackCollector.SimpleCollectorCallback(collector);
                            AsyncCallbackCollector innerCollector = new AsyncCallbackCollector((ICallback)new Callback((ICallback)innerCallback){
                                private final /* synthetic */ ICallback val$innerCallback;
                                {
                                    this.val$innerCallback = iCallback;
                                }

                                protected void internalDone(Object caller, IStatus status) {
                                    IRuntimeModelRefreshService.IDelegate delegate = (IRuntimeModelRefreshService.IDelegate)ServiceUtils.getDelegateServiceDelegate((Object)channel.getRemotePeer(), (Object)channel.getRemotePeer(), IRuntimeModelRefreshService.IDelegate.class);
                                    if (delegate != null) {
                                        delegate.setNodeType(parentContextId, node);
                                    }
                                    if (node.getType() == IProcessContextNode.TYPE.Unknown) {
                                        (this).RuntimeModelRefreshService.this.defaultDelegate.setNodeType(parentContextId, node);
                                    }
                                    if (delegate == null) {
                                        delegate = (this).RuntimeModelRefreshService.this.defaultDelegate;
                                    }
                                    Assert.isNotNull((Object)delegate);
                                    delegate.postRefreshContext(channel, node, this.val$innerCallback);
                                }
                            }, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
                            AsyncCallbackCollector.SimpleCollectorCallback cb1 = new AsyncCallbackCollector.SimpleCollectorCallback(innerCollector);
                            sysMonService.getContext(contextId, new ISysMonitor.DoneGetContext((ICallback)cb1){
                                private final /* synthetic */ ICallback val$cb1;
                                {
                                    this.val$cb1 = iCallback;
                                }

                                public void doneGetContext(IToken token, Exception error, ISysMonitor.SysMonitorContext context) {
                                    node.setSysMonitorContext(context);
                                    this.val$cb1.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
                                }
                            });
                            AsyncCallbackCollector.SimpleCollectorCallback cb2 = new AsyncCallbackCollector.SimpleCollectorCallback(innerCollector);
                            service.getContext(contextId, new IProcesses.DoneGetContext((ICallback)cb2){
                                private final /* synthetic */ ICallback val$cb2;
                                {
                                    this.val$cb2 = iCallback;
                                }

                                public void doneGetContext(IToken token, Exception error, IProcesses.ProcessContext context) {
                                    node.setProcessContext(context);
                                    if (context != null) {
                                        node.setProperty("name", context.getName());
                                    }
                                    this.val$cb2.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
                                }
                            });
                            innerCollector.initDone();
                            ++n2;
                        }
                        collector.initDone();
                    } else {
                        callback.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
                    }
                } else if (StatusHelper.unwrapErrorReport((String)error.getLocalizedMessage()).equals("Invalid context")) {
                    container.setProperty("invalidCtx", true);
                    callback.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
                } else {
                    callback.done((Object)RuntimeModelRefreshService.this, (IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), error.getLocalizedMessage(), (Throwable)error));
                }
            }
        });
    }

    IProcessContextNode createContextNodeFrom(String contextId) {
        Assert.isNotNull((Object)contextId);
        IProcessContextNode node = (IProcessContextNode)((IRuntimeModel)this.getModel()).getFactory().newInstance(IProcessContextNode.class);
        node.setProperty("id", contextId);
        return node;
    }

    protected void invokeCallbacks(IModelNode context, final Object caller, final IStatus status) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)status);
        List<ICallback> callbacks = this.ctx2cb.remove(context);
        if (callbacks != null) {
            for (final ICallback callback : callbacks) {
                Protocol.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        callback.done(caller, status);
                    }
                });
            }
        }
    }

    final class DefaultDelegate
    implements IRuntimeModelRefreshService.IDelegate {
        private final String[] managedPropertyNames = new String[]{"cmdline"};

        DefaultDelegate() {
        }

        @Override
        public void setNodeType(String parentContextId, IProcessContextNode node) {
            Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
            Assert.isNotNull((Object)node);
            node.setType(parentContextId == null ? IProcessContextNode.TYPE.Process : IProcessContextNode.TYPE.Thread);
        }

        @Override
        public void postRefreshContext(IChannel channel, final IProcessContextNode node, final ICallback callback) {
            Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
            Assert.isNotNull((Object)channel);
            Assert.isNotNull((Object)node);
            Assert.isNotNull((Object)callback);
            if (channel.getState() != 1) {
                Status status = new Status(4, CoreBundleActivator.getUniqueIdentifier(), Messages.RuntimeModelRefreshService_error_channelClosed);
                callback.done((Object)RuntimeModelRefreshService.this, (IStatus)status);
                return;
            }
            ISysMonitor sysMonService = (ISysMonitor)channel.getRemoteService(ISysMonitor.class);
            if (sysMonService == null) {
                callback.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
                return;
            }
            String contextId = node.getStringProperty("id");
            if (contextId == null) {
                callback.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
                return;
            }
            sysMonService.getCommandLine(contextId, new ISysMonitor.DoneGetCommandLine(){

                public void doneGetCommandLine(IToken token, Exception error, String[] cmd_line) {
                    node.setProperty("cmdline", error == null ? cmd_line : null);
                    callback.done((Object)RuntimeModelRefreshService.this, Status.OK_STATUS);
                }
            });
        }

        @Override
        public String[] getManagedPropertyNames() {
            return this.managedPropertyNames;
        }
    }
}

