/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.editor;

import java.io.IOException;
import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IURIPersistenceService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.statushandler.StatusHandlerUtil;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.ui.editor.AbstractCustomFormToolkitEditorPage;
import org.eclipse.tcf.te.tcf.ui.editor.sections.AttributesSection;
import org.eclipse.tcf.te.tcf.ui.editor.sections.GeneralInformationSection;
import org.eclipse.tcf.te.tcf.ui.editor.sections.ServicesSection;
import org.eclipse.tcf.te.tcf.ui.editor.sections.TransportSection;
import org.eclipse.tcf.te.tcf.ui.help.IContextHelpIds;
import org.eclipse.tcf.te.tcf.ui.nls.Messages;
import org.eclipse.tcf.te.ui.forms.CustomFormToolkit;
import org.eclipse.tcf.te.ui.jface.interfaces.IValidatingContainer;
import org.eclipse.tcf.te.ui.views.extensions.LabelProviderDelegateExtensionPointManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class OverviewEditorPage
extends AbstractCustomFormToolkitEditorPage {
    private GeneralInformationSection infoSection;
    private TransportSection transportSection;
    private ServicesSection servicesSection;
    private AttributesSection attributesSection;
    private IEventListener listener = null;

    @Override
    protected void setInput(IEditorInput input) {
        IEditorInput oldInput = this.getEditorInput();
        if (oldInput != null && oldInput.equals(input)) {
            return;
        }
        super.setInput(input);
        if (this.listener == null) {
            this.listener = new IEventListener(){

                public void eventFired(EventObject event) {
                    ChangeEvent changeEvent = (ChangeEvent)event;
                    if (("ConnectState".equals(changeEvent.getEventId()) || "isValid".equals(changeEvent.getEventId()) || "Warnings".equals(changeEvent.getEventId())) && event.getSource() == OverviewEditorPage.this.getEditorInputNode()) {
                        ExecutorsUtil.executeInUI((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                OverviewEditorPage.this.getManagedForm().getForm().setImage(OverviewEditorPage.this.getFormImage());
                            }
                        });
                    }
                }
            };
            EventManager.getInstance().addEventListener(this.listener, ChangeEvent.class);
        }
    }

    public void dispose() {
        if (this.listener != null) {
            EventManager.getInstance().removeEventListener(this.listener);
            this.listener = null;
        }
        if (this.infoSection != null) {
            this.infoSection.dispose();
            this.infoSection = null;
        }
        if (this.transportSection != null) {
            this.transportSection.dispose();
            this.transportSection = null;
        }
        if (this.servicesSection != null) {
            this.servicesSection.dispose();
            this.servicesSection = null;
        }
        if (this.attributesSection != null) {
            this.attributesSection.dispose();
            this.attributesSection = null;
        }
        super.dispose();
    }

    protected String getContextHelpId() {
        return IContextHelpIds.OVERVIEW_EDITOR_PAGE;
    }

    protected String getFormTitle() {
        return Messages.OverviewEditorPage_title;
    }

    protected Image getFormImage() {
        ILabelProvider[] delegates;
        Image image = null;
        if (this.getEditorInputNode() instanceof IPeerNode && (delegates = LabelProviderDelegateExtensionPointManager.getInstance().getDelegates(this.getEditorInputNode(), false)) != null && delegates.length > 0 && (image = delegates[0].getImage(this.getEditorInputNode())) != null && delegates[0] instanceof ILabelDecorator) {
            image = ((ILabelDecorator)delegates[0]).decorateImage(image, this.getEditorInputNode());
        }
        return image != null ? image : UIPlugin.getImage("ConnectionObject");
    }

    protected void doCreateFormContent(Composite parent, CustomFormToolkit toolkit) {
        Assert.isNotNull((Object)parent);
        Assert.isNotNull((Object)toolkit);
        Composite panel = toolkit.getFormToolkit().createComposite(parent);
        TableWrapLayout layout = new TableWrapLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        this.infoSection = new GeneralInformationSection(this.getManagedForm(), panel);
        this.infoSection.getSection().setLayoutData((Object)new TableWrapData(256, 16));
        this.getManagedForm().addPart((IFormPart)this.infoSection);
        this.transportSection = new TransportSection(this.getManagedForm(), (Composite)this.infoSection.getSection().getClient());
        ((GridData)this.transportSection.getSection().getLayoutData()).horizontalSpan = 2;
        this.getManagedForm().addPart((IFormPart)this.transportSection);
        this.servicesSection = new ServicesSection(this.getManagedForm(), panel);
        TableWrapData layoutData = new TableWrapData(256, 16);
        this.servicesSection.getSection().setLayoutData((Object)layoutData);
        this.getManagedForm().addPart((IFormPart)this.servicesSection);
        this.attributesSection = new AttributesSection(this.getManagedForm(), panel);
        layoutData = new TableWrapData(256, 256);
        layoutData.colspan = 2;
        this.attributesSection.getSection().setLayoutData((Object)layoutData);
        this.getManagedForm().addPart((IFormPart)this.attributesSection);
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (this.infoSection != null) {
            this.infoSection.setActive(active);
        }
        if (this.transportSection != null) {
            this.transportSection.setActive(active);
        }
        if (this.servicesSection != null) {
            this.servicesSection.setActive(active);
        }
        if (this.attributesSection != null) {
            this.attributesSection.setActive(active);
        }
        this.validate();
    }

    protected IValidatingContainer.ValidationResult doValidate() {
        IValidatingContainer.ValidationResult result = super.doValidate();
        if (this.infoSection != null) {
            this.infoSection.isValid();
            result.setResult((IMessageProvider)this.infoSection);
        }
        if (this.transportSection != null) {
            this.transportSection.isValid();
            result.setResult((IMessageProvider)this.transportSection);
        }
        if (this.servicesSection != null) {
            this.servicesSection.isValid();
            result.setResult((IMessageProvider)this.servicesSection);
        }
        if (this.attributesSection != null) {
            this.attributesSection.isValid();
            result.setResult((IMessageProvider)this.attributesSection);
        }
        return result;
    }

    public void postDoSave(IProgressMonitor monitor) {
        final Object input = this.getEditorInputNode();
        if (input instanceof IPeerNode) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        IURIPersistenceService uRIPersistenceService = (IURIPersistenceService)ServiceManager.getInstance().getService(IURIPersistenceService.class);
                        if (uRIPersistenceService == null) {
                            throw new IOException("Persistence service instance unavailable.");
                        }
                        uRIPersistenceService.write((Object)((IPeerNode)input).getPeer(), null);
                    }
                    catch (IOException e) {
                        String template = NLS.bind((String)Messages.OverviewEditorPage_error_save, (Object)((IPeerNode)input).getName(), (Object)Messages.PossibleCause);
                        StatusHandlerUtil.handleStatus((IStatus)StatusHelper.getStatus((Throwable)e), (Object)input, (String)template, null, (String)IContextHelpIds.MESSAGE_SAVE_FAILED, (Object)((Object)OverviewEditorPage.this), null);
                    }
                }
            };
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
            Protocol.invokeAndWait((Runnable)runnable);
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((IPeerNode)input).fireChangeEvent("properties", null, (Object)((IPeerNode)input).getProperties());
                }
            });
        }
    }
}

