/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.registry.SynchronizeParticipantDescriptor;
import org.eclipse.team.internal.ui.registry.SynchronizeParticipantRegistry;
import org.eclipse.team.internal.ui.registry.SynchronizeWizardDescription;
import org.eclipse.team.internal.ui.registry.SynchronizeWizardRegistry;
import org.eclipse.team.ui.mapping.SaveableComparison;
import org.eclipse.team.ui.synchronize.ISynchronizeManager;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantListener;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ISynchronizeView;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class SynchronizeManager
implements ISynchronizeManager {
    private ListenerList<ISynchronizeParticipantListener> fListeners = null;
    private final SynchronizeParticipantRegistry participantRegistry = new SynchronizeParticipantRegistry();
    private final SynchronizeWizardRegistry wizardRegistry = new SynchronizeWizardRegistry();
    private Map<String, ISynchronizeParticipantReference> participantReferences = Collections.synchronizedMap(new HashMap(10));
    private static final int ADDED = 1;
    private static final int REMOVED = 2;
    private static final String CTX_PARTICIPANTS = "syncparticipants";
    private static final String CTX_PARTICIPANT = "participant";
    private static final String CTX_ID = "id";
    private static final String CTX_SECONDARY_ID = "secondary_id";
    private static final String CTX_PARTICIPANT_DISPLAY_NAME = "displayName";
    private static final String CTX_PARTICIPANT_DATA = "data";
    private static final String FILENAME = "syncParticipants.xml";

    public SynchronizeManager() {
        this.init();
    }

    @Override
    public void addSynchronizeParticipantListener(ISynchronizeParticipantListener listener) {
        if (this.fListeners == null) {
            this.fListeners = new ListenerList(1);
        }
        this.fListeners.add((Object)listener);
    }

    @Override
    public void removeSynchronizeParticipantListener(ISynchronizeParticipantListener listener) {
        if (this.fListeners != null) {
            this.fListeners.remove((Object)listener);
        }
    }

    private ParticipantInstance createParticipantReference(String type, String secondaryId, String displayName) throws PartInitException {
        SynchronizeParticipantDescriptor desc = this.participantRegistry.find(type);
        if (desc == null) {
            throw new PartInitException(NLS.bind((String)TeamUIMessages.SynchronizeManager_19, (Object[])new String[]{type}));
        }
        String key = Utils.getKey(type, secondaryId);
        ParticipantInstance ref = (ParticipantInstance)this.participantReferences.get(key);
        if (ref == null) {
            ref = new ParticipantInstance(desc, secondaryId, displayName, null);
        }
        return ref;
    }

    @Override
    public synchronized void addSynchronizeParticipants(ISynchronizeParticipant[] participants) {
        ArrayList<ISynchronizeParticipant> added = new ArrayList<ISynchronizeParticipant>(participants.length);
        ISynchronizeParticipant[] iSynchronizeParticipantArray = participants;
        int n = participants.length;
        int n2 = 0;
        while (n2 < n) {
            ISynchronizeParticipant participant = iSynchronizeParticipantArray[n2];
            String key = Utils.getKey(participant.getId(), participant.getSecondaryId());
            if (!this.participantReferences.containsKey(key)) {
                try {
                    ParticipantInstance ref = this.createParticipantReference(participant.getId(), participant.getSecondaryId(), participant.getName());
                    ref.setParticipant(participant);
                    this.removeMatchingParticipant(participant.getId());
                    this.participantReferences.put(key, ref);
                    added.add(participant);
                }
                catch (PartInitException e) {
                    TeamUIPlugin.log((CoreException)((Object)e));
                }
            }
            ++n2;
        }
        if (!added.isEmpty()) {
            this.saveState();
            this.fireUpdate(added.toArray(new ISynchronizeParticipant[added.size()]), 1);
        }
    }

    private void removeMatchingParticipant(String id) {
        ISynchronizeParticipantReference[] refs = this.get(id);
        if (refs.length > 0) {
            ISynchronizeParticipantReference[] iSynchronizeParticipantReferenceArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ISynchronizeParticipantReference reference = iSynchronizeParticipantReferenceArray[n2];
                try {
                    ISynchronizeParticipant p = reference.getParticipant();
                    if (!p.isPinned() && !this.isDirty(p)) {
                        this.removeSynchronizeParticipants(new ISynchronizeParticipant[]{p});
                        break;
                    }
                }
                catch (TeamException teamException) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    private boolean isDirty(ISynchronizeParticipant p) {
        ModelSynchronizeParticipant msp;
        SaveableComparison s;
        return p instanceof ModelSynchronizeParticipant && (s = (msp = (ModelSynchronizeParticipant)p).getActiveSaveable()) != null && s.isDirty();
    }

    @Override
    public synchronized void removeSynchronizeParticipants(ISynchronizeParticipant[] participants) {
        ArrayList<ISynchronizeParticipant> removed = new ArrayList<ISynchronizeParticipant>(participants.length);
        ISynchronizeParticipant[] iSynchronizeParticipantArray = participants;
        int n = participants.length;
        int n2 = 0;
        while (n2 < n) {
            ISynchronizeParticipant participant = iSynchronizeParticipantArray[n2];
            String key = Utils.getKey(participant.getId(), participant.getSecondaryId());
            if (this.participantReferences.containsKey(key)) {
                ParticipantInstance ref = (ParticipantInstance)this.participantReferences.remove(key);
                if (ref.isInstantiated()) {
                    ref.dispose();
                }
                removed.add(participant);
            }
            ++n2;
        }
        if (!removed.isEmpty()) {
            this.saveState();
            this.fireUpdate(removed.toArray(new ISynchronizeParticipant[removed.size()]), 2);
        }
    }

    @Override
    public ISynchronizeParticipantReference get(String id, String secondaryId) {
        String key = Utils.getKey(id, secondaryId);
        return this.participantReferences.get(key);
    }

    @Override
    public ISynchronizeParticipantReference[] get(String id) {
        ISynchronizeParticipantReference[] refs = this.getSynchronizeParticipants();
        ArrayList<ISynchronizeParticipantReference> refsForId = new ArrayList<ISynchronizeParticipantReference>();
        ISynchronizeParticipantReference[] iSynchronizeParticipantReferenceArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            ISynchronizeParticipantReference reference = iSynchronizeParticipantReferenceArray[n2];
            if (reference.getId().equals(id)) {
                refsForId.add(reference);
            }
            ++n2;
        }
        return refsForId.toArray(new ISynchronizeParticipantReference[refsForId.size()]);
    }

    @Override
    public synchronized ISynchronizeParticipantReference[] getSynchronizeParticipants() {
        return this.participantReferences.values().toArray(new ISynchronizeParticipantReference[this.participantReferences.size()]);
    }

    @Override
    public ISynchronizeView showSynchronizeViewInActivePage() {
        IWorkbenchPage activePage;
        block8: {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            boolean switchPerspectives = this.promptForPerspectiveSwitch();
            activePage = null;
            if (switchPerspectives) {
                try {
                    String pId = TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.syncview_default_perspective");
                    activePage = workbench.showPerspective(pId, window);
                }
                catch (WorkbenchException e) {
                    Utils.handleError(window.getShell(), (Exception)((Object)e), TeamUIMessages.SynchronizeView_14, e.getMessage());
                }
            }
            try {
                if (activePage != null || (activePage = TeamUIPlugin.getActivePage()) != null) break block8;
                return null;
            }
            catch (PartInitException pe) {
                Utils.handleError(window.getShell(), (Exception)((Object)pe), TeamUIMessages.SynchronizeView_16, pe.getMessage());
                return null;
            }
        }
        IViewPart part = activePage.showView("org.eclipse.team.sync.views.SynchronizeView");
        try {
            return (ISynchronizeView)part;
        }
        catch (ClassCastException e) {
            TeamUIPlugin.log(4, NLS.bind((String)TeamUIMessages.SynchronizeManager_18, (Object[])new String[]{part.getClass().getName()}), e);
            return null;
        }
    }

    private boolean promptForPerspectiveSwitch() {
        IPerspectiveDescriptor p;
        IPreferenceStore store = TeamUIPlugin.getPlugin().getPreferenceStore();
        String option = store.getString("org.eclipse.team.ui.sychronizing_default_perspective_to_show");
        if (option.equals("always")) {
            return true;
        }
        if (option.equals("never")) {
            return false;
        }
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        String defaultSyncPerspectiveId = store.getString("org.eclipse.team.ui.syncview_default_perspective");
        IPerspectiveDescriptor perspectiveDescriptor = registry.findPerspectiveWithId(defaultSyncPerspectiveId);
        IWorkbenchPage page = TeamUIPlugin.getActivePage();
        if (page != null && (p = page.getPerspective()) != null && p.getId().equals(defaultSyncPerspectiveId)) {
            return false;
        }
        if (perspectiveDescriptor != null) {
            String desc = perspectiveDescriptor.getDescription();
            String message = desc == null ? NLS.bind((String)TeamUIMessages.SynchronizeManager_30, (Object[])new String[]{perspectiveDescriptor.getLabel()}) : NLS.bind((String)TeamUIMessages.SynchronizeManager_32, (Object[])new String[]{perspectiveDescriptor.getLabel(), desc});
            MessageDialogWithToggle m = MessageDialogWithToggle.openYesNoQuestion((Shell)Utils.getShell(null), (String)TeamUIMessages.SynchronizeManager_27, (String)message, (String)TeamUIMessages.SynchronizeManager_31, (boolean)false, (IPreferenceStore)store, (String)"org.eclipse.team.ui.sychronizing_default_perspective_to_show");
            return m.getReturnCode() == 2;
        }
        return false;
    }

    public void init() {
        try {
            this.participantRegistry.readRegistry(Platform.getExtensionRegistry(), "org.eclipse.team.ui", "synchronizeParticipants");
            this.wizardRegistry.readRegistry(Platform.getExtensionRegistry(), "org.eclipse.team.ui", "synchronizeWizards");
            this.restoreSavedParticipants();
        }
        catch (CoreException e) {
            TeamUIPlugin.log((IStatus)new Status(4, "org.eclipse.team.ui", 1, TeamUIMessages.SynchronizeManager_8, (Throwable)e));
        }
    }

    public void dispose() {
        this.saveState();
        for (ISynchronizeParticipantReference element : this.participantReferences.values()) {
            ParticipantInstance ref = (ParticipantInstance)element;
            if (!ref.isInstantiated()) continue;
            try {
                ref.getParticipant().dispose();
            }
            catch (TeamException teamException) {
                // empty catch block
            }
        }
        this.participantReferences = null;
    }

    private void restoreSavedParticipants() throws CoreException {
        IMemento[] participantNodes;
        BufferedReader reader;
        File file = this.getStateFile();
        try {
            reader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            return;
        }
        XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
        IMemento[] iMementoArray = participantNodes = memento.getChildren(CTX_PARTICIPANT);
        int n = participantNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento memento2 = iMementoArray[n2];
            String id = memento2.getString(CTX_ID);
            String secondayId = memento2.getString(CTX_SECONDARY_ID);
            if (secondayId != null) {
                String displayName = memento2.getString(CTX_PARTICIPANT_DISPLAY_NAME);
                SynchronizeParticipantDescriptor desc = this.participantRegistry.find(id);
                if (desc != null) {
                    String key = Utils.getKey(id, secondayId);
                    this.participantReferences.put(key, new ParticipantInstance(desc, secondayId, displayName, memento2.getChild(CTX_PARTICIPANT_DATA)));
                } else {
                    TeamUIPlugin.log((IStatus)new Status(4, "org.eclipse.team.ui", 1, NLS.bind((String)TeamUIMessages.SynchronizeManager_9, (Object[])new String[]{id}), null));
                }
            }
            ++n2;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void saveState() {
        XMLMemento xmlMemento = XMLMemento.createWriteRoot((String)CTX_PARTICIPANTS);
        for (ISynchronizeParticipantReference iSynchronizeParticipantReference : this.participantReferences.values()) {
            ParticipantInstance ref = (ParticipantInstance)iSynchronizeParticipantReference;
            if (!ref.getDescriptor().isPersistent()) continue;
            IMemento participantNode = xmlMemento.createChild(CTX_PARTICIPANT);
            participantNode.putString(CTX_ID, ref.getId());
            String secondaryId = ref.getSecondaryId();
            if (secondaryId != null) {
                participantNode.putString(CTX_SECONDARY_ID, secondaryId);
            }
            participantNode.putString(CTX_PARTICIPANT_DISPLAY_NAME, ref.getDisplayName());
            IMemento participantData = participantNode.createChild(CTX_PARTICIPANT_DATA);
            ref.save(participantData);
        }
        try {
            Throwable throwable = null;
            Iterator<ISynchronizeParticipantReference> iterator = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.getStateFile()));){
                xmlMemento.save((Writer)writer);
            }
            catch (Throwable throwable2) {
                void var2_8;
                if (throwable == null) {
                    Throwable throwable3 = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw var2_8;
            }
        }
        catch (IOException iOException) {
            TeamUIPlugin.log((IStatus)new Status(4, "org.eclipse.team.ui", 1, TeamUIMessages.SynchronizeManager_10, (Throwable)iOException));
        }
    }

    private File getStateFile() {
        IPath pluginStateLocation = TeamUIPlugin.getPlugin().getStateLocation();
        return pluginStateLocation.append(FILENAME).toFile();
    }

    private void fireUpdate(ISynchronizeParticipant[] participants, int type) {
        new SynchronizeViewPageNotifier().notify(participants, type);
    }

    @Override
    public ISynchronizeParticipantDescriptor getParticipantDescriptor(String id) {
        return this.participantRegistry.find(id);
    }

    public SynchronizeWizardDescription[] getWizardDescriptors() {
        return this.wizardRegistry.getSynchronizeWizards();
    }

    private class ParticipantInstance
    implements ISynchronizeParticipantReference {
        private final Map<String, ISynchronizeParticipant> participants = new HashMap<String, ISynchronizeParticipant>();
        private IMemento savedState;
        private final SynchronizeParticipantDescriptor descriptor;
        private final String secondaryId;
        private final String displayName;
        private boolean dead;

        public ParticipantInstance(SynchronizeParticipantDescriptor descriptor, String secondaryId, String displayName, IMemento savedState) {
            this.secondaryId = secondaryId;
            this.savedState = savedState;
            this.descriptor = descriptor;
            this.displayName = displayName;
        }

        public void save(IMemento memento) {
            if (this.dead) {
                return;
            }
            String key = Utils.getKey(this.descriptor.getId(), this.getSecondaryId());
            ISynchronizeParticipant ref = this.participants.get(key);
            if (ref != null) {
                ref.saveState(memento);
            } else if (this.savedState != null) {
                memento.putMemento(this.savedState);
            }
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof ISynchronizeParticipantReference)) {
                return false;
            }
            ISynchronizeParticipantReference otherRef = (ISynchronizeParticipantReference)other;
            String otherSecondaryId = otherRef.getSecondaryId();
            return otherRef.getId().equals(this.getId()) && Utils.equalObject(this.getSecondaryId(), otherSecondaryId);
        }

        @Override
        public String getId() {
            return this.descriptor.getId();
        }

        @Override
        public String getSecondaryId() {
            return this.secondaryId;
        }

        @Override
        public String getDisplayName() {
            String key = Utils.getKey(this.descriptor.getId(), this.getSecondaryId());
            ISynchronizeParticipant participant = this.participants.get(key);
            if (participant != null) {
                return participant.getName();
            }
            return this.displayName != null ? this.displayName : this.descriptor.getName();
        }

        public boolean isInstantiated() {
            String key = Utils.getKey(this.descriptor.getId(), this.getSecondaryId());
            return this.participants.get(key) != null;
        }

        @Override
        public ISynchronizeParticipant getParticipant() throws TeamException {
            if (this.dead) {
                return null;
            }
            String key = Utils.getKey(this.descriptor.getId(), this.getSecondaryId());
            try {
                ISynchronizeParticipant participant = this.participants.get(key);
                if (participant == null && (participant = this.instantiate()) != null) {
                    this.participants.put(key, participant);
                }
                return participant;
            }
            catch (TeamException e) {
                TeamUIPlugin.log((CoreException)((Object)e));
                SynchronizeManager.this.participantReferences.remove(key);
                throw new TeamException(TeamUIMessages.SynchronizeManager_8, (Throwable)e);
            }
        }

        public void setParticipant(ISynchronizeParticipant participant) {
            String key = Utils.getKey(this.descriptor.getId(), this.getSecondaryId());
            this.participants.put(key, participant);
        }

        @Override
        public ISynchronizeParticipantDescriptor getDescriptor() {
            return this.descriptor;
        }

        private ISynchronizeParticipant instantiate() throws TeamException {
            try {
                ISynchronizeParticipant participant = (ISynchronizeParticipant)TeamUIPlugin.createExtension(this.descriptor.getConfigurationElement(), "class");
                participant.setInitializationData(this.descriptor.getConfigurationElement(), null, null);
                participant.init(this.getSecondaryId(), this.savedState);
                this.savedState = null;
                return participant;
            }
            catch (PartInitException e) {
                throw new TeamException(NLS.bind((String)TeamUIMessages.SynchronizeManager_11, (Object[])new String[]{this.descriptor.getName()}), (Throwable)e);
            }
            catch (CoreException e) {
                throw TeamException.asTeamException((CoreException)e);
            }
            catch (Exception e) {
                throw new TeamException(NLS.bind((String)TeamUIMessages.SynchronizeManager_11, (Object[])new String[]{this.descriptor.getName()}), (Throwable)e);
            }
        }

        public void dispose() {
            try {
                try {
                    ISynchronizeParticipant participant = this.getParticipant();
                    if (participant != null) {
                        participant.dispose();
                    }
                }
                catch (TeamException teamException) {
                    this.dead = true;
                }
            }
            finally {
                this.dead = true;
            }
        }
    }

    class SynchronizeViewPageNotifier
    implements ISafeRunnable {
        private ISynchronizeParticipantListener fListener;
        private int fType;
        private ISynchronizeParticipant[] fChanged;

        SynchronizeViewPageNotifier() {
        }

        public void handleException(Throwable exception) {
            TeamUIPlugin.log(4, TeamUIMessages.SynchronizeManager_7, exception);
        }

        public void run() throws Exception {
            switch (this.fType) {
                case 1: {
                    this.fListener.participantsAdded(this.fChanged);
                    break;
                }
                case 2: {
                    this.fListener.participantsRemoved(this.fChanged);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Integer.toString(this.fType));
                }
            }
        }

        public void notify(ISynchronizeParticipant[] participants, int update) {
            Object[] copiedListeners;
            if (SynchronizeManager.this.fListeners == null) {
                return;
            }
            this.fChanged = participants;
            this.fType = update;
            Object[] objectArray = copiedListeners = SynchronizeManager.this.fListeners.getListeners();
            int n = copiedListeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object copiedListener = objectArray[n2];
                this.fListener = (ISynchronizeParticipantListener)copiedListener;
                SafeRunner.run((ISafeRunnable)this);
                ++n2;
            }
            this.fChanged = null;
            this.fListener = null;
        }
    }
}

