/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.lib.annotations;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.AccessorsDeprecationPolicy;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructorProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.TransformationParticipant;
import org.eclipse.xtend.lib.macro.declaration.AnnotationReference;
import org.eclipse.xtend.lib.macro.declaration.AnnotationTarget;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MethodDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableClassDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableMemberDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@Beta
public class AccessorsProcessor
implements TransformationParticipant<MutableMemberDeclaration> {
    public void doTransform(List<? extends MutableMemberDeclaration> elements, @Extension TransformationContext context) {
        Consumer<MutableMemberDeclaration> _function = it -> this.transform((MutableMemberDeclaration)it, context);
        elements.forEach(_function);
    }

    protected void _transform(MutableFieldDeclaration it, @Extension TransformationContext context) {
        Util util = new Util(context);
        AnnotationReference annot = util.getAccessorsAnnotation((AnnotationTarget)it);
        boolean _shouldAddGetter = util.shouldAddGetter((FieldDeclaration)it);
        if (_shouldAddGetter) {
            util.addGetter(it, util.toVisibility(util.getGetterType((FieldDeclaration)it)));
        } else if (annot != null && util.getDeprecationPolicyAsEnum(annot) == AccessorsDeprecationPolicy.ONLY_GETTER) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Field ");
            String _simpleName = it.getSimpleName();
            _builder.append(_simpleName);
            _builder.append(" needs no getter, but deprecationPolicy is ONLY_GETTER.");
            _builder.newLineIfNotEmpty();
            _builder.append("Explicitly setting it has no effect, as no getter will be generated.");
            _builder.newLine();
            _builder.append("Use deprecation policy NEVER to disable accessors deprecation and remove this warning.");
            _builder.newLine();
            context.addWarning((Element)it, _builder.toString());
        }
        boolean _shouldAddSetter = util.shouldAddSetter((FieldDeclaration)it);
        if (_shouldAddSetter) {
            util.addSetter(it, util.toVisibility(util.getSetterType((FieldDeclaration)it)));
        } else if (annot != null && util.getDeprecationPolicyAsEnum(annot) == AccessorsDeprecationPolicy.ONLY_SETTER) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Field ");
            String _simpleName_1 = it.getSimpleName();
            _builder_1.append(_simpleName_1);
            _builder_1.append(" needs no setter, but deprecationPolicy is ONLY_SETTER.");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("Explicitly setting it has no effect, as no setter will be generated.");
            _builder_1.newLine();
            _builder_1.append("Use deprecation policy NEVER to disable accessors deprecation and remove this warning.");
            _builder_1.newLine();
            context.addWarning((Element)it, _builder_1.toString());
        }
    }

    protected void _transform(MutableClassDeclaration it, @Extension TransformationContext context) {
        boolean _tripleNotEquals;
        AnnotationReference _findAnnotation = it.findAnnotation(context.findTypeGlobally(Data.class));
        boolean bl = _tripleNotEquals = _findAnnotation != null;
        if (_tripleNotEquals) {
            return;
        }
        FinalFieldsConstructorProcessor.Util requiredArgsUtil = new FinalFieldsConstructorProcessor.Util(context);
        if (requiredArgsUtil.needsFinalFieldConstructor(it) || it.findAnnotation(context.findTypeGlobally(FinalFieldsConstructor.class)) != null) {
            requiredArgsUtil.addFinalFieldsConstructor(it);
        }
        Functions.Function1 _function = it_1 -> !it_1.isStatic() && context.isThePrimaryGeneratedJavaElement((Element)it_1);
        Consumer<MutableFieldDeclaration> _function_1 = it_1 -> this._transform((MutableFieldDeclaration)it_1, context);
        IterableExtensions.filter((Iterable)it.getDeclaredFields(), (Functions.Function1)_function).forEach(_function_1);
    }

    @XbaseGenerated
    public void transform(MutableMemberDeclaration it, TransformationContext context) {
        if (it instanceof MutableClassDeclaration) {
            this._transform((MutableClassDeclaration)it, context);
            return;
        }
        if (it instanceof MutableFieldDeclaration) {
            this._transform((MutableFieldDeclaration)it, context);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it, context).toString());
    }

    @Beta
    public static class Util {
        @Extension
        private TransformationContext context;

        public Util(TransformationContext context) {
            this.context = context;
        }

        public Visibility toVisibility(AccessorType type) {
            Visibility _switchResult;
            block11: {
                block10: {
                    _switchResult = null;
                    if (type == null) break block10;
                    switch (type) {
                        case PUBLIC_GETTER: {
                            _switchResult = Visibility.PUBLIC;
                            break block11;
                        }
                        case PROTECTED_GETTER: {
                            _switchResult = Visibility.PROTECTED;
                            break block11;
                        }
                        case PACKAGE_GETTER: {
                            _switchResult = Visibility.DEFAULT;
                            break block11;
                        }
                        case PRIVATE_GETTER: {
                            _switchResult = Visibility.PRIVATE;
                            break block11;
                        }
                        case PUBLIC_SETTER: {
                            _switchResult = Visibility.PUBLIC;
                            break block11;
                        }
                        case PROTECTED_SETTER: {
                            _switchResult = Visibility.PROTECTED;
                            break block11;
                        }
                        case PACKAGE_SETTER: {
                            _switchResult = Visibility.DEFAULT;
                            break block11;
                        }
                        case PRIVATE_SETTER: {
                            _switchResult = Visibility.PRIVATE;
                            break block11;
                        }
                        default: {
                            StringConcatenation _builder = new StringConcatenation();
                            _builder.append("Cannot convert ");
                            _builder.append((Object)type);
                            throw new IllegalArgumentException(_builder.toString());
                        }
                    }
                }
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Cannot convert ");
                _builder.append((Object)type);
                throw new IllegalArgumentException(_builder.toString());
            }
            return _switchResult;
        }

        public boolean hasGetter(FieldDeclaration it) {
            Functions.Function1 _function = name -> {
                MethodDeclaration _findDeclaredMethod = it.getDeclaringType().findDeclaredMethod(name, new TypeReference[0]);
                return _findDeclaredMethod != null;
            };
            return IterableExtensions.exists(this.getPossibleGetterNames(it), (Functions.Function1)_function);
        }

        public boolean shouldAddGetter(FieldDeclaration it) {
            return !this.hasGetter(it) && this.getGetterType(it) != AccessorType.NONE;
        }

        public AccessorType getGetterType(FieldDeclaration it) {
            AnnotationReference _accessorsAnnotation_1;
            AnnotationReference _elvis = null;
            AnnotationReference _accessorsAnnotation = this.getAccessorsAnnotation((AnnotationTarget)it);
            _elvis = _accessorsAnnotation != null ? _accessorsAnnotation : (_accessorsAnnotation_1 = this.getAccessorsAnnotation((AnnotationTarget)it.getDeclaringType()));
            AnnotationReference annotation = _elvis;
            if (annotation != null) {
                Functions.Function1 _function = it_1 -> AccessorType.valueOf(it_1.getSimpleName());
                List types = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)annotation.getEnumArrayValue("value"))), (Functions.Function1)_function);
                AccessorType _elvis_1 = null;
                Functions.Function1 _function_1 = it_1 -> it_1.name().endsWith("GETTER");
                AccessorType _findFirst = (AccessorType)((Object)IterableExtensions.findFirst((Iterable)types, (Functions.Function1)_function_1));
                _elvis_1 = _findFirst != null ? _findFirst : AccessorType.NONE;
                return _elvis_1;
            }
            return null;
        }

        public AnnotationReference getAccessorsAnnotation(AnnotationTarget it) {
            return it.findAnnotation(this.context.findTypeGlobally(Accessors.class));
        }

        public AnnotationReference getDeprecatedAnnotation(AnnotationTarget it) {
            return it.findAnnotation(this.context.findTypeGlobally(Deprecated.class));
        }

        public AccessorsDeprecationPolicy getDeprecationPolicyAsEnum(AnnotationReference annot) {
            return AccessorsDeprecationPolicy.valueOf(annot.getEnumValue("deprecationPolicy").getSimpleName());
        }

        public Object validateGetter(MutableFieldDeclaration field) {
            return null;
        }

        public String getGetterName(FieldDeclaration it) {
            return (String)IterableExtensions.head(this.getPossibleGetterNames(it));
        }

        public List<String> getPossibleGetterNames(FieldDeclaration it) {
            ArrayList names = CollectionLiterals.newArrayList();
            if (this.isBooleanType(this.orObject(it.getType())) && it.getSimpleName().startsWith("is") && it.getSimpleName().length() > 2 && Character.isUpperCase(it.getSimpleName().charAt(2))) {
                String _simpleName = it.getSimpleName();
                names.add(_simpleName);
            }
            List _xifexpression = null;
            boolean _isBooleanType = this.isBooleanType(this.orObject(it.getType()));
            _xifexpression = _isBooleanType ? Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"is", "get"})) : Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{"get"}));
            Functions.Function1 _function = prefix -> {
                String _firstUpper = StringExtensions.toFirstUpper((String)it.getSimpleName());
                return prefix + _firstUpper;
            };
            names.addAll(ListExtensions.map(_xifexpression, (Functions.Function1)_function));
            return names;
        }

        public boolean isBooleanType(TypeReference it) {
            return !it.isInferred() && Objects.equals(it, this.context.getPrimitiveBoolean());
        }

        public void addGetter(final MutableFieldDeclaration field, Visibility visibility) {
            this.validateGetter(field);
            field.markAsRead();
            Procedures.Procedure1 _function = it -> {
                block9: {
                    block10: {
                        AnnotationReference annot;
                        boolean _not;
                        this.context.setPrimarySourceElement((MutableElement)it, this.context.getPrimarySourceElement((Element)field));
                        it.addAnnotation(this.context.newAnnotationReference(Pure.class));
                        Iterable superGetters = it.getOverriddenOrImplementedMethods();
                        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)superGetters);
                        boolean bl = _not = !_isEmpty;
                        if (_not) {
                            Functions.Function1 _function_1 = it_1 -> it_1.isFinal();
                            boolean _exists = IterableExtensions.exists((Iterable)superGetters, (Functions.Function1)_function_1);
                            if (_exists) {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append("Adding a getter to the field ");
                                String _simpleName = field.getSimpleName();
                                _builder.append(_simpleName);
                                _builder.append(" would override a final method.");
                                this.context.addError((Element)field, _builder.toString());
                            } else {
                                it.addAnnotation(this.context.newAnnotationReference(Override.class));
                            }
                        }
                        if ((annot = this.getAccessorsAnnotation((AnnotationTarget)field)) == null) break block9;
                        AccessorsDeprecationPolicy _deprecationPolicyAsEnum = this.getDeprecationPolicyAsEnum(annot);
                        if (_deprecationPolicyAsEnum == null) break block10;
                        switch (_deprecationPolicyAsEnum) {
                            case ONLY_GETTER: 
                            case ALWAYS: {
                                it.addAnnotation(this.context.newAnnotationReference(Deprecated.class));
                                break block9;
                            }
                            case SAME_AS_FIELD: {
                                boolean _tripleNotEquals;
                                AnnotationReference _deprecatedAnnotation = this.getDeprecatedAnnotation((AnnotationTarget)field);
                                boolean bl2 = _tripleNotEquals = _deprecatedAnnotation != null;
                                if (_tripleNotEquals) {
                                    it.addAnnotation(this.context.newAnnotationReference(Deprecated.class));
                                }
                                break block9;
                            }
                            case ONLY_SETTER: 
                            case NEVER: {
                                break block9;
                            }
                            default: {
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append("Cannot determine deprecation policy for field ");
                                String _simpleName_1 = field.getSimpleName();
                                _builder_1.append(_simpleName_1);
                                throw new IllegalArgumentException(_builder_1.toString());
                            }
                        }
                    }
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Cannot determine deprecation policy for field ");
                    String _simpleName_1 = field.getSimpleName();
                    _builder_1.append(_simpleName_1);
                    throw new IllegalArgumentException(_builder_1.toString());
                }
                it.setReturnType(this.orObject(field.getType()));
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"return ");
                        Object _fieldOwner = this.fieldOwner(field);
                        _builder.append(_fieldOwner);
                        _builder.append((Object)".");
                        String _simpleName = field.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)";");
                    }
                };
                it.setBody(_client);
                it.setStatic(field.isStatic());
                it.setVisibility(visibility);
            };
            field.getDeclaringType().addMethod(this.getGetterName((FieldDeclaration)field), _function);
        }

        public AccessorType getSetterType(FieldDeclaration it) {
            AnnotationReference _accessorsAnnotation_1;
            AnnotationReference _elvis = null;
            AnnotationReference _accessorsAnnotation = this.getAccessorsAnnotation((AnnotationTarget)it);
            _elvis = _accessorsAnnotation != null ? _accessorsAnnotation : (_accessorsAnnotation_1 = this.getAccessorsAnnotation((AnnotationTarget)it.getDeclaringType()));
            AnnotationReference annotation = _elvis;
            if (annotation != null) {
                Functions.Function1 _function = it_1 -> AccessorType.valueOf(it_1.getSimpleName());
                List types = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)annotation.getEnumArrayValue("value"))), (Functions.Function1)_function);
                AccessorType _elvis_1 = null;
                Functions.Function1 _function_1 = it_1 -> it_1.name().endsWith("SETTER");
                AccessorType _findFirst = (AccessorType)((Object)IterableExtensions.findFirst((Iterable)types, (Functions.Function1)_function_1));
                _elvis_1 = _findFirst != null ? _findFirst : AccessorType.NONE;
                return _elvis_1;
            }
            return null;
        }

        private Object fieldOwner(MutableFieldDeclaration it) {
            String _xifexpression = null;
            boolean _isStatic = it.isStatic();
            _xifexpression = _isStatic ? this.context.newTypeReference((Type)it.getDeclaringType(), new TypeReference[0]) : "this";
            return _xifexpression;
        }

        public boolean hasSetter(FieldDeclaration it) {
            MethodDeclaration _findDeclaredMethod = it.getDeclaringType().findDeclaredMethod(this.getSetterName(it), new TypeReference[]{this.orObject(it.getType())});
            return _findDeclaredMethod != null;
        }

        public String getSetterName(FieldDeclaration it) {
            String _firstUpper = StringExtensions.toFirstUpper((String)it.getSimpleName());
            return "set" + _firstUpper;
        }

        public boolean shouldAddSetter(FieldDeclaration it) {
            return !it.isFinal() && !this.hasSetter(it) && this.getSetterType(it) != AccessorType.NONE;
        }

        public void validateSetter(MutableFieldDeclaration field) {
            boolean _isFinal = field.isFinal();
            if (_isFinal) {
                this.context.addError((Element)field, "Cannot set a final field");
            }
            if (field.getType() == null || field.getType().isInferred()) {
                this.context.addError((Element)field, "Type cannot be inferred.");
                return;
            }
        }

        public void addSetter(final MutableFieldDeclaration field, Visibility visibility) {
            this.validateSetter(field);
            Procedures.Procedure1 _function = it -> {
                block9: {
                    block10: {
                        AnnotationReference annot;
                        boolean _not;
                        this.context.setPrimarySourceElement((MutableElement)it, this.context.getPrimarySourceElement((Element)field));
                        it.setReturnType(this.context.getPrimitiveVoid());
                        Iterable superSetters = it.getOverriddenOrImplementedMethods();
                        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)superSetters);
                        boolean bl = _not = !_isEmpty;
                        if (_not) {
                            Functions.Function1 _function_1 = it_1 -> it_1.isFinal();
                            boolean _exists = IterableExtensions.exists((Iterable)superSetters, (Functions.Function1)_function_1);
                            if (_exists) {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append("Adding a setter to the field ");
                                String _simpleName = field.getSimpleName();
                                _builder.append(_simpleName);
                                _builder.append(" would override a final method.");
                                this.context.addError((Element)field, _builder.toString());
                            } else {
                                it.addAnnotation(this.context.newAnnotationReference(Override.class));
                            }
                        }
                        if ((annot = this.getAccessorsAnnotation((AnnotationTarget)field)) == null) break block9;
                        AccessorsDeprecationPolicy _deprecationPolicyAsEnum = this.getDeprecationPolicyAsEnum(annot);
                        if (_deprecationPolicyAsEnum == null) break block10;
                        switch (_deprecationPolicyAsEnum) {
                            case ONLY_SETTER: 
                            case ALWAYS: {
                                it.addAnnotation(this.context.newAnnotationReference(Deprecated.class));
                                break block9;
                            }
                            case SAME_AS_FIELD: {
                                boolean _tripleNotEquals;
                                AnnotationReference _deprecatedAnnotation = this.getDeprecatedAnnotation((AnnotationTarget)field);
                                boolean bl2 = _tripleNotEquals = _deprecatedAnnotation != null;
                                if (_tripleNotEquals) {
                                    it.addAnnotation(this.context.newAnnotationReference(Deprecated.class));
                                }
                                break block9;
                            }
                            case ONLY_GETTER: 
                            case NEVER: {
                                break block9;
                            }
                            default: {
                                StringConcatenation _builder_1 = new StringConcatenation();
                                _builder_1.append("Cannot determine deprecation policy for field ");
                                String _simpleName_1 = field.getSimpleName();
                                _builder_1.append(_simpleName_1);
                                throw new IllegalArgumentException(_builder_1.toString());
                            }
                        }
                    }
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("Cannot determine deprecation policy for field ");
                    String _simpleName_1 = field.getSimpleName();
                    _builder_1.append(_simpleName_1);
                    throw new IllegalArgumentException(_builder_1.toString());
                }
                final MutableParameterDeclaration param = it.addParameter(field.getSimpleName(), this.orObject(field.getType()));
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        Object _fieldOwner = this.fieldOwner(field);
                        _builder.append(_fieldOwner);
                        _builder.append((Object)".");
                        String _simpleName = field.getSimpleName();
                        _builder.append((Object)_simpleName);
                        _builder.append((Object)" = ");
                        String _simpleName_1 = param.getSimpleName();
                        _builder.append((Object)_simpleName_1);
                        _builder.append((Object)";");
                    }
                };
                it.setBody(_client);
                it.setStatic(field.isStatic());
                it.setVisibility(visibility);
            };
            field.getDeclaringType().addMethod(this.getSetterName((FieldDeclaration)field), _function);
        }

        private TypeReference orObject(TypeReference ref) {
            TypeReference _xifexpression = null;
            _xifexpression = ref == null ? this.context.getObject() : ref;
            return _xifexpression;
        }
    }
}

