/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.internal.utils;

import org.eclipse.acceleo.engine.AcceleoEnginePlugin;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public final class AcceleoListenerDescriptor {
    private final IConfigurationElement element;
    private final String className;
    private IAcceleoTextGenerationListener listener;
    private final String nature;
    private final boolean forceTraceability;

    public AcceleoListenerDescriptor(IConfigurationElement elem) {
        this.element = elem;
        this.className = elem.getAttribute("class");
        this.nature = elem.getAttribute("nature");
        String traceability = elem.getAttribute("forceTraceability");
        this.forceTraceability = Boolean.valueOf(traceability);
    }

    public IAcceleoTextGenerationListener getTraceabilityListener() {
        if (this.listener == null) {
            try {
                Object object = this.element.createExecutableExtension("class");
                if (object instanceof IAcceleoTextGenerationListener) {
                    this.listener = (IAcceleoTextGenerationListener)object;
                }
            }
            catch (CoreException e) {
                AcceleoEnginePlugin.log((Exception)((Object)e), false);
            }
        }
        return this.listener;
    }

    public Object getName() {
        return this.className;
    }

    public String getNature() {
        return this.nature;
    }

    public boolean isForceTraceability() {
        return this.forceTraceability;
    }
}

