/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.debug.actions;

import org.eclipse.acceleo.engine.internal.debug.ASTFragment;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.debug.actions.AbstractBreakpointRulerAction;
import org.eclipse.acceleo.internal.ide.ui.debug.model.AcceleoLineBreakpoint;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.ui.texteditor.ITextEditor;

public class BreakpointSelectModelRulerAction
extends AbstractBreakpointRulerAction {
    public BreakpointSelectModelRulerAction(ITextEditor editor, IVerticalRulerInfo rulerInfo) {
        this.setInfo(rulerInfo);
        this.setTextEditor(editor);
        this.setText(AcceleoUIMessages.getString("BreakpointSelectModelRulerAction.Text"));
    }

    public void run() {
        IBreakpoint breakPoint = this.getBreakpoint();
        if (breakPoint != null && breakPoint.getMarker() != null) {
            try {
                ASTFragment astFragment = new ASTFragment(breakPoint.getMarker().getAttribute("astFragment", ""));
                InputDialog dialog = new InputDialog(this.getTextEditor().getSite().getShell(), AcceleoUIMessages.getString("BreakpointSelectModelRulerAction.Text"), AcceleoUIMessages.getString("BreakpointSelectModelRulerAction.DialogMessage"), astFragment.getEObjectNameFilter(), null);
                if (dialog.open() == 0 && dialog.getValue() != null) {
                    astFragment.setEObjectNameFilter(dialog.getValue());
                    breakPoint.getMarker().setAttribute("astFragment", (Object)astFragment.toString());
                }
            }
            catch (CoreException e) {
                AcceleoUIActivator.getDefault().getLog().log(e.getStatus());
            }
        }
    }

    public void update() {
        this.setBreakpoint(this.determineBreakpoint());
        if (this.getBreakpoint() == null || !(this.getBreakpoint() instanceof AcceleoLineBreakpoint)) {
            this.setBreakpoint(null);
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

