/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cmake.core.internal;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.cmake.core.CMakeToolChainEvent;
import org.eclipse.cdt.cmake.core.ICMakeToolChainFile;
import org.eclipse.cdt.cmake.core.ICMakeToolChainListener;
import org.eclipse.cdt.cmake.core.ICMakeToolChainManager;
import org.eclipse.cdt.cmake.core.ICMakeToolChainProvider;
import org.eclipse.cdt.cmake.core.internal.Activator;
import org.eclipse.cdt.cmake.core.internal.CMakeToolChainFile;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CMakeToolChainManager
implements ICMakeToolChainManager {
    private Map<String, ICMakeToolChainFile> filesByToolChain;
    private static final String N = "n";
    private static final String PATH = "__path";
    private final List<ICMakeToolChainListener> listeners = new LinkedList<ICMakeToolChainListener>();

    private Preferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(Activator.getId()).node("cmakeToolchains");
    }

    public static String makeToolChainId(String tcType, String tcId) {
        return tcType + "/" + tcId;
    }

    public static String makeToolChainId(IToolChain toolchain) {
        return CMakeToolChainManager.makeToolChainId(toolchain.getTypeId(), toolchain.getId());
    }

    private synchronized void init() {
        if (this.filesByToolChain == null) {
            int n;
            this.filesByToolChain = new HashMap<String, ICMakeToolChainFile>();
            Preferences prefs = this.getPreferences();
            try {
                String[] stringArray = prefs.childrenNames();
                n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String childName = stringArray[n2];
                    Preferences tcNode = prefs.node(childName);
                    String pathStr = tcNode.get(PATH, "/");
                    String tcType = tcNode.get("cdt.toolChain.type", "?");
                    String tcId = tcNode.get("cdt.toolChain.id", "?");
                    Path path = Paths.get(pathStr, new String[0]);
                    IToolChainManager tcManager = Activator.getService(IToolChainManager.class);
                    IToolChain toolchain = tcManager.getToolChain(tcType, tcId);
                    if (toolchain != null && Files.exists(path, new LinkOption[0])) {
                        CMakeToolChainFile file = new CMakeToolChainFile(childName, path);
                        String[] stringArray2 = tcNode.keys();
                        int n3 = stringArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String key = stringArray2[n4];
                            String value = tcNode.get(key, "");
                            if (!value.isEmpty()) {
                                file.setProperty(key, value);
                            }
                            ++n4;
                        }
                        this.filesByToolChain.put(CMakeToolChainManager.makeToolChainId(tcType, tcId), file);
                    } else {
                        tcNode.removeNode();
                        prefs.flush();
                    }
                    ++n2;
                }
            }
            catch (CoreException | BackingStoreException e) {
                Activator.log(e);
            }
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(Activator.getId(), "toolChainProvider");
            IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
            int n5 = iConfigurationElementArray.length;
            n = 0;
            while (n < n5) {
                IConfigurationElement element = iConfigurationElementArray[n];
                if (element.getName().equals("provider")) {
                    try {
                        ICMakeToolChainProvider provider = (ICMakeToolChainProvider)element.createExecutableExtension("class");
                        provider.init(this);
                    }
                    catch (ClassCastException | CoreException e) {
                        Activator.log(e);
                    }
                }
                ++n;
            }
        }
    }

    @Override
    public ICMakeToolChainFile newToolChainFile(Path path) {
        return new CMakeToolChainFile(null, path);
    }

    @Override
    public void addToolChainFile(ICMakeToolChainFile file) {
        this.init();
        try {
            IToolChain toolchain = file.getToolChain();
            String tcId = CMakeToolChainManager.makeToolChainId(toolchain);
            if (this.filesByToolChain.containsKey(tcId)) {
                this.removeToolChainFile(file);
            }
            this.filesByToolChain.put(tcId, file);
            CMakeToolChainFile realFile = (CMakeToolChainFile)file;
            Preferences prefs = this.getPreferences();
            String n = realFile.n;
            if (n == null) {
                realFile.n = n = prefs.get(N, "0");
            }
            prefs.put(N, Integer.toString(Integer.parseInt(n) + 1));
            Preferences tcNode = prefs.node(n);
            tcNode.put(PATH, file.getPath().toString());
            for (Map.Entry<String, String> entry : realFile.properties.entrySet()) {
                tcNode.put(entry.getKey(), entry.getValue());
            }
            tcNode.put("cdt.toolChain.type", toolchain.getTypeId());
            tcNode.put("cdt.toolChain.id", toolchain.getId());
            prefs.flush();
            this.fireEvent(new CMakeToolChainEvent(1, file));
        }
        catch (CoreException | BackingStoreException e) {
            Activator.log(e);
            return;
        }
    }

    @Override
    public void removeToolChainFile(ICMakeToolChainFile file) {
        this.init();
        this.fireEvent(new CMakeToolChainEvent(2, file));
        String tcId = CMakeToolChainManager.makeToolChainId(file.getProperty("cdt.toolChain.type"), file.getProperty("cdt.toolChain.id"));
        this.filesByToolChain.remove(tcId);
        String n = ((CMakeToolChainFile)file).n;
        if (n != null) {
            Preferences prefs = this.getPreferences();
            Preferences tcNode = prefs.node(n);
            try {
                tcNode.removeNode();
                prefs.flush();
            }
            catch (BackingStoreException e) {
                Activator.log(e);
            }
        }
    }

    @Override
    public ICMakeToolChainFile getToolChainFile(Path path) {
        this.init();
        return null;
    }

    @Override
    public Collection<ICMakeToolChainFile> getToolChainFiles() {
        this.init();
        return Collections.unmodifiableCollection(this.filesByToolChain.values());
    }

    @Override
    public Collection<ICMakeToolChainFile> getToolChainFilesMatching(Map<String, String> properties) {
        ArrayList<ICMakeToolChainFile> matches = new ArrayList<ICMakeToolChainFile>();
        for (ICMakeToolChainFile file : this.getToolChainFiles()) {
            boolean match = true;
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                if (entry.getValue().equals(file.getProperty(entry.getKey()))) continue;
                match = false;
                break;
            }
            if (!match) continue;
            matches.add(file);
        }
        return matches;
    }

    @Override
    public ICMakeToolChainFile getToolChainFileFor(IToolChain toolchain) {
        this.init();
        String id = CMakeToolChainManager.makeToolChainId(toolchain);
        return this.filesByToolChain.get(id);
    }

    @Override
    public void addListener(ICMakeToolChainListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ICMakeToolChainListener listener) {
        this.listeners.remove(listener);
    }

    private void fireEvent(final CMakeToolChainEvent event) {
        for (final ICMakeToolChainListener listener : this.listeners) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    listener.handleCMakeToolChainEvent(event);
                }

                public void handleException(Throwable exception) {
                    Activator.log(exception);
                }
            });
        }
    }
}

