/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.internal.checkers.ui.quickfix;

import java.util.Arrays;
import org.eclipse.cdt.codan.core.cxx.CxxAstUtils;
import org.eclipse.cdt.codan.internal.checkers.ui.CheckersUiActivator;
import org.eclipse.cdt.codan.ui.AbstractAstRewriteQuickFix;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.Change;

public abstract class AbstractCaseBreakQuickFix
extends AbstractAstRewriteQuickFix {
    protected void addNewNodeAtMarkedCaseEnd(IASTNode newnode, IASTTranslationUnit ast, IMarker marker) {
        try {
            IASTStatement beforeCaseEnd = this.getStmtBeforeCaseEnd(marker, ast);
            if (beforeCaseEnd != null && beforeCaseEnd.getParent() instanceof IASTCompoundStatement) {
                IASTStatement after;
                IASTCompoundStatement enclosingStatement;
                if (beforeCaseEnd instanceof IASTCompoundStatement) {
                    enclosingStatement = (IASTCompoundStatement)beforeCaseEnd;
                    after = null;
                } else {
                    enclosingStatement = (IASTCompoundStatement)beforeCaseEnd.getParent();
                    after = this.getNextStatement(beforeCaseEnd);
                }
                ASTRewrite r = ASTRewrite.create((IASTTranslationUnit)enclosingStatement.getTranslationUnit());
                r.insertBefore((IASTNode)enclosingStatement, (IASTNode)after, newnode, null);
                Change c = r.rewriteAST();
                c.perform((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (CoreException | BadLocationException e) {
            CheckersUiActivator.log(e);
        }
    }

    protected IASTStatement getStmtBeforeCaseEnd(IMarker marker, IASTTranslationUnit ast) throws BadLocationException {
        int offset = marker.getAttribute("charStart", 0);
        int endOffset = marker.getAttribute("charEnd", 0);
        if (offset < 0 || endOffset < offset) {
            return null;
        }
        int length = endOffset - offset;
        IASTNodeSelector nodeSelector = ast.getNodeSelector(null);
        IASTNode containedNode = nodeSelector.findFirstContainedNode(offset, length);
        Object beforeCaseEndNode = null;
        beforeCaseEndNode = containedNode != null ? CxxAstUtils.getEnclosingStatement((IASTNode)containedNode) : nodeSelector.findEnclosingNode(offset, length);
        if (beforeCaseEndNode instanceof IASTCompoundStatement) {
            while (beforeCaseEndNode != null) {
                if (beforeCaseEndNode.getParent() instanceof IASTCompoundStatement && beforeCaseEndNode.getParent().getParent() instanceof IASTSwitchStatement) {
                    return beforeCaseEndNode;
                }
                beforeCaseEndNode = beforeCaseEndNode.getParent();
            }
        }
        if (beforeCaseEndNode instanceof IASTStatement) {
            return beforeCaseEndNode;
        }
        return null;
    }

    protected IASTStatement getNextStatement(IASTStatement beforeStatement) {
        IASTCompoundStatement enclosingStatement;
        IASTStatement[] statements;
        int indexOfNext;
        assert (beforeStatement != null);
        IASTNode parent = beforeStatement.getParent();
        if (parent instanceof IASTCompoundStatement && (indexOfNext = Arrays.asList(statements = (enclosingStatement = (IASTCompoundStatement)parent).getStatements()).indexOf(beforeStatement) + 1) < statements.length) {
            return statements[indexOfNext];
        }
        return null;
    }
}

