/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.search;

import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexFile;
import org.eclipse.cdt.core.index.IIndexInclude;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.search.CSearchMatch;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchQuery;
import org.eclipse.cdt.internal.ui.search.ProblemSearchElement;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class CSearchUnresolvedIncludesQuery
extends CSearchQuery {
    public CSearchUnresolvedIncludesQuery(ICElement[] scope) {
        super(scope, 0);
    }

    @Override
    protected IStatus runWithIndex(IIndex index, IProgressMonitor monitor) {
        try {
            IIndexFile[] iIndexFileArray = index.getFilesWithUnresolvedIncludes();
            int n = iIndexFileArray.length;
            int n2 = 0;
            while (n2 < n) {
                IIndexFile file = iIndexFileArray[n2];
                IIndexInclude[] iIndexIncludeArray = file.getIncludes();
                int n3 = iIndexIncludeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IIndexInclude include = iIndexIncludeArray[n4];
                    if (include.isActive() && !include.isResolved()) {
                        this.result.addMatch(new CSearchMatch(new ProblemSearchElement(0x2000002, include.getFullName(), include.getIncludedByLocation()), include.getNameOffset(), include.getNameLength()));
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    @Override
    public String getLabel() {
        return NLS.bind((String)CSearchMessages.PDOMSearchUnresolvedIncludesQuery_title, (Object)this.getScopeDescription());
    }

    @Override
    public String getResultLabel(int matchCount) {
        String countLabel = Messages.format(CSearchMessages.CSearchResultCollector_matches, matchCount);
        return this.getLabel() + " " + countLabel;
    }
}

