/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.tabs;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.EAttributeEditingSupport;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.EmfUtil;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class EAttributeTableViewerColumn {
    private TableViewerColumn tableViewerColumn;
    private IResourcePool resourcePool;
    private String attName;
    private TableViewer tvResults;

    public EAttributeTableViewerColumn(TableViewer tvResults, String label, final String attName, IEclipseContext context) {
        this.tvResults = tvResults;
        this.attName = attName;
        this.tableViewerColumn = new TableViewerColumn(tvResults, 0);
        this.resourcePool = (IResourcePool)context.get(IResourcePool.class);
        this.tableViewerColumn.getColumn().setText(label);
        this.tableViewerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                EObject eObject = (EObject)element;
                EAttribute eAtt = EmfUtil.getAttribute(eObject, attName);
                Object value = eAtt != null ? eObject.eGet((EStructuralFeature)eAtt) : "";
                switch (EAttributeEditingSupport.getAttributeType(element, attName)) {
                    case BOOLEAN: {
                        return EAttributeTableViewerColumn.this.resourcePool == null && (Boolean)value != false ? "X" : "";
                    }
                }
                return super.getText(value);
            }

            public Image getImage(Object element) {
                switch (EAttributeEditingSupport.getAttributeType(element, attName)) {
                    case BOOLEAN: {
                        Object value;
                        if (EAttributeTableViewerColumn.this.resourcePool == null || (value = EmfUtil.getAttributeValue((EObject)element, attName)) == null || !value.equals(true)) break;
                        return EAttributeTableViewerColumn.this.resourcePool.getImageUnchecked("IMG_org.eclipse.e4.tools.emf.ui.widgets.checkbox_obj");
                    }
                }
                return super.getImage(element);
            }

            public Color getBackground(Object element) {
                return EAttributeTableViewerColumn.this.getBackground(element);
            }
        });
        this.tableViewerColumn.setEditingSupport((EditingSupport)new EAttributeEditingSupport(tvResults, attName, context));
    }

    public Color getBackground(Object element) {
        EObject eObject = (EObject)element;
        EAttribute eAtt = EmfUtil.getAttribute(eObject, this.attName);
        if (eAtt == null) {
            return this.tvResults.getTable().getDisplay().getSystemColor(15);
        }
        return null;
    }

    public void dispose() {
        this.tableViewerColumn.getColumn().dispose();
    }

    public TableViewerColumn getTableViewerColumn() {
        return this.tableViewerColumn;
    }
}

