/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.oda.ecore.impl;

import com.ibm.icu.util.ULocale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.oda.ecore.impl.DataSetMetaData;
import org.eclipse.emf.oda.ecore.impl.Query;
import org.eclipse.emf.oda.ecore.util.StringUtil;

public class Connection
implements IConnection {
    public static final String RESOURCE_PROPERTY_NAME = "resource";
    public static final String RESOURCE_SET_PROPERTY_NAME = ResourceSet.class.getName();
    public static final String SUPPRESS_UNLOAD_PROPERTY_NAME = "suppress.unload";
    protected Map<?, ?> appContext = null;
    protected ResourceSet resourceSet = null;
    protected boolean suppressUnload = false;

    public void open(Properties connProperties) throws OdaException {
        if (this.appContext != null) {
            try {
                this.resourceSet = (ResourceSet)this.appContext.get(RESOURCE_SET_PROPERTY_NAME);
                this.suppressUnload = this.appContext.get(SUPPRESS_UNLOAD_PROPERTY_NAME) == Boolean.TRUE;
            }
            catch (Exception e) {
                throw new OdaException((Throwable)e);
            }
        }
        if (this.resourceSet == null) {
            this.resourceSet = this.createResourceSet();
            String uri = connProperties.getProperty(RESOURCE_PROPERTY_NAME);
            if (!StringUtil.isEmpty(uri)) {
                try {
                    this.resourceSet.getResource(URI.createURI((String)uri), true);
                }
                catch (Exception e) {
                    throw new OdaException((Throwable)e);
                }
            }
        }
    }

    protected ResourceSet createResourceSet() {
        return new ResourceSetImpl();
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public void setAppContext(Object context) throws OdaException {
        if (context == null && this.appContext != null) {
            if (this.appContext.containsKey(RESOURCE_SET_PROPERTY_NAME)) {
                this.resourceSet = null;
            }
            this.appContext = null;
        } else if (context instanceof Map) {
            this.appContext = (Map)context;
        }
    }

    public void close() throws OdaException {
        if (this.isOpen()) {
            if (!this.suppressUnload) {
                for (Resource resource : this.resourceSet.getResources()) {
                    resource.unload();
                }
            }
            this.resourceSet = null;
        }
    }

    public boolean isOpen() throws OdaException {
        return this.resourceSet != null;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        if (!this.isOpen()) {
            throw new OdaException((Throwable)new IllegalStateException());
        }
        return new Query(this);
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public void commit() throws OdaException {
    }

    public void rollback() throws OdaException {
    }

    public void setLocale(ULocale locale) throws OdaException {
    }
}

