/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.core.util.Trace;
import org.eclipse.gmf.runtime.common.ui.printing.IPrintHelper;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.printing.actions.DefaultPrintActionHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.DiagramPrintingDebugOptions;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.DiagramPrintingPlugin;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.l10n.DiagramUIPrintingMessages;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.DiagramPrinterHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.SWTDiagramPrinter;
import org.eclipse.gmf.runtime.diagram.ui.printing.util.DiagramPrinterUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.printing.Printer;
import org.eclipse.swt.printing.PrinterData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;

public class SWTDiagramPrinterHelper
extends DiagramPrinterHelper {
    private static SWTDiagramPrinterHelper diagramPrinterHelper;

    public static SWTDiagramPrinterHelper getDiagramPrinterHelper() {
        if (diagramPrinterHelper == null) {
            diagramPrinterHelper = new SWTDiagramPrinterHelper();
        }
        return diagramPrinterHelper;
    }

    private SWTDiagramPrinterHelper() {
    }

    public void printWithSettings(IEditorPart editorPart, Map<String, Diagram> diagramMap, SWTDiagramPrinter diagramPrinter) {
        Display display = DisplayUtils.getDisplay();
        try {
            Class<?> printhelperClass = Class.forName("org.eclipse.gmf.runtime.common.ui.printing.PrintHelper");
            IPrintHelper helper = (IPrintHelper)printhelperClass.newInstance();
            ArrayList<String> diagramNames = new ArrayList<String>(diagramMap.keySet());
            PrinterData printerData = this.collectPrintInformation(diagramPrinter, helper, diagramNames, editorPart, diagramMap);
            if (printerData != null) {
                Printer printer = new Printer(printerData);
                diagramPrinter.setPrinter(printer);
                diagramPrinter.setDisplayDPI(display.getDPI());
                if (helper.getDlgDiagramPrintRangeCurrent()) {
                    DiagramEditPart dgrmEP = ((IDiagramWorkbenchPart)editorPart).getDiagramEditPart();
                    assert (dgrmEP != null);
                    diagramPrinter.setDiagrams(Collections.singletonList(dgrmEP.getDiagramView().getDiagram()));
                } else if (helper.getDlgDiagramPrintRangeAll()) {
                    diagramPrinter.setDiagrams(diagramMap.values());
                } else if (helper.getDlgDiagramPrintRangeSelection()) {
                    ArrayList<Diagram> list = new ArrayList<Diagram>();
                    int i = 0;
                    while (i < diagramNames.size()) {
                        Diagram obj;
                        if (helper.isDlgDiagramSelected(i) && (obj = diagramMap.get(diagramNames.get(i))) instanceof Diagram) {
                            list.add(obj);
                        }
                        ++i;
                    }
                    diagramPrinter.setDiagrams(list);
                }
                this.printDiagrams(diagramPrinter, helper);
                printer.dispose();
            }
        }
        catch (Throwable e) {
            Trace.catching((Plugin)DiagramPrintingPlugin.getInstance(), (String)DiagramPrintingDebugOptions.EXCEPTIONS_CATCHING, DiagramPrinterUtil.class, (String)e.getMessage(), (Throwable)e);
            Log.warning((Plugin)DiagramPrintingPlugin.getInstance(), (int)5, (String)e.getMessage(), (Throwable)e);
            if (MessageDialog.openQuestion((Shell)display.getActiveShell(), (String)DiagramUIPrintingMessages.DiagramPrinterUtil_DLLErrorTitle, (String)(DiagramUIPrintingMessages.DiagramPrinterUtil_DLLErrorMessage_part1 + "\n" + DiagramUIPrintingMessages.DiagramPrinterUtil_DLLErrorMessage_part2 + "\n" + DiagramUIPrintingMessages.DiagramPrinterUtil_DLLErrorMessage_part3 + "\n\n" + DiagramUIPrintingMessages.DiagramPrinterUtil_DLLErrorMessage_part4))) {
                DefaultPrintActionHelper.doRun(editorPart, diagramPrinter);
            }
            return;
        }
    }

    private PrinterData collectPrintInformation(SWTDiagramPrinter diagramPrinter, IPrintHelper helper, List diagramNames, IEditorPart editorPart, Map diagramMap) {
        PrinterData printerData;
        block2: {
            printerData = null;
            try {
                printerData = super.collectPrintInformation(diagramPrinter, helper, diagramNames, editorPart, diagramMap);
            }
            catch (Throwable e) {
                Trace.catching((Plugin)DiagramPrintingPlugin.getInstance(), (String)DiagramPrintingDebugOptions.EXCEPTIONS_CATCHING, DiagramPrinterUtil.class, (String)e.getMessage(), (Throwable)e);
                Log.warning((Plugin)DiagramPrintingPlugin.getInstance(), (int)5, (String)e.getMessage(), (Throwable)e);
                if (!MessageDialog.openQuestion((Shell)DisplayUtils.getDisplay().getActiveShell(), (String)DiagramUIPrintingMessages.DiagramPrinterUtil_DLLErrorTitle, (String)(DiagramUIPrintingMessages.DiagramPrinterUtil_DLLErrorMessage_part1 + "\n" + DiagramUIPrintingMessages.DiagramPrinterUtil_DLLErrorMessage_part2 + "\n" + DiagramUIPrintingMessages.DiagramPrinterUtil_DLLErrorMessage_part3 + "\n\n" + DiagramUIPrintingMessages.DiagramPrinterUtil_DLLErrorMessage_part4))) break block2;
                DefaultPrintActionHelper.doRun(editorPart, diagramPrinter);
            }
        }
        return printerData;
    }
}

