/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.properties.views;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.ui.action.actions.global.GlobalActionManager;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalAction;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalActionId;
import org.eclipse.gmf.runtime.emf.ui.internal.MslUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class PropertiesBrowserPage
extends TabbedPropertySheetPage
implements IPropertyChangeListener {
    private ITabbedPropertySheetPageContributor contributor;
    private IWorkbenchWindow modelerViewWorkbenchWindow;
    private IStructuredSelection modelerViewSelection = null;
    private IPartListener modelerViewActivationListener = new IPartListener(){
        private boolean propertiesBrowserActive = false;

        public void partActivated(IWorkbenchPart part) {
            this.propertiesBrowserActive = part instanceof PropertySheet && ((PropertySheet)part).getCurrentPage().equals((Object)PropertiesBrowserPage.this);
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof IEditorPart && this.propertiesBrowserActive) {
                final IViewPart modelerView = (IViewPart)PropertiesBrowserPage.this.contributor;
                modelerView.getSite().getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        IStructuredSelection newModelerViewSelection = (IStructuredSelection)modelerView.getSite().getSelectionProvider().getSelection();
                        modelerView.getSite().getSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this);
                        if (!newModelerViewSelection.equals((this).PropertiesBrowserPage.this.modelerViewSelection)) {
                            PropertiesBrowserPage.this.selectionChanged((IWorkbenchPart)modelerView, (ISelection)newModelerViewSelection);
                        }
                    }
                });
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    private IStructuredSelection selectedElements;

    public PropertiesBrowserPage(ITabbedPropertySheetPageContributor contributor) {
        super(contributor);
        this.contributor = contributor;
        MslUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        super.dispose();
        if (this.modelerViewWorkbenchWindow != null) {
            this.modelerViewWorkbenchWindow.getPartService().removePartListener(this.modelerViewActivationListener);
            this.modelerViewWorkbenchWindow = null;
        }
        MslUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.contributor = null;
        this.selectedElements = null;
    }

    public void setActionBars(IActionBars actionBars) {
        if (this.contributor != null && this.contributor instanceof IWorkbenchPart) {
            GlobalAction action = GlobalActionManager.getInstance().getGlobalActionHandler((IWorkbenchPart)this.contributor, GlobalActionId.UNDO);
            if (action != null) {
                actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)action);
            }
            if ((action = GlobalActionManager.getInstance().getGlobalActionHandler((IWorkbenchPart)this.contributor, GlobalActionId.REDO)) != null) {
                actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)action);
            }
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.contributor instanceof IViewPart) {
            this.modelerViewWorkbenchWindow = this.getSite().getWorkbenchWindow();
            this.modelerViewWorkbenchWindow.getPartService().addPartListener(this.modelerViewActivationListener);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        if (selection instanceof IStructuredSelection) {
            this.selectedElements = (IStructuredSelection)selection;
        }
        if (this.modelerViewWorkbenchWindow != null && part.equals(this.contributor)) {
            IViewPart modelerView = (IViewPart)part;
            this.modelerViewSelection = (IStructuredSelection)modelerView.getSite().getSelectionProvider().getSelection();
        }
    }

    public void labelProviderChanged(LabelProviderChangedEvent event) {
        if (event.getElements() == null && this.getControl() != null) {
            super.labelProviderChanged(event);
            return;
        }
        IStructuredSelection structuredSelection = this.getSelectedElements();
        if (structuredSelection == null) {
            return;
        }
        ArrayList<Object> selection = new ArrayList<Object>();
        for (Object next : structuredSelection) {
            if (next instanceof IAdaptable) {
                Object object = ((IAdaptable)next).getAdapter(EObject.class);
                if (object == null) continue;
                selection.add(object);
                continue;
            }
            if (!(next instanceof EObject)) continue;
            selection.add(next);
        }
        if (selection.isEmpty()) {
            return;
        }
        ArrayList<Object> elementsAffected = new ArrayList<Object>();
        int i = 0;
        while (i < event.getElements().length) {
            Object next = event.getElements()[i];
            if (next instanceof IAdaptable) {
                Object object = ((IAdaptable)next).getAdapter(EObject.class);
                if (object != null) {
                    elementsAffected.add(object);
                }
            } else if (next instanceof EObject) {
                elementsAffected.add(next);
            }
            ++i;
        }
        selection.retainAll(elementsAffected);
        if (!selection.isEmpty()) {
            super.labelProviderChanged(event);
        }
    }

    public ITabbedPropertySheetPageContributor getContributor() {
        return this.contributor;
    }

    protected IStructuredSelection getSelectedElements() {
        return this.selectedElements;
    }
}

