/******************************************************************************
 * Copyright (c) 2005, 2006 IBM Corporation and others.
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation 
 ****************************************************************************/


package org.eclipse.gmf.runtime.emf.core.internal.util;

import org.eclipse.gmf.runtime.emf.core.internal.plugin.EMFCoreDebugOptions;
import org.eclipse.gmf.runtime.emf.core.internal.plugin.EMFCorePlugin;



public class Trace {
	/** Cannot be instantiated. */
	private Trace() {
		super();
	}

	/**
	 * Queries whether the specified trace <code>option</code> is enabled.
	 * 
	 * @param option a trace option
	 * @return whether if it is enabled
	 */
	public static boolean isEnabled(String option) {
		return org.eclipse.gmf.runtime.common.core.util.Trace.shouldTrace(
			EMFCorePlugin.getDefault(),
			option);
	}
	
	/**
	 * Traces the specified <code>message</code> under the given
	 * <code>option</code>.
	 * 
	 * @param option the trace option
	 * @param message the message to trace
	 * 
	 * @see #isEnabled(String)
	 */
	public static void trace(String option, String message) {
		org.eclipse.gmf.runtime.common.core.util.Trace.trace(
			EMFCorePlugin.getDefault(),
			option,
			message);
	}
	
	/**
	 * Traces a caught exception.
	 * 
	 * @param clazz the class that caught the exception
	 * @param methodName the method in which it was caught
	 * @param t the exception
	 */
	public static void catching(Class clazz, String methodName, Throwable t) {
		org.eclipse.gmf.runtime.common.core.util.Trace.catching(
			EMFCorePlugin.getDefault(),
			EMFCoreDebugOptions.EXCEPTIONS_CATCHING,
			clazz,
			methodName,
			t);
	}
	
	/**
	 * Traces a thrown exception.
	 * 
	 * @param clazz the class that is throwing the exception
	 * @param methodName the method from which it is being thrown
	 * @param t the exception
	 */
	public static void throwing(Class clazz, String methodName, Throwable t) {
		org.eclipse.gmf.runtime.common.core.util.Trace.throwing(
			EMFCorePlugin.getDefault(),
			EMFCoreDebugOptions.EXCEPTIONS_THROWING,
			clazz,
			methodName,
			t);
	}
}
