/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.Viewport;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jst.pagedesigner.tools.ExposeHelper;
import org.eclipse.jst.pagedesigner.viewer.DesignPosition;
import org.eclipse.jst.pagedesigner.viewer.DesignRange;
import org.eclipse.jst.pagedesigner.viewer.EditPartPositionHelper;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewer;
import org.eclipse.jst.pagedesigner.viewer.IHTMLGraphicalViewerListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Caret;

class CaretUpdater
implements IHTMLGraphicalViewerListener,
FigureListener {
    private IHTMLGraphicalViewer _viewer;
    private boolean _viewerBatchChanging = false;
    public static final int CARET_WIDTH = 2;
    private IFigure _trackFigure;

    public CaretUpdater(IHTMLGraphicalViewer viewer) {
        this._viewer = viewer;
        this.setup();
    }

    public void setup() {
        this._viewer.addHTMLViewerListener(this);
    }

    public void connectViewer() {
        Viewport viewport = this._viewer.getViewport();
        if (viewport != null) {
            viewport.getHorizontalRangeModel().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertychangeevent) {
                    if (propertychangeevent.getSource() instanceof RangeModel && (propertychangeevent.getPropertyName().equals("value") || propertychangeevent.getPropertyName().equals("extent"))) {
                        CaretUpdater.this.updateCaret();
                    }
                }
            });
            viewport.getVerticalRangeModel().addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertychangeevent) {
                    if (propertychangeevent.getSource() instanceof RangeModel && (propertychangeevent.getPropertyName().equals("value") || propertychangeevent.getPropertyName().equals("extent"))) {
                        CaretUpdater.this.updateCaret();
                    }
                }
            });
        }
    }

    public void dispose() {
        this._viewer.removeHTMLViewerListener(this);
    }

    public void updateSelection() {
        this.setCaretVisible(false);
        this.updateRangeSelection();
        this.updateCaret();
        this.reveal();
    }

    private void setCaretVisible(boolean visible) {
        Caret caret = this._viewer.getCaret();
        if (caret == null) {
            return;
        }
        if (caret.isDisposed()) {
            return;
        }
        caret.setVisible(visible);
    }

    private void updateRangeSelection() {
        ((GraphicalEditPart)this._viewer.getRootEditPart()).getFigure().repaint();
        ((GraphicalEditPart)this._viewer.getRootEditPart()).getFigure().getUpdateManager().performUpdate();
    }

    public void updateCaret() {
        DesignPosition endPosition;
        DesignRange range;
        Caret caret;
        if (this._trackFigure != null) {
            this._trackFigure.removeFigureListener((FigureListener)this);
            this._trackFigure = null;
        }
        if ((caret = this._viewer.getCaret()) == null) {
            return;
        }
        if (caret.isDisposed()) {
            return;
        }
        org.eclipse.draw2d.geometry.Rectangle rect = null;
        if (this._viewer.isInRangeMode() && (range = this._viewer.getRangeSelection()) != null && (endPosition = range.getEndPosition()) != null && endPosition.isValid()) {
            rect = EditPartPositionHelper.convertToAbsoluteCaretRect(endPosition);
            this._trackFigure = ((GraphicalEditPart)endPosition.getContainerPart()).getFigure();
            this._trackFigure.addFigureListener((FigureListener)this);
        }
        if (rect == null) {
            caret.setVisible(false);
        } else {
            caret.setVisible(false);
            caret.setBounds(rect.x, rect.y, 2, rect.height);
            caret.setVisible(true);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this._viewerBatchChanging) {
            return;
        }
        this.updateSelection();
    }

    @Override
    public void selectionAboutToChange() {
        this._viewerBatchChanging = true;
    }

    @Override
    public void selectionChangeFinished() {
        this._viewerBatchChanging = false;
        this.updateSelection();
    }

    public void figureMoved(IFigure source) {
        this.updateCaret();
    }

    private void reveal() {
        Caret caret = this._viewer.getCaret();
        if (caret != null && !caret.isDisposed() && this._viewer.isInRangeMode()) {
            Rectangle rect = caret.getBounds();
            ExposeHelper helper = new ExposeHelper(this._viewer);
            helper.exposeArea(new org.eclipse.draw2d.geometry.Rectangle(rect.x, rect.y, rect.width, rect.height));
        }
    }
}

