/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.target.editor.internal;

import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.DefaultOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.databinding.observable.AbstractObservable;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.pde.target.MavenTargetDependency;
import org.eclipse.m2e.pde.ui.target.editor.internal.TargetDependencyModel;

public class OperationHistoryFacade
extends AbstractObservable {
    private static final ILog LOGGER = Platform.getLog(TargetDependencyModel.class);
    private static final IUndoContext USER_CONTEXT = new UndoContext();
    private final IOperationHistory commandStack = new DefaultOperationHistory();
    private final TargetDependencyModel model;

    public OperationHistoryFacade(TargetDependencyModel model) {
        super(Realm.getDefault());
        this.model = model;
    }

    public void undo() {
        if (!this.canUndo()) {
            LOGGER.error("The undo operation is currently not possible! Ignore...");
            return;
        }
        try {
            this.commandStack.undo(USER_CONTEXT, null, null);
            this.fireChange();
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void redo() {
        if (!this.canRedo()) {
            LOGGER.error("The redo operation is currently not possible! Ignore...");
            return;
        }
        try {
            this.commandStack.redo(USER_CONTEXT, null, null);
            this.fireChange();
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean canUndo() {
        this.getterCalled();
        return this.commandStack.canUndo(USER_CONTEXT);
    }

    public boolean canRedo() {
        this.getterCalled();
        return this.commandStack.canRedo(USER_CONTEXT);
    }

    public void propertyChange(Consumer<String> setter, String oldValue, String newValue) {
        ModifyPropertyOperation command = new ModifyPropertyOperation(setter, oldValue, newValue);
        command.addContext(USER_CONTEXT);
        try {
            this.commandStack.execute((IUndoableOperation)command, null, null);
            this.fireChange();
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void modelChange(List<MavenTargetDependency> newTargetDependencies, List<MavenTargetDependency> newCurrentSelection) {
        ModifyModelOperation command = new ModifyModelOperation(newTargetDependencies, newCurrentSelection);
        command.addContext(USER_CONTEXT);
        try {
            this.commandStack.execute((IUndoableOperation)command, null, null);
            this.fireChange();
        }
        catch (ExecutionException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isStale() {
        this.getterCalled();
        return false;
    }

    private void getterCalled() {
        ObservableTracker.getterCalled((IObservable)this);
    }

    private class ModifyModelOperation
    extends AbstractOperation {
        private final List<MavenTargetDependency> oldTargetDependencies;
        private final List<MavenTargetDependency> newTargetDependencies;
        private final List<MavenTargetDependency> oldCurrentSelection;
        private final List<MavenTargetDependency> newCurrentSelection;

        public ModifyModelOperation(List<MavenTargetDependency> newTargetDependencies, List<MavenTargetDependency> newCurrentSelection) {
            super("Modify Model");
            this.oldTargetDependencies = OperationHistoryFacade.this.model.getTargetDependencies();
            this.newTargetDependencies = newTargetDependencies;
            this.oldCurrentSelection = OperationHistoryFacade.this.model.getCurrentSelection();
            this.newCurrentSelection = newCurrentSelection;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            OperationHistoryFacade.this.model.setTargetDependencies(this.newTargetDependencies);
            OperationHistoryFacade.this.model.setCurrentSelection(this.newCurrentSelection);
            OperationHistoryFacade.this.model.check();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            OperationHistoryFacade.this.model.setTargetDependencies(this.oldTargetDependencies);
            OperationHistoryFacade.this.model.setCurrentSelection(this.oldCurrentSelection);
            OperationHistoryFacade.this.model.check();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }
    }

    private class ModifyPropertyOperation
    extends AbstractOperation {
        private final Consumer<String> setter;
        private final String oldValue;
        private final String newValue;

        public ModifyPropertyOperation(Consumer<String> setter, String oldValue, String newValue) {
            super("Modify Model");
            this.setter = setter;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.setter.accept(this.newValue);
            OperationHistoryFacade.this.model.check();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            this.setter.accept(this.oldValue);
            OperationHistoryFacade.this.model.check();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return this.execute(monitor, info);
        }
    }
}

