/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.resource;

import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.resource.AbstractASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.EnvironmentFactoryAdapter;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.resource.ASResource;
import org.eclipse.ocl.pivot.resource.CSResource;

public abstract class ResourceSetAwareASResourceFactory
extends AbstractASResourceFactory {
    protected final @Nullable ResourceSet resourceSet;

    protected ResourceSetAwareASResourceFactory(@NonNull String asContentType, @NonNull String asFileExtension, @Nullable ResourceSet resourceSet) {
        super(asContentType, asFileExtension);
        this.resourceSet = resourceSet;
    }

    @Override
    public void configureResourceFactoryRegistry(@NonNull ResourceSet resourceSet) {
        String contentType;
        Map contentTypeFactoryRegistry;
        String asFileExtension;
        Resource.Factory.Registry resourceFactoryRegistry = resourceSet.getResourceFactoryRegistry();
        Map extensionFactoryRegistry = resourceFactoryRegistry.getExtensionToFactoryMap();
        Object resourceFactory = extensionFactoryRegistry.get(asFileExtension = this.getASfileExtension());
        if (resourceFactory == null) {
            extensionFactoryRegistry.put(asFileExtension, this.createResourceSetAwareASResourceFactory(resourceSet));
        }
        if ((resourceFactory = (contentTypeFactoryRegistry = resourceFactoryRegistry.getContentTypeToFactoryMap()).get(contentType = this.getContentType())) == null) {
            extensionFactoryRegistry.put(contentType, this);
        }
        super.configureResourceFactoryRegistry(resourceSet);
    }

    protected Resource createResource(@NonNull ResourceSet resourceSet, @NonNull URI uri) {
        URI csURI;
        URIConverter uriConverter;
        if ((uri.isPlatform() || uri.isFile() || uri.isArchive()) && !(uriConverter = resourceSet.getURIConverter()).exists(uri, null) && uriConverter.exists(csURI = this.getCSuri(uri), null)) {
            ResourceSet csResourceSet = this.getCSResourceSet(resourceSet);
            CSResource csResource = (CSResource)csResourceSet.getResource(csURI, true);
            ASResource asResource = csResource.getASResource();
            this.configureResource(asResource);
            return asResource;
        }
        return super.createResource(uri);
    }

    protected @NonNull ResourceSet getCSResourceSet(@NonNull ResourceSet resourceSet) {
        EnvironmentFactoryAdapter environmentFactoryAdapter = EnvironmentFactoryAdapter.find((Notifier)resourceSet);
        if (environmentFactoryAdapter != null) {
            EnvironmentFactoryInternal environmentFactory = environmentFactoryAdapter.getEnvironmentFactory();
            return environmentFactory.getResourceSet();
        }
        PivotMetamodelManager pivotMetamodelManager = PivotMetamodelManager.findAdapter(resourceSet);
        if (pivotMetamodelManager != null) {
            return pivotMetamodelManager.getEnvironmentFactory().getResourceSet();
        }
        EnvironmentFactoryInternal environmentFactory = PivotUtilInternal.getEnvironmentFactory(null);
        return environmentFactory.getResourceSet();
    }

    protected abstract @NonNull URI getCSuri(@NonNull URI var1);

    @Override
    public @NonNull String toString() {
        if (this.resourceSet != null) {
            return "\u00abresourceSetAware\u00bb " + this.contentType;
        }
        return super.toString();
    }
}

