/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.rdt.sync.ui.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ptp.internal.rdt.sync.ui.SynchronizePropertiesRegistry;
import org.eclipse.ptp.internal.rdt.sync.ui.properties.ManageConfigurationWidget;
import org.eclipse.ptp.rdt.sync.ui.ISynchronizeProperties;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class SyncPropertyPage
extends PropertyPage {
    private ManageConfigurationWidget fWidget;

    protected Control createContents(Composite parent) {
        Composite controls = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        controls.setLayout((Layout)layout);
        controls.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fWidget = new ManageConfigurationWidget(controls, 0);
        this.fWidget.setLayoutData(new GridData(4, 4, true, true));
        this.fWidget.setProject(this.getProject());
        return controls;
    }

    protected IProject getProject() {
        IAdaptable element = this.getElement();
        IResource resource = null;
        if (element instanceof IResource) {
            resource = (IResource)element;
        } else if (element instanceof IAdaptable) {
            resource = (IResource)element.getAdapter(IResource.class);
        }
        if (resource != null) {
            return resource.getProject();
        }
        return null;
    }

    public boolean performCancel() {
        ISynchronizeProperties prop = SynchronizePropertiesRegistry.getSynchronizePropertiesForProject(this.getProject());
        if (prop != null) {
            prop.performCancel();
        }
        return super.performCancel();
    }

    protected void performDefaults() {
        this.fWidget.setDefaults();
        ISynchronizeProperties prop = SynchronizePropertiesRegistry.getSynchronizePropertiesForProject(this.getProject());
        if (prop != null) {
            prop.performDefaults();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        this.fWidget.commit();
        ISynchronizeProperties prop = SynchronizePropertiesRegistry.getSynchronizePropertiesForProject(this.getProject());
        if (prop != null) {
            prop.performApply();
        }
        return true;
    }
}

