/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.viewers;

import java.io.Serializable;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.internal.widgets.ICellToolTipAdapter;
import org.eclipse.swt.internal.widgets.ICellToolTipProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;

final class CellToolTipProvider
implements ICellToolTipProvider,
Serializable {
    private ColumnViewer viewer;

    CellToolTipProvider(ColumnViewer viewer) {
        this.viewer = viewer;
    }

    static void attach(ColumnViewer viewer, CellLabelProvider labelProvider) {
        ICellToolTipAdapter adapter = CellToolTipProvider.getAdapter(viewer);
        if (labelProvider != null) {
            CellToolTipProvider provider = new CellToolTipProvider(viewer);
            adapter.setCellToolTipProvider((ICellToolTipProvider)provider);
        } else {
            adapter.setCellToolTipProvider(null);
        }
    }

    public void getToolTipText(final Item item, final int columnIndex) {
        SafeRunnable.run(new SafeRunnable(){

            public void run() {
                Object element = item.getData();
                ViewerColumn column = CellToolTipProvider.this.viewer.getViewerColumn(columnIndex);
                CellLabelProvider labelProvider = column.getLabelProvider();
                if (labelProvider != null) {
                    String text = labelProvider.getToolTipText(element);
                    ICellToolTipAdapter adapter = CellToolTipProvider.getAdapter(CellToolTipProvider.this.viewer);
                    adapter.setCellToolTipText(text);
                }
            }
        });
    }

    private static ICellToolTipAdapter getAdapter(ColumnViewer viewer) {
        Control control = viewer.getControl();
        return (ICellToolTipAdapter)control.getAdapter(ICellToolTipAdapter.class);
    }
}

