/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.api;

import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.sirius.properties.DialogButton;
import org.eclipse.sirius.properties.DialogModelOperation;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.PropertiesFactory;
import org.eclipse.sirius.properties.core.api.IDescriptionLinkResolver;
import org.eclipse.sirius.properties.core.api.IDescriptionPreprocessor;
import org.eclipse.sirius.properties.core.api.OverridesProvider;
import org.eclipse.sirius.properties.core.api.TransformationCache;
import org.eclipse.sirius.properties.core.internal.SiriusPropertiesCorePlugin;

public class DialogModelOperationPreprocessor {
    private DialogModelOperation dialogModelOperation;
    private IInterpreter interpreter;
    private IVariableManager variableManager;
    private OverridesProvider overridesProvider;

    public DialogModelOperationPreprocessor(DialogModelOperation dialogModelOperation, IInterpreter interpreter, IVariableManager variableManager, OverridesProvider overridesProvider) {
        this.dialogModelOperation = dialogModelOperation;
        this.interpreter = interpreter;
        this.variableManager = variableManager;
        this.overridesProvider = overridesProvider;
    }

    public Optional<DialogModelOperation> convert() {
        DialogModelOperation convertedDialogModelOperation = PropertiesFactory.eINSTANCE.createDialogModelOperation();
        TransformationCache cache = new TransformationCache();
        cache.put(this.dialogModelOperation, convertedDialogModelOperation);
        this.convertEAttributes(convertedDialogModelOperation);
        this.convertButtons(convertedDialogModelOperation, cache);
        this.convertPage(convertedDialogModelOperation, cache);
        this.convertGroups(convertedDialogModelOperation, cache);
        List<IDescriptionLinkResolver> linkResolvers = SiriusPropertiesCorePlugin.getPlugin().getDescriptionPreprocessorLinkResolvers();
        linkResolvers.forEach(linkResolver -> linkResolver.resolve((EObject)convertedDialogModelOperation, cache));
        return Optional.of(convertedDialogModelOperation);
    }

    private void convertEAttributes(DialogModelOperation convertedDialogModelOperation) {
        convertedDialogModelOperation.setTitleExpression(this.dialogModelOperation.getTitleExpression());
    }

    private void convertButtons(DialogModelOperation convertedDialogModelOperation, TransformationCache cache) {
        this.dialogModelOperation.getButtons().forEach(button -> {
            DialogButton convertedButton = (DialogButton)EcoreUtil.copy((EObject)button);
            cache.put(button, convertedButton);
            convertedDialogModelOperation.getButtons().add((Object)convertedButton);
        });
    }

    private void convertPage(DialogModelOperation convertedDialogModelOperation, TransformationCache cache) {
        Optional.ofNullable(this.dialogModelOperation.getPage()).ifPresent(pageDescription -> {
            Optional<IDescriptionPreprocessor> optionalPreprocessor = SiriusPropertiesCorePlugin.getPlugin().getDescriptionPreprocessor((EObject)pageDescription);
            optionalPreprocessor.ifPresent(preprocessor -> {
                EObject convertedEObject = preprocessor.convert((EObject)pageDescription, cache, this.interpreter, this.variableManager, this.overridesProvider);
                if (convertedEObject instanceof PageDescription) {
                    convertedDialogModelOperation.setPage((PageDescription)convertedEObject);
                }
            });
        });
    }

    private void convertGroups(DialogModelOperation convertedDialogModelOperation, TransformationCache cache) {
        this.dialogModelOperation.getGroups().forEach(groupDescription -> {
            Optional<IDescriptionPreprocessor> optionalPreprocessor = SiriusPropertiesCorePlugin.getPlugin().getDescriptionPreprocessor((EObject)groupDescription);
            optionalPreprocessor.ifPresent(preprocessor -> {
                EObject convertedEObject = preprocessor.convert((EObject)groupDescription, cache, this.interpreter, this.variableManager, this.overridesProvider);
                if (convertedEObject instanceof GroupDescription) {
                    convertedDialogModelOperation.getGroups().add((Object)((GroupDescription)convertedEObject));
                }
            });
        });
    }
}

