/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GDK;
import org.eclipse.swt.internal.gtk.GTK;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    Composite embeddedInto;
    int x;
    int y;
    int width;
    int height;
    boolean isVisible;
    boolean isShowing;
    int blinkRate;
    Image image;
    Font font;
    static final int DEFAULT_WIDTH = 1;

    public Caret(Canvas parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(0);
        Composite p = parent.getParent();
        while (p != null) {
            if (p instanceof Tree || p instanceof Table) {
                this.embeddedInto = p;
                break;
            }
            p = p.getParent();
        }
    }

    boolean blinkCaret() {
        if (!this.isVisible) {
            return true;
        }
        if (!this.isShowing) {
            return this.showCaret();
        }
        if (this.blinkRate == 0) {
            return true;
        }
        return this.hideCaret();
    }

    @Override
    void createWidget(int index) {
        super.createWidget(index);
        this.blinkRate = this.display.getCaretBlinkTime();
        this.isVisible = true;
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    boolean drawCaret() {
        if (this.parent == null) {
            return false;
        }
        if (this.parent.isDisposed()) {
            return false;
        }
        if (this.embeddedInto != null && !this.embeddedInto.isDisposed() && this.isFocusCaret()) {
            this.drawInCellEditor(this.embeddedInto.paintWindow());
        } else {
            GTK.gtk_widget_queue_draw(this.parent.handle);
        }
        return true;
    }

    private void drawInCellEditor(long window) {
        long cairo = GDK.gdk_cairo_create(window);
        Point pt = this.display.map((Control)this.parent, (Control)this.embeddedInto, new Point(0, 0));
        Cairo.cairo_translate(cairo, pt.x, pt.y);
        this.parent.drawCaretInFocus(this.parent.handle, cairo);
        Cairo.cairo_destroy(cairo);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getBoundsInPixels());
    }

    Rectangle getBoundsInPixels() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rect = this.image.getBoundsInPixels();
            return new Rectangle(this.x, this.y, rect.width, rect.height);
        }
        if (this.width == 0) {
            return new Rectangle(this.x, this.y, 1, this.height);
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        return this.parent.getFont();
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getLocationInPixels());
    }

    Point getLocationInPixels() {
        this.checkWidget();
        return new Point(this.x, this.y);
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getSize() {
        this.checkWidget();
        return DPIUtil.autoScaleDown(this.getSizeInPixels());
    }

    Point getSizeInPixels() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rect = this.image.getBoundsInPixels();
            return new Point(rect.width, rect.height);
        }
        if (this.width == 0) {
            return new Point(1, this.height);
        }
        return new Point(this.width, this.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.isVisible;
    }

    boolean hideCaret() {
        if (!this.isShowing) {
            return true;
        }
        this.isShowing = false;
        return this.drawCaret();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.isVisible && this.parent.isVisible() && this.parent.hasFocus();
    }

    boolean isFocusCaret() {
        return this == this.display.currentCaret;
    }

    void killFocus() {
        if (this.display.currentCaret != this) {
            return;
        }
        this.display.setCurrentCaret(null);
        if (this.isVisible) {
            this.hideCaret();
        }
    }

    @Override
    void releaseParent() {
        super.releaseParent();
        if (this.parent != null && this == this.parent.caret) {
            if (!this.parent.isDisposed()) {
                this.parent.setCaret(null);
            } else {
                this.parent.caret = null;
            }
        }
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.display.currentCaret == this) {
            this.hideCaret();
            this.display.setCurrentCaret(null);
        }
        this.parent = null;
        this.image = null;
        this.embeddedInto = null;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        this.setBounds(new Rectangle(x, y, width, height));
    }

    void setBoundsInPixels(int x, int y, int width, int height) {
        this.checkWidget();
        if (this.x == x && this.y == y && this.width == width && this.height == height) {
            return;
        }
        boolean isFocus = this.isFocusCaret();
        if (isFocus && this.isVisible) {
            this.hideCaret();
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.parent.updateCaret();
        if (isFocus && this.isVisible) {
            this.showCaret();
        }
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        rect = DPIUtil.autoScaleUp(rect);
        this.setBoundsInPixels(rect);
    }

    void setBoundsInPixels(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBoundsInPixels(rect.x, rect.y, rect.width, rect.height);
    }

    void setFocus() {
        if (this.display.currentCaret == this) {
            return;
        }
        this.display.setCurrentCaret(this);
        if (this.isVisible) {
            this.showCaret();
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
    }

    public void setImage(Image image) {
        boolean isFocus;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((isFocus = this.isFocusCaret()) && this.isVisible) {
            this.hideCaret();
        }
        this.image = image;
        if (isFocus && this.isVisible) {
            this.showCaret();
        }
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setLocation(new Point(x, y));
    }

    void setLocationInPixels(int x, int y) {
        this.checkWidget();
        this.setBoundsInPixels(x, y, this.width, this.height);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        this.setLocationInPixels(DPIUtil.autoScaleUp(location));
    }

    void setLocationInPixels(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocationInPixels(location.x, location.y);
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setSize(new Point(width, height));
    }

    void setSizeInPixels(int width, int height) {
        this.checkWidget();
        this.setBoundsInPixels(this.x, this.y, width, height);
    }

    public void setSize(Point size) {
        this.checkWidget();
        this.setSizeInPixels(DPIUtil.autoScaleUp(size));
    }

    void setSizeInPixels(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setSizeInPixels(size.x, size.y);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        Canvas canvas = this.getParent();
        canvas.blink = true;
        canvas.drawFlag = visible;
        this.display.resetCaretTiming();
        if (visible == this.isVisible) {
            return;
        }
        this.isVisible = visible;
        if (!this.isFocusCaret()) {
            return;
        }
        if (this.isVisible) {
            this.showCaret();
        } else {
            this.hideCaret();
        }
    }

    boolean showCaret() {
        if (this.isShowing) {
            return true;
        }
        this.isShowing = true;
        return this.drawCaret();
    }
}

