/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.internal.channelmanager.steps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.core.interfaces.IPathMapService;
import org.eclipse.tcf.te.tcf.core.steps.AbstractPeerStep;

public class AttachPathMapsListenerStep
extends AbstractPeerStep {
    public String PATH_MAP_PROP_SHARED = "Shared";

    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)fullQualifiedId);
        Assert.isNotNull((Object)monitor);
        IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (channel == null || channel.getState() != 1) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "Channel to target not available or closed."));
        }
    }

    public void execute(IStepContext context, final IPropertiesContainer data, final IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, final ICallback callback) {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)fullQualifiedId);
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)callback);
        final IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        Assert.isNotNull((Object)channel);
        final IPeer peer = this.getActivePeerContext(context, data, fullQualifiedId);
        Assert.isNotNull((Object)peer);
        if (1 == channel.getState()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    final IPathMap svc = (IPathMap)channel.getRemoteService(IPathMap.class);
                    if (svc != null) {
                        svc.addListener(new IPathMap.PathMapListener(){

                            public void changed() {
                                svc.get(new IPathMap.DoneGet(){

                                    public void doneGet(IToken token, Exception error, final IPathMap.PathMapRule[] map) {
                                        Thread th = new Thread(new Runnable(){

                                            @Override
                                            public void run() {
                                                IPathMapService service = (IPathMapService)ServiceManager.getInstance().getService((Object)peer, IPathMapService.class);
                                                if (service != null) {
                                                    IPathMap.PathMapRule[] existingRulesArray = service.getSharedPathMapRules(peer);
                                                    List<IPathMap.PathMapRule> existingRules = existingRulesArray != null ? Arrays.asList(existingRulesArray) : new ArrayList<IPathMap.PathMapRule>();
                                                    List<IPathMap.PathMapRule> newRules = map != null ? Arrays.asList(map) : new ArrayList<IPathMap.PathMapRule>();
                                                    ArrayList<IPathMap.PathMapRule> diffRules = new ArrayList<IPathMap.PathMapRule>();
                                                    for (IPathMap.PathMapRule rule : existingRules) {
                                                        if (AttachPathMapsListenerStep.this.existsPathMapRuleInList(rule, newRules) || diffRules.contains(rule)) continue;
                                                        diffRules.add(rule);
                                                    }
                                                    if (diffRules.size() > 0) {
                                                        service.removePathMap((Object)peer, diffRules.toArray(new IPathMap.PathMapRule[0]));
                                                        diffRules.clear();
                                                    }
                                                    for (IPathMap.PathMapRule rule : newRules) {
                                                        if (!Boolean.parseBoolean((String)rule.getProperties().get((((this).this).this).AttachPathMapsListenerStep.this.PATH_MAP_PROP_SHARED)) || AttachPathMapsListenerStep.this.existsPathMapRuleInList(rule, existingRules) || diffRules.contains(rule)) continue;
                                                        diffRules.add(rule);
                                                    }
                                                    if (diffRules.size() > 0) {
                                                        service.addSharedPathMapRules(peer, diffRules.toArray(new IPathMap.PathMapRule[0]));
                                                        diffRules.clear();
                                                    }
                                                }
                                            }
                                        });
                                        th.start();
                                    }
                                });
                            }
                        });
                        AttachPathMapsListenerStep.this.callback(data, fullQualifiedId, callback, Status.OK_STATUS, null);
                    }
                }
            };
            Protocol.invokeLater((Runnable)runnable);
        }
    }

    protected boolean existsPathMapRuleInList(IPathMap.PathMapRule rule, List<IPathMap.PathMapRule> rules) {
        for (IPathMap.PathMapRule r : rules) {
            if (!r.getSource().equals(rule.getSource()) || !r.getDestination().equals(rule.getDestination())) continue;
            return true;
        }
        return false;
    }
}

