/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.dnd;

import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.internal.dnd.CommonDnD;

public class FSDropTargetListener
extends ViewerDropAdapter {
    TreeViewer viewer;
    CommonDnD dnd;

    public FSDropTargetListener(TreeViewer viewer) {
        super((Viewer)viewer);
        this.viewer = viewer;
        this.dnd = new CommonDnD();
    }

    public void dragEnter(DropTargetEvent event) {
        if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
            event.detail = 1;
        }
        super.dragEnter(event);
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (target instanceof IFSTreeNode) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
                int op = this.dnd.validateLocalSelectionDrop(target, operation, transferType);
                if (op == 0) {
                    return false;
                }
                if (op != operation) {
                    this.overrideOperation(op);
                }
                return true;
            }
            if (FileTransfer.getInstance().isSupportedType(transferType)) {
                return this.dnd.validateFilesDrop(target, operation, transferType);
            }
        }
        return false;
    }

    public boolean performDrop(Object data) {
        boolean success = false;
        TransferData transferType = this.getCurrentEvent().currentDataType;
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            IStructuredSelection selection = (IStructuredSelection)data;
            int operations = this.getCurrentOperation();
            IFSTreeNode target = (IFSTreeNode)this.getCurrentTarget();
            success = this.dnd.dropLocalSelection(target, operations, selection);
        } else if (FileTransfer.getInstance().isSupportedType(transferType)) {
            String[] files = (String[])data;
            int operations = this.getCurrentOperation();
            IFSTreeNode target = (IFSTreeNode)this.getCurrentTarget();
            success = this.dnd.dropFiles(this.viewer, files, operations, target);
        }
        return success;
    }
}

