/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.tables;

import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Table;
import org.eclipse.tcf.te.ui.AbstractViewerComparator;

public class TableViewerComparator
extends AbstractViewerComparator {
    private final ITableLabelProvider labelProvider;

    public TableViewerComparator(Viewer viewer, ITableLabelProvider labelProvider) {
        super(viewer);
        Assert.isNotNull((Object)labelProvider);
        this.labelProvider = labelProvider;
    }

    @Override
    protected int doDetermineInverter(Viewer viewer) {
        Table table;
        int inverter = 1;
        if (viewer instanceof TableViewer && ((TableViewer)viewer).getTable() != null && !(table = ((TableViewer)viewer).getTable()).isDisposed() && table.getSortDirection() == 1024) {
            inverter = -1;
        }
        return inverter;
    }

    @Override
    protected String doGetText(Object node, int index) {
        if (node != null && this.labelProvider != null) {
            return index != -1 ? this.labelProvider.getColumnText(node, index) : ((ILabelProvider)this.labelProvider).getText(node);
        }
        return null;
    }

    @Override
    protected String doGetSortColumnLabel(Viewer viewer) {
        if (viewer instanceof TableViewer && ((TableViewer)viewer).getTable() != null && !((TableViewer)viewer).getTable().isDisposed()) {
            Table table = ((TableViewer)viewer).getTable();
            return table.getSortColumn() != null ? table.getSortColumn().getText() : "";
        }
        return "";
    }

    @Override
    protected int doGetSortColumnIndex(Viewer viewer) {
        if (viewer instanceof TableViewer && ((TableViewer)viewer).getTable() != null && !((TableViewer)viewer).getTable().isDisposed()) {
            Table table = ((TableViewer)viewer).getTable();
            return table.getSortColumn() != null ? Arrays.asList(table.getColumns()).indexOf(table.getSortColumn()) : -1;
        }
        return -1;
    }

    @Override
    protected int doCompare(Object node1, Object node2, String sortColumn, int index, int inverter) {
        if (node1 == null && node2 == null) {
            return 0;
        }
        if (node1 != null && node2 == null) {
            return 1;
        }
        if (node1 == null && node2 != null) {
            return -1;
        }
        String text1 = this.doGetText(node1, index);
        String text2 = this.doGetText(node2, index);
        if (text1 != null && text1.matches(".*[0-9]+$") && text2 != null && text2.matches(".*[0-9]+$")) {
            String[] splitted1 = text1.split("[0-9]+$", 2);
            String[] splitted2 = text2.split("[0-9]+$", 2);
            String alpha1 = splitted1[0];
            String alpha2 = splitted2[0];
            String num1 = text1.replace(alpha1, "");
            String num2 = text2.replace(alpha2, "");
            int result = this.getComparator().compare(alpha1, alpha2) * inverter;
            if (result == 0) {
                result = Integer.decode(num1).compareTo(Integer.decode(num2)) * inverter;
            }
            return result;
        }
        return this.getComparator().compare(text1, text2) * inverter;
    }
}

