/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.tabs;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.control.ITerminalMouseListener;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.TerminalViewControlFactory;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.terminal.view.ui.activator.UIPlugin;
import org.eclipse.tm.terminal.view.ui.interfaces.ITerminalsView;
import org.eclipse.tm.terminal.view.ui.nls.Messages;
import org.eclipse.tm.terminal.view.ui.tabs.OpenFileMouseHandler;
import org.eclipse.tm.terminal.view.ui.tabs.TabCommandFieldHandler;
import org.eclipse.tm.terminal.view.ui.tabs.TabDisposeListener;
import org.eclipse.tm.terminal.view.ui.tabs.TabFolderMenuHandler;
import org.eclipse.tm.terminal.view.ui.tabs.TabFolderSelectionListener;
import org.eclipse.tm.terminal.view.ui.tabs.TabTerminalListener;
import org.eclipse.ui.PlatformUI;

public class TabFolderManager
extends PlatformObject
implements ISelectionProvider {
    private final ITerminalsView parentView;
    private final SelectionListener selectionListener;
    private final List<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private final Map<CTabItem, TabCommandFieldHandler> commandFieldHandler = new HashMap<CTabItem, TabCommandFieldHandler>();

    public TabFolderManager(ITerminalsView parentView) {
        Assert.isNotNull((Object)parentView);
        this.parentView = parentView;
        this.selectionListener = this.doCreateTabFolderSelectionListener(this);
        if (this.getTabFolder() != null) {
            this.getTabFolder().addSelectionListener(this.selectionListener);
        }
    }

    protected TabFolderSelectionListener doCreateTabFolderSelectionListener(TabFolderManager parent) {
        Assert.isNotNull((Object)((Object)parent));
        return new TabFolderSelectionListener(parent);
    }

    protected final ITerminalsView getParentView() {
        return this.parentView;
    }

    protected final CTabFolder getTabFolder() {
        return (CTabFolder)this.getParentView().getAdapter(CTabFolder.class);
    }

    protected final ISelectionChangedListener[] getSelectionChangedListeners() {
        return this.selectionChangedListeners.toArray(new ISelectionChangedListener[this.selectionChangedListeners.size()]);
    }

    public void dispose() {
        if (this.getTabFolder() != null && !this.getTabFolder().isDisposed()) {
            this.getTabFolder().removeSelectionListener(this.selectionListener);
        }
        for (TabCommandFieldHandler handler : this.commandFieldHandler.values()) {
            handler.dispose();
        }
        this.commandFieldHandler.clear();
    }

    public CTabItem createTabItem(String title, String encoding, ITerminalConnector connector, Object data, Map<String, Boolean> flags) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        CTabItem item = null;
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder != null) {
            ITerminalViewControl terminal;
            block11: {
                Menu menu;
                TabFolderMenuHandler menuHandler;
                String contextHelpId;
                title = this.makeUniqueTitle(title, tabFolder);
                item = new CTabItem(tabFolder, 64);
                item.setText(title);
                Image image = this.getTabItemImage(connector, data);
                if (image != null) {
                    item.setImage(image);
                }
                this.setupTerminalTabListeners(item);
                Composite composite = new Composite((Composite)tabFolder, 0);
                composite.setLayout((Layout)new FillLayout());
                item.setControl((Control)composite);
                tabFolder.getParent().layout(true);
                terminal = TerminalViewControlFactory.makeControl((ITerminalListener)this.doCreateTerminalTabTerminalListener(this, item), (Composite)composite, (ITerminalConnector[])new ITerminalConnector[]{connector}, (boolean)true);
                if (terminal instanceof ITerminalControl) {
                    Boolean value = flags != null ? flags.get("data.noReconnect") : null;
                    boolean noReconnect = value instanceof Boolean ? value : false;
                    ((ITerminalControl)terminal).setConnectOnEnterIfClosed(!noReconnect);
                }
                this.addMiddleMouseButtonPasteSupport(terminal);
                this.addOpenResourceSupport(terminal);
                new TerminalControlSelectionListener(terminal);
                try {
                    Charset charset = null;
                    if (encoding != null) {
                        charset = Charset.forName(encoding);
                    }
                    terminal.setCharset(charset);
                }
                catch (UnsupportedCharsetException charset) {
                    // empty catch block
                }
                item.setData((Object)terminal);
                if (data != null) {
                    item.setData("customData", data);
                }
                if ((contextHelpId = this.getParentView().getContextHelpId()) != null) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(terminal.getControl(), contextHelpId);
                }
                if ((menuHandler = (TabFolderMenuHandler)((Object)this.getParentView().getAdapter(TabFolderMenuHandler.class))) != null && (menu = menuHandler.getAdapter(Menu.class)) != null) {
                    try {
                        terminal.getControl().setMenu(menu);
                    }
                    catch (IllegalArgumentException e) {
                        if (!UIPlugin.getTraceHandler().isSlotEnabled(1, null)) break block11;
                        e.printStackTrace();
                    }
                }
            }
            tabFolder.setSelection(item);
            terminal.setConnector(connector);
            terminal.connectTerminal();
            this.fireSelectionChanged();
        }
        return item;
    }

    private void addOpenResourceSupport(ITerminalViewControl terminal) {
        terminal.addMouseListener((ITerminalMouseListener)new OpenFileMouseHandler(this.getParentView().getSite(), terminal));
    }

    public CTabItem cloneTabItemAfterDrop(CTabItem oldItem) {
        Assert.isNotNull((Object)oldItem);
        ITerminalViewControl terminal = (ITerminalViewControl)oldItem.getData();
        ITerminalConnector connector = terminal.getTerminalConnector();
        Object data = oldItem.getData("customData");
        Map properties = (Map)oldItem.getData("properties");
        String title = oldItem.getText();
        CTabItem item = null;
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder != null) {
            TerminalState oldState;
            block8: {
                Menu menu;
                TabFolderMenuHandler menuHandler;
                String contextHelpId;
                title = this.makeUniqueTitle(title, tabFolder);
                item = new CTabItem(tabFolder, 64);
                item.setText(title);
                Image image = this.getTabItemImage(connector, data);
                if (image != null) {
                    item.setImage(image);
                }
                this.setupTerminalTabListeners(item);
                TabTerminalListener.move(oldItem, item);
                Composite composite = new Composite((Composite)tabFolder, 0);
                composite.setLayout((Layout)new FillLayout());
                item.setControl((Control)composite);
                tabFolder.getParent().layout(true);
                oldState = terminal.getState();
                terminal.getControl().setMenu(null);
                Assert.isTrue((boolean)(terminal instanceof ITerminalControl));
                ((ITerminalControl)terminal).setupTerminal(composite);
                this.addMiddleMouseButtonPasteSupport(terminal);
                item.setData((Object)terminal);
                if (data != null) {
                    item.setData("customData", data);
                }
                if (properties != null) {
                    item.setData("properties", (Object)properties);
                }
                if ((contextHelpId = this.getParentView().getContextHelpId()) != null) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp(terminal.getControl(), contextHelpId);
                }
                if ((menuHandler = (TabFolderMenuHandler)((Object)this.getParentView().getAdapter(TabFolderMenuHandler.class))) != null && (menu = menuHandler.getAdapter(Menu.class)) != null) {
                    try {
                        terminal.getControl().setMenu(menu);
                    }
                    catch (IllegalArgumentException e) {
                        if (!UIPlugin.getTraceHandler().isSlotEnabled(1, null)) break block8;
                        e.printStackTrace();
                    }
                }
            }
            tabFolder.setSelection(item);
            terminal.setConnector(connector);
            Assert.isTrue((boolean)(terminal instanceof ITerminalControl));
            ((ITerminalControl)terminal).setState(oldState);
            this.fireSelectionChanged();
        }
        return item;
    }

    protected void addMiddleMouseButtonPasteSupport(final ITerminalViewControl terminal) {
        terminal.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 2) {
                    String text;
                    Clipboard clipboard = terminal.getClipboard();
                    if (clipboard.isDisposed()) {
                        return;
                    }
                    int clipboardType = 2;
                    if (clipboard.getAvailableTypes(clipboardType).length == 0) {
                        clipboardType = 1;
                    }
                    if ((text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance(), clipboardType)) != null && text.length() > 0) {
                        terminal.pasteString(text);
                    }
                }
            }
        });
    }

    protected String makeUniqueTitle(String proposal, CTabFolder tabFolder) {
        Assert.isNotNull((Object)proposal);
        Assert.isNotNull((Object)tabFolder);
        Object title = proposal;
        int index = 0;
        ArrayList<String> titles = new ArrayList<String>();
        CTabItem[] cTabItemArray = tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            titles.add(item.getText());
            ++n2;
        }
        while (titles.contains(title)) {
            title = proposal + " (" + ++index + ")";
        }
        return title;
    }

    protected void setupTerminalTabListeners(CTabItem item) {
        Assert.isNotNull((Object)item);
        DisposeListener disposeListener = this.doCreateTerminalTabDisposeListener(this);
        item.setData("disposeListener", (Object)disposeListener);
        item.addDisposeListener(disposeListener);
    }

    protected ITerminalListener doCreateTerminalTabTerminalListener(TabFolderManager tabFolderManager, CTabItem item) {
        Assert.isNotNull((Object)item);
        return new TabTerminalListener(tabFolderManager, item);
    }

    protected DisposeListener doCreateTerminalTabDisposeListener(TabFolderManager parent) {
        Assert.isNotNull((Object)((Object)parent));
        return new TabDisposeListener(parent);
    }

    protected Image getTabItemImage(ITerminalConnector connector, Object data) {
        Assert.isNotNull((Object)connector);
        return UIPlugin.getImage("TerminalsView");
    }

    public CTabItem findTabItem(String title, ITerminalConnector connector, Object data) {
        Assert.isNotNull((Object)title);
        Assert.isNotNull((Object)connector);
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder == null) {
            return null;
        }
        CTabItem[] cTabItemArray = tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (!item.isDisposed()) {
                String itemTitle = item.getText();
                if ((itemTitle = itemTitle.replaceFirst("^<.*>\\s*", "")).startsWith(title)) {
                    ITerminalViewControl terminal = (ITerminalViewControl)item.getData();
                    ITerminalConnector connector2 = terminal.getTerminalConnector();
                    if (connector.getId().equals(connector2.getId()) && connector.getName().equals(connector2.getName())) {
                        String summary2;
                        if (!connector.isInitialized()) {
                            return item;
                        }
                        String summary = connector.getSettingsSummary();
                        if (summary.equals(summary2 = connector2.getSettingsSummary())) {
                            return item;
                        }
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    public void bringToTop(CTabItem item) {
        Assert.isNotNull((Object)item);
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder == null) {
            return;
        }
        tabFolder.setSelection(item);
        this.fireSelectionChanged();
    }

    public CTabItem getActiveTabItem() {
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder == null) {
            return null;
        }
        return tabFolder.getSelection();
    }

    public void removeTerminatedItems() {
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder == null) {
            return;
        }
        CTabItem[] cTabItemArray = tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (!item.isDisposed() && this.isTerminatedTabItem(item)) {
                item.dispose();
            }
            ++n2;
        }
    }

    protected boolean isTerminatedTabItem(CTabItem item) {
        if (item == null || item.isDisposed()) {
            return false;
        }
        String itemTitle = item.getText();
        if (itemTitle != null && itemTitle.contains("<terminated>")) {
            return true;
        }
        ITerminalViewControl terminal = (ITerminalViewControl)item.getData();
        return terminal != null && terminal.getState() == TerminalState.CLOSED;
    }

    public final TabCommandFieldHandler getTabCommandFieldHandler(CTabItem item) {
        if (item == null || item.isDisposed()) {
            return null;
        }
        TabCommandFieldHandler handler = this.commandFieldHandler.get(item);
        if (handler == null) {
            handler = this.createTabCommandFieldHandler(this, item);
            Assert.isNotNull((Object)handler);
            this.commandFieldHandler.put(item, handler);
        }
        return handler;
    }

    protected TabCommandFieldHandler createTabCommandFieldHandler(TabFolderManager tabFolderManager, CTabItem item) {
        return new TabCommandFieldHandler(tabFolderManager, item);
    }

    protected void disposeTabCommandFieldHandler(CTabItem item) {
        if (item == null || item.isDisposed()) {
            return;
        }
        TabCommandFieldHandler handler = this.commandFieldHandler.remove(item);
        if (handler != null) {
            handler.dispose();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null && !this.selectionChangedListeners.contains(listener)) {
            this.selectionChangedListeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.selectionChangedListeners.remove(listener);
        }
    }

    public ISelection getSelection() {
        CTabItem activeTabItem = this.getActiveTabItem();
        return activeTabItem != null ? new StructuredSelection((Object)activeTabItem) : new StructuredSelection();
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            for (Object candidate : (IStructuredSelection)selection) {
                if (!(candidate instanceof CTabItem)) continue;
                this.bringToTop((CTabItem)candidate);
                return;
            }
        }
        this.fireSelectionChanged(selection);
    }

    protected void fireSelectionChanged() {
        this.updateStatusLine();
        this.fireSelectionChanged(this.getSelection());
    }

    protected void fireTerminalSelectionChanged() {
        ITerminalViewControl terminal;
        this.updateStatusLine();
        CTabItem item = this.getActiveTabItem();
        if (item != null && !item.isDisposed() && (terminal = (ITerminalViewControl)item.getData()) != null && !terminal.isDisposed()) {
            this.fireSelectionChanged((ISelection)new StructuredSelection((Object)terminal.getSelection()));
        }
    }

    protected final void fireSelectionChanged(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener listener : this.selectionChangedListeners) {
            listener.selectionChanged(event);
        }
    }

    public final void updateStatusLine() {
        ITerminalViewControl terminal;
        String message = null;
        IStatusLineManager manager = this.parentView.getViewSite().getActionBars().getStatusLineManager();
        CTabItem item = this.getActiveTabItem();
        if (item != null && !item.isDisposed() && (terminal = (ITerminalViewControl)item.getData()) != null && !terminal.isDisposed()) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.state2msg(item, terminal.getState()));
            buffer.append(" - ");
            String encoding = terminal.getEncoding();
            if (encoding == null || "ISO-8859-1".equals(encoding)) {
                encoding = "Default (ISO-8859-1)";
            }
            buffer.append(NLS.bind((String)Messages.TabFolderManager_encoding, (Object)encoding));
            message = buffer.toString();
        }
        manager.setMessage(message);
    }

    protected String state2msg(CTabItem item, TerminalState state) {
        Assert.isNotNull((Object)item);
        Assert.isNotNull((Object)state);
        Map properties = (Map)item.getData("properties");
        String stateStr = state.toString();
        String key = "TabFolderManager_state_" + stateStr.replaceAll("\\.", " ").trim().toLowerCase();
        String stateMsg = null;
        if (properties != null) {
            String string = stateMsg = properties.get(key) instanceof String ? (String)properties.get(key) : null;
        }
        if (stateMsg == null) {
            stateMsg = Messages.getString(key);
        }
        if (stateMsg == null) {
            stateMsg = stateStr;
        }
        return stateMsg;
    }

    private class TerminalControlSelectionListener
    implements DisposeListener,
    MouseListener {
        private final ITerminalViewControl terminal;
        private boolean selectMode;

        public TerminalControlSelectionListener(ITerminalViewControl terminal) {
            Assert.isNotNull((Object)terminal);
            this.terminal = terminal;
            terminal.getControl().addDisposeListener((DisposeListener)this);
            terminal.getControl().addMouseListener((MouseListener)this);
        }

        protected final ITerminalViewControl getTerminal() {
            return this.terminal;
        }

        public void widgetDisposed(DisposeEvent e) {
            if (e.getSource().equals(this.terminal.getControl())) {
                this.getTerminal().getControl().removeDisposeListener((DisposeListener)this);
                this.getTerminal().getControl().removeMouseListener((MouseListener)this);
            }
        }

        public void mouseDown(MouseEvent e) {
            if (e.button == 1) {
                this.selectMode = true;
            }
        }

        public void mouseUp(MouseEvent e) {
            if (e.button == 1 && this.selectMode) {
                this.selectMode = false;
                try {
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    display.asyncExec(() -> TabFolderManager.this.fireSelectionChanged((ISelection)new StructuredSelection((Object)this.getTerminal().getSelection())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void mouseDoubleClick(MouseEvent e) {
        }
    }
}

