/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.JavaInfoSetObjectAfter;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardImplicitCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.IImplicitCreationSupport;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;

public final class VirtualLayoutDataCreationSupport
extends CreationSupport
implements IImplicitCreationSupport {
    private final ControlInfo m_control;
    private final Object m_dataObject;

    public VirtualLayoutDataCreationSupport(ControlInfo control, Object dataObject) {
        this.m_control = control;
        this.m_dataObject = dataObject;
    }

    public void setJavaInfo(JavaInfo javaInfo) throws Exception {
        super.setJavaInfo(javaInfo);
        this.m_javaInfo.setObject(this.m_dataObject);
        this.m_control.addBroadcastListener(new JavaInfoSetObjectAfter(){

            public void invoke(JavaInfo target, Object object) throws Exception {
                if (VirtualLayoutDataCreationSupport.this.m_javaInfo.getCreationSupport() != VirtualLayoutDataCreationSupport.this) {
                    VirtualLayoutDataCreationSupport.this.m_control.removeBroadcastListener(this);
                    return;
                }
                if (target == VirtualLayoutDataCreationSupport.this.m_control) {
                    VirtualLayoutDataCreationSupport.this.m_javaInfo.setObject(VirtualLayoutDataCreationSupport.this.m_dataObject);
                }
            }
        });
    }

    public boolean isJavaInfo(ASTNode node) {
        return false;
    }

    public ASTNode getNode() {
        return null;
    }

    public boolean canDelete() {
        return true;
    }

    public void delete() throws Exception {
        JavaInfoUtils.deleteJavaInfo((JavaInfo)this.m_javaInfo, (boolean)false);
    }

    public String toString() {
        Class layoutDataClass = this.getComponentClass();
        return "virtual-layout_data: " + layoutDataClass.getName();
    }

    public IClipboardImplicitCreationSupport getImplicitClipboard() {
        return null;
    }
}

