/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.font;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.ui.DrawUtils;
import org.eclipse.wb.internal.swt.model.property.editor.font.FontInfo;
import org.eclipse.wb.internal.swt.support.ToolkitSupport;

public final class FontPreviewCanvas
extends Canvas {
    private Image m_image;

    public FontPreviewCanvas(Composite parent, int style) {
        super(parent, style);
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                FontPreviewCanvas.this.onPaint(event.gc);
            }
        });
    }

    public void dispose() {
        if (this.m_image != null) {
            this.m_image.dispose();
            this.m_image = null;
        }
        super.dispose();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int width = 450;
        int height = 50;
        return new Point(width, height);
    }

    protected final void onPaint(GC gc) {
        if (this.m_image != null) {
            Rectangle clientArea = this.getClientArea();
            DrawUtils.drawImageCHCV((GC)gc, (Image)this.m_image, (int)clientArea.x, (int)clientArea.y, (int)clientArea.width, (int)clientArea.height);
        }
    }

    public void setFontInfo(JavaInfo javaInfo, final FontInfo fontInfo) {
        if (this.m_image != null) {
            this.m_image.dispose();
            this.m_image = null;
        }
        if (fontInfo != null) {
            ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    FontPreviewCanvas.this.m_image = ToolkitSupport.getFontPreview(fontInfo.getFont());
                }
            });
        }
        this.redraw();
    }
}

