/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorInfo;
import org.eclipse.wb.internal.swt.support.DisplaySupport;

public class ColorSupport {
    private static int getRed(Object color) throws Exception {
        return (Integer)ReflectionUtils.invokeMethod((Object)color, (String)"getRed()", (Object[])new Object[0]);
    }

    private static int getGreen(Object color) throws Exception {
        return (Integer)ReflectionUtils.invokeMethod((Object)color, (String)"getGreen()", (Object[])new Object[0]);
    }

    private static int getBlue(Object color) throws Exception {
        return (Integer)ReflectionUtils.invokeMethod((Object)color, (String)"getBlue()", (Object[])new Object[0]);
    }

    public static Object getCopy(Object color) throws Exception {
        Constructor constructor = ReflectionUtils.getConstructorBySignature(color.getClass(), (String)"<init>(org.eclipse.swt.graphics.Device,int,int,int)");
        return constructor.newInstance(null, ColorSupport.getRed(color), ColorSupport.getGreen(color), ColorSupport.getBlue(color));
    }

    public static Color getColor(Object color) throws Exception {
        return new Color(null, ColorSupport.getRed(color), ColorSupport.getGreen(color), ColorSupport.getBlue(color));
    }

    public static String toString(Object color) throws Exception {
        return ColorSupport.getRed(color) + "," + ColorSupport.getGreen(color) + "," + ColorSupport.getBlue(color);
    }

    public static boolean isDisposed(Object color) throws Exception {
        return (Boolean)ReflectionUtils.invokeMethod((Object)color, (String)"isDisposed()", (Object[])new Object[0]);
    }

    public static void dispose(Object color) throws Exception {
        if (!ColorSupport.isDisposed(color)) {
            ReflectionUtils.invokeMethod((Object)color, (String)"dispose()", (Object[])new Object[0]);
        }
    }

    public static ColorInfo createInfo(Object color) throws Exception {
        return new ColorInfo(ColorSupport.getRed(color), ColorSupport.getGreen(color), ColorSupport.getBlue(color));
    }

    public static ColorInfo createInfo(String name, Object color) throws Exception {
        return new ColorInfo(name, ColorSupport.getRed(color), ColorSupport.getGreen(color), ColorSupport.getBlue(color));
    }

    public static ColorInfo createInfo(Field field) throws Exception {
        String name = field.getName();
        Object color = DisplaySupport.getSystemColor(field.get(null));
        ColorInfo colorInfo = ColorSupport.createInfo(name, color);
        colorInfo.setData((Object)("org.eclipse.swt.SWT." + name));
        return colorInfo;
    }
}

