/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.buildship.core.ProjectContext;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.CoreTraceScopes;
import org.eclipse.buildship.core.internal.Logger;
import org.eclipse.buildship.core.internal.preferences.ClasspathConverter;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.util.classpath.ClasspathUtils;
import org.eclipse.buildship.core.internal.workspace.GradleClasspathContainer;
import org.eclipse.buildship.core.internal.workspace.PersistentModelBuilder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.gradle.tooling.model.eclipse.EclipseClasspathEntry;
import org.gradle.tooling.model.eclipse.EclipseExternalDependency;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.EclipseProjectDependency;

final class GradleClasspathContainerUpdater {
    private static final String UNRESOLVED_DEPENDENCY_NAME_PREFIX = "unresolved dependency - ";
    private static final Pattern UNRESOLVED_DEPENDENCY_NAME_PATTERN = Pattern.compile("^([^ ]+) ([^ ]+) ([^ ]+)$");
    private final IJavaProject eclipseProject;
    private final EclipseProject gradleProject;
    private final Map<File, EclipseProject> projectDirToProject;
    private final ProjectContext projectContext;

    private GradleClasspathContainerUpdater(IJavaProject eclipseProject, EclipseProject gradleProject, Iterable<EclipseProject> allGradleProjects, ProjectContext projectContext) {
        this.projectContext = projectContext;
        this.eclipseProject = (IJavaProject)Preconditions.checkNotNull((Object)eclipseProject);
        this.gradleProject = (EclipseProject)Preconditions.checkNotNull((Object)gradleProject);
        this.projectDirToProject = Maps.newHashMap();
        for (EclipseProject project : allGradleProjects) {
            this.projectDirToProject.put(project.getProjectDirectory(), project);
        }
    }

    private void updateClasspathContainer(PersistentModelBuilder persistentModel, IProgressMonitor monitor) throws JavaModelException {
        ImmutableList<IClasspathEntry> containerEntries = this.collectClasspathContainerEntries();
        GradleClasspathContainerUpdater.setClasspathContainer(this.eclipseProject, containerEntries, monitor);
        persistentModel.classpath((List<IClasspathEntry>)containerEntries);
    }

    private ImmutableList<IClasspathEntry> collectClasspathContainerEntries() {
        List<IClasspathEntry> externalDependencies = this.collectExternalDependencies();
        List<IClasspathEntry> projectDependencies = this.collectProjectDependencies();
        boolean hasExportedEntry = externalDependencies.stream().anyMatch(IClasspathEntry::isExported);
        if (hasExportedEntry) {
            return ImmutableList.builder().addAll(externalDependencies).addAll(projectDependencies).build();
        }
        return ImmutableList.builder().addAll(projectDependencies).addAll(externalDependencies).build();
    }

    private List<IClasspathEntry> collectExternalDependencies() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (EclipseExternalDependency dependency : this.gradleProject.getClasspath()) {
            File dependencyFile = dependency.getFile();
            boolean linkedResourceCreated = this.tryCreatingLinkedResource(dependencyFile, (ImmutableList.Builder<IClasspathEntry>)result);
            if (linkedResourceCreated) continue;
            if (this.projectContext != null && dependencyFile.getName().startsWith(UNRESOLVED_DEPENDENCY_NAME_PREFIX)) {
                String coordinates = dependencyFile.getName().substring(UNRESOLVED_DEPENDENCY_NAME_PREFIX.length());
                Matcher m = UNRESOLVED_DEPENDENCY_NAME_PATTERN.matcher(coordinates);
                if (m.matches()) {
                    String groupId = m.group(1);
                    String artifactId = m.group(2);
                    String version = m.group(3);
                    this.projectContext.error("Unresolved dependency: " + groupId + ":" + artifactId + ":" + version, null);
                    continue;
                }
                this.projectContext.error("Unresolved dependency: " + coordinates, null);
                continue;
            }
            String dependencyName = dependencyFile.getName();
            if (!dependencyFile.isDirectory() && !this.hasAcceptedSuffix(dependencyName)) continue;
            IPath path = Path.fromOSString((String)dependencyFile.getAbsolutePath());
            File dependencySource = dependency.getSource();
            IPath sourcePath = dependencySource != null ? Path.fromOSString((String)dependencySource.getAbsolutePath()) : null;
            IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)path, (IPath)sourcePath, null, (IAccessRule[])ClasspathUtils.createAccessRules((EclipseClasspathEntry)dependency), (IClasspathAttribute[])ClasspathUtils.createClasspathAttributes((EclipseClasspathEntry)dependency), (boolean)dependency.isExported());
            result.add((Object)entry);
        }
        return result.build();
    }

    private boolean hasAcceptedSuffix(String dependencyName) {
        String name = dependencyName.toLowerCase();
        return name.endsWith(".jar") || name.endsWith(".rar") || name.endsWith(".zip");
    }

    private boolean tryCreatingLinkedResource(File dependencyFile, ImmutableList.Builder<IClasspathEntry> result) {
        if (!dependencyFile.exists()) {
            Path path = new Path("/" + dependencyFile.getPath());
            IResource member = this.eclipseProject.getProject().findMember((IPath)path);
            if (member != null) {
                IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)member.getFullPath(), null, null);
                result.add((Object)entry);
                return true;
            }
        }
        return false;
    }

    private List<IClasspathEntry> collectProjectDependencies() {
        ImmutableList.Builder result = ImmutableList.builder();
        for (EclipseProjectDependency dependency : this.gradleProject.getProjectDependencies()) {
            Path path = new Path("/" + dependency.getPath());
            IClasspathEntry entry = JavaCore.newProjectEntry((IPath)path, (IAccessRule[])ClasspathUtils.createAccessRules((EclipseClasspathEntry)dependency), (boolean)true, (IClasspathAttribute[])ClasspathUtils.createClasspathAttributes((EclipseClasspathEntry)dependency), (boolean)dependency.isExported());
            result.add((Object)entry);
        }
        return result.build();
    }

    public static void updateFromModel(IJavaProject eclipseProject, EclipseProject gradleProject, Iterable<EclipseProject> allGradleProjects, PersistentModelBuilder persistentModel, IProgressMonitor monitor, ProjectContext context) throws JavaModelException {
        GradleClasspathContainerUpdater updater = new GradleClasspathContainerUpdater(eclipseProject, gradleProject, allGradleProjects, context);
        updater.updateClasspathContainer(persistentModel, monitor);
    }

    public static boolean updateFromStorage(IJavaProject eclipseProject, IProgressMonitor monitor) throws JavaModelException {
        PersistentModel model = CorePlugin.modelPersistence().loadModel(eclipseProject.getProject());
        if (model.isPresent()) {
            GradleClasspathContainerUpdater.setClasspathContainer(eclipseProject, model.getClasspath(), monitor);
            return true;
        }
        return false;
    }

    public static void clear(IJavaProject eclipseProject, IProgressMonitor monitor) throws JavaModelException {
        GradleClasspathContainerUpdater.setClasspathContainer(eclipseProject, (List<IClasspathEntry>)ImmutableList.of(), monitor);
    }

    private static void setClasspathContainer(IJavaProject eclipseProject, List<IClasspathEntry> classpathEntries, IProgressMonitor monitor) throws JavaModelException {
        GradleClasspathContainerUpdater.traceClasspathEntries(eclipseProject, classpathEntries);
        IClasspathContainer classpathContainer = GradleClasspathContainer.newInstance(classpathEntries);
        JavaCore.setClasspathContainer((IPath)GradleClasspathContainer.CONTAINER_PATH, (IJavaProject[])new IJavaProject[]{eclipseProject}, (IClasspathContainer[])new IClasspathContainer[]{classpathContainer}, (IProgressMonitor)monitor);
    }

    private static void traceClasspathEntries(IJavaProject eclipseProject, List<IClasspathEntry> classpathEntries) {
        CoreTraceScopes scope;
        Logger logger = CorePlugin.logger();
        if (logger.isScopeEnabled(scope = CoreTraceScopes.CLASSPATH)) {
            IPath path = eclipseProject.getPath().append((IPath)GradleClasspathContainer.CONTAINER_PATH);
            String entries = new ClasspathConverter(eclipseProject).toXml(classpathEntries);
            logger.trace(scope, path + "=" + entries);
        }
    }
}

