/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core;

import org.eclipse.cdt.debug.internal.core.StringSubstitutionEngine;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.IValueVariableListener;
import org.eclipse.core.variables.VariablesPlugin;

public class DebugStringVariableSubstitutor
implements IStringVariableManager {
    private final IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
    private final IProject project;

    public DebugStringVariableSubstitutor(IProject project) {
        this.project = project;
    }

    public DebugStringVariableSubstitutor(String projectName) {
        this(projectName == null || projectName.isEmpty() ? null : ResourcesPlugin.getWorkspace().getRoot().getProject(projectName));
    }

    public IStringVariable[] getVariables() {
        IStringVariable[] variables = this.variableManager.getVariables();
        int i = 0;
        while (i < variables.length) {
            IStringVariable var = variables[i];
            if (var instanceof IDynamicVariable) {
                variables[i] = this.substituteVariable((IDynamicVariable)var);
            }
            ++i;
        }
        return variables;
    }

    public IValueVariable[] getValueVariables() {
        return this.variableManager.getValueVariables();
    }

    public IValueVariable getValueVariable(String name) {
        return this.variableManager.getValueVariable(name);
    }

    public IDynamicVariable[] getDynamicVariables() {
        IDynamicVariable[] variables = this.variableManager.getDynamicVariables();
        int i = 0;
        while (i < variables.length) {
            variables[i] = this.substituteVariable(variables[i]);
            ++i;
        }
        return variables;
    }

    public IDynamicVariable getDynamicVariable(String name) {
        IDynamicVariable var = this.variableManager.getDynamicVariable(name);
        if (var == null) {
            return null;
        }
        return this.substituteVariable(var);
    }

    private IDynamicVariable substituteVariable(IDynamicVariable var) {
        String name = var.getName();
        if ("project_loc".equals(name) || "project_name".equals(name) || "project_path".equals(name)) {
            return new ProjectVariable(name, var.getDescription(), this.project);
        }
        return var;
    }

    public String getContributingPluginId(IStringVariable variable) {
        return this.variableManager.getContributingPluginId(variable);
    }

    public String performStringSubstitution(String expression) throws CoreException {
        return this.performStringSubstitution(expression, true);
    }

    public String performStringSubstitution(String expression, boolean reportUndefinedVariables) throws CoreException {
        return new StringSubstitutionEngine().performStringSubstitution(expression, reportUndefinedVariables, true, this);
    }

    public void validateStringVariables(String expression) throws CoreException {
        new StringSubstitutionEngine().validateStringVariables(expression, this);
    }

    public IValueVariable newValueVariable(String name, String description) {
        return this.variableManager.newValueVariable(name, description);
    }

    public IValueVariable newValueVariable(String name, String description, boolean readOnly, String value) {
        return this.variableManager.newValueVariable(name, description, readOnly, value);
    }

    public void addVariables(IValueVariable[] variables) throws CoreException {
        this.variableManager.addVariables(variables);
    }

    public void removeVariables(IValueVariable[] variables) {
        this.variableManager.removeVariables(variables);
    }

    public void addValueVariableListener(IValueVariableListener listener) {
        this.variableManager.addValueVariableListener(listener);
    }

    public void removeValueVariableListener(IValueVariableListener listener) {
        this.variableManager.removeValueVariableListener(listener);
    }

    public String generateVariableExpression(String varName, String arg) {
        return this.variableManager.generateVariableExpression(varName, arg);
    }

    private static class ProjectVariable
    implements IDynamicVariable {
        final String name;
        final IProject project;
        final String description;

        ProjectVariable(String name, String description, IProject project) {
            this.name = name;
            this.description = description;
            this.project = project;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getValue(String argument) throws CoreException {
            IProject project = this.project;
            if (argument != null) {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                IPath path = Path.fromOSString((String)argument);
                IProject iProject = project = path.isEmpty() ? null : root.getProject(path.segment(0));
            }
            if (project == null) {
                return null;
            }
            if (this.name.endsWith("_name")) {
                return project.getName();
            }
            if (this.name.endsWith("_loc")) {
                return project.getLocation().toOSString();
            }
            if (this.name.endsWith("_path")) {
                return project.getProjectRelativePath().toString();
            }
            return null;
        }

        public boolean supportsArgument() {
            return true;
        }
    }
}

