/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.disassembly;

import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.debug.ui.breakpoints.IToggleBreakpointsTargetCExtension;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions.AbstractDisassemblyBreakpointRulerAction;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblyPart;
import org.eclipse.cdt.dsf.gdb.internal.ui.disassembly.DisassemblyMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetFactory;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class AddDynamicPrintfRulerAction
extends AbstractDisassemblyBreakpointRulerAction {
    private IToggleBreakpointsTargetCExtension fDynamicPrintfBreakpointsTarget;

    protected AddDynamicPrintfRulerAction(IDisassemblyPart disassemblyPart, IVerticalRulerInfo rulerInfo) {
        super(disassemblyPart, rulerInfo);
        this.setText(DisassemblyMessages.Disassembly_action_AddDynamicPrintf_label);
    }

    public void run() {
        if (this.fDynamicPrintfBreakpointsTarget != null) {
            IDisassemblyPart part = this.getDisassemblyPart();
            ISelection selection = this.getSelection();
            try {
                if (this.fDynamicPrintfBreakpointsTarget.canCreateLineBreakpointsInteractive((IWorkbenchPart)part, selection)) {
                    this.fDynamicPrintfBreakpointsTarget.createLineBreakpointsInteractive((IWorkbenchPart)part, selection);
                }
            }
            catch (CoreException e) {
                this.reportException((Exception)((Object)e));
            }
        }
    }

    public void update() {
        IDisassemblyPart part = this.getDisassemblyPart();
        if (part != null && part.isConnected()) {
            ISelection selection = this.getSelection();
            if (this.fDynamicPrintfBreakpointsTarget == null) {
                this.fDynamicPrintfBreakpointsTarget = this.fetchDynamicPrintfBreakpointsTarget(selection);
            }
            if (this.fDynamicPrintfBreakpointsTarget == null) {
                this.setEnabled(false);
                return;
            }
            if (this.fDynamicPrintfBreakpointsTarget.canCreateLineBreakpointsInteractive((IWorkbenchPart)part, selection)) {
                this.setEnabled(true);
                return;
            }
        }
        this.setEnabled(false);
    }

    private void reportException(Exception e) {
        Status status = new Status(4, "org.eclipse.cdt.debug.ui", "Error creating dynamic printf: ", (Throwable)e);
        ErrorDialog.openError((Shell)this.getDisassemblyPart().getSite().getShell(), (String)DisassemblyMessages.Disassembly_action_AddDynamicPrintf_errorTitle, (String)DisassemblyMessages.Disassembly_action_AddDynamicPrintf_errorMessage, (IStatus)status);
        CDebugUIPlugin.log((IStatus)status);
    }

    private ISelection getSelection() {
        IDocument document = this.getDocument();
        if (document != null) {
            int line = this.getRulerInfo().getLineOfLastMouseButtonActivity();
            try {
                ISelection selection;
                IRegion region = this.getDocument().getLineInformation(line);
                TextSelection textSelection = new TextSelection(document, region.getOffset(), 0);
                ISelectionProvider provider = this.getDisassemblyPart().getSite().getSelectionProvider();
                if (provider != null && (selection = provider.getSelection()) instanceof ITextSelection && ((ITextSelection)selection).getStartLine() <= line && ((ITextSelection)selection).getEndLine() >= line) {
                    textSelection = (ITextSelection)selection;
                }
                return textSelection;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return StructuredSelection.EMPTY;
    }

    private IToggleBreakpointsTargetCExtension fetchDynamicPrintfBreakpointsTarget(ISelection selection) {
        if (this.fDynamicPrintfBreakpointsTarget == null) {
            IExtensionPoint ep = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.debug.ui", "toggleBreakpointsTargetFactories");
            IConfigurationElement[] elements = ep.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                String id = elements[i].getAttribute("id");
                if (id != null && id.equals("org.eclipse.cdt.dsf.gdb.ui.ToggleDynamicPrintfTargetFactory")) {
                    try {
                        IToggleBreakpointsTarget target;
                        Object obj = elements[i].createExecutableExtension("class");
                        if (!(obj instanceof IToggleBreakpointsTargetFactory) || !((target = ((IToggleBreakpointsTargetFactory)obj).createToggleTarget("org.eclipse.cdt.debug.ui.toggleCDynamicPrintfTarget")) instanceof IToggleBreakpointsTargetCExtension)) break;
                        this.fDynamicPrintfBreakpointsTarget = (IToggleBreakpointsTargetCExtension)target;
                    }
                    catch (CoreException coreException) {}
                    break;
                }
                ++i;
            }
        }
        return this.fDynamicPrintfBreakpointsTarget;
    }
}

