/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.dataprovider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.settings.model.ICConfigExtensionReference;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.ICProjectConverter;
import org.eclipse.cdt.core.settings.model.util.PathEntryTranslator;
import org.eclipse.cdt.internal.core.cdtvariables.StorableCdtVariables;
import org.eclipse.cdt.internal.core.cdtvariables.UserDefinedVariableSupplier;
import org.eclipse.cdt.make.core.IMakeTarget;
import org.eclipse.cdt.make.core.IMakeTargetManager;
import org.eclipse.cdt.make.core.MakeCorePlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.BuilderFactory;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildConfigurationData;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.ConfigurationDataProvider;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.DataProviderMessages;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.ResourcePropertyHolder;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IOverwriteQuery;

public class ProjectConverter
implements ICProjectConverter {
    private static final String OLD_MAKE_BUILDER_ID = "org.eclipse.cdt.make.core.makeBuilder";
    private static final String OLD_MAKE_NATURE_ID = "org.eclipse.cdt.make.core.makeNature";
    private static final String OLD_MNG_BUILDER_ID = "org.eclipse.cdt.managedbuilder.core.genmakebuilder";
    private static final String OLD_MNG_NATURE_ID = "org.eclipse.cdt.managedbuilder.core.managedBuildNature";
    private static final String OLD_DISCOVERY_MODULE_ID = "scannerConfiguration";
    private static final String OLD_BINARY_PARSER_ID = "org.eclipse.cdt.core.BinaryParser";
    private static final String OLD_ERROR_PARSER_ID = "org.eclipse.cdt.core.ErrorParser";
    private static final String OLD_PATH_ENTRY_ID = "org.eclipse.cdt.core.pathentry";
    private static final String OLD_DISCOVERY_NATURE_ID = "org.eclipse.cdt.make.core.ScannerConfigNature";
    private static final String OLD_DISCOVERY_BUILDER_ID = "org.eclipse.cdt.make.core.ScannerConfigBuilder";
    private static final String OLD_MAKE_TARGET_BUIDER_ID = "org.eclipse.cdt.make.MakeTargetBuilder";
    private static final String NEW_MAKE_TARGET_BUIDER_ID = "org.eclipse.cdt.build.MakeTargetBuilder";
    private static ResourcePropertyHolder PROPS = new ResourcePropertyHolder(true);
    private static String CONVERSION_FAILED_MSG_ID = "conversionFailed";

    public boolean canConvertProject(IProject project, String oldOwnerId, ICProjectDescription oldDes) {
        HashSet<String> natureSet;
        block6: {
            block5: {
                if (oldOwnerId != null && oldDes != null) break block5;
                return false;
            }
            IProjectDescription eDes = project.getDescription();
            natureSet = new HashSet<String>(Arrays.asList(eDes.getNatureIds()));
            if (!natureSet.contains(OLD_MAKE_NATURE_ID)) break block6;
            return true;
        }
        try {
            if (natureSet.contains(OLD_MNG_NATURE_ID)) {
                return true;
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    public ICProjectDescription convertProject(IProject project, IProjectDescription eDes, String oldOwnerId, ICProjectDescription oldDes) throws CoreException {
        HashSet<String> natureSet = new HashSet<String>(Arrays.asList(eDes.getNatureIds()));
        CoreModel model = CoreModel.getDefault();
        ICProjectDescription newDes = null;
        IManagedBuildInfo info = null;
        String[] binErrParserIds = null;
        if (natureSet.contains(OLD_MAKE_NATURE_ID)) {
            newDes = oldDes;
            ICConfigurationDescription des = newDes.getConfigurations()[0];
            ICConfigExtensionReference[] refs = des.get(OLD_BINARY_PARSER_ID);
            if (refs.length != 0) {
                binErrParserIds = new String[refs.length];
                int i = 0;
                while (i < refs.length) {
                    binErrParserIds[i] = refs[i].getID();
                    ++i;
                }
            }
            info = ManagedBuildManager.createBuildInfo((IResource)project);
            ManagedProject mProj = new ManagedProject(newDes);
            info.setManagedProject(mProj);
            Configuration cfg = ConfigurationDataProvider.getClearPreference(des.getId());
            cfg.applyToManagedProject(mProj);
            cfg.setConfigurationDescription(des);
            des.setConfigurationData("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", cfg.getConfigurationData());
        } else if (natureSet.contains(OLD_MNG_NATURE_ID)) {
            try {
                if (PROPS.getProperty((IResource)project, CONVERSION_FAILED_MSG_ID) != null) {
                    throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), DataProviderMessages.getString("ProjectConverter.0")));
                }
                newDes = model.createProjectDescription(project, false);
                info = this.convertManagedBuildInfo(project, newDes);
            }
            catch (CoreException e) {
                ProjectConverter.displayInfo(project, CONVERSION_FAILED_MSG_ID, DataProviderMessages.getString("ProjectConverter.10"), DataProviderMessages.getFormattedString("ProjectConverter.11", new String[]{project.getName(), e.getLocalizedMessage()}));
                throw e;
            }
        }
        if (newDes == null || !newDes.isValid() || newDes.getConfigurations().length == 0) {
            newDes = null;
        } else {
            boolean changeEDes = false;
            if (natureSet.remove(OLD_MAKE_NATURE_ID)) {
                changeEDes = true;
            }
            if (natureSet.remove(OLD_DISCOVERY_NATURE_ID)) {
                changeEDes = true;
            }
            if (changeEDes) {
                eDes.setNatureIds(natureSet.toArray(new String[natureSet.size()]));
            }
            changeEDes = false;
            ICommand[] cmds = eDes.getBuildSpec();
            ArrayList<ICommand> list = new ArrayList<ICommand>(Arrays.asList(cmds));
            ICommand makeBuilderCmd = null;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ICommand cmd = (ICommand)iter.next();
                if (OLD_MAKE_BUILDER_ID.equals(cmd.getBuilderName())) {
                    makeBuilderCmd = cmd;
                    iter.remove();
                    changeEDes = true;
                    continue;
                }
                if (!OLD_DISCOVERY_BUILDER_ID.equals(cmd.getBuilderName())) continue;
                iter.remove();
                changeEDes = true;
            }
            ICConfigurationDescription[] cfgDess = newDes.getConfigurations();
            int i = 0;
            while (i < cfgDess.length) {
                ICConfigurationDescription cfgDes = cfgDess[i];
                BuildConfigurationData data = (BuildConfigurationData)cfgDes.getConfigurationData();
                IConfiguration cfg = ManagedBuildManager.getConfigurationForDescription(cfgDes);
                if (makeBuilderCmd != null) {
                    this.loadBuilderSettings(cfg, makeBuilderCmd);
                }
                this.loadPathEntryInfo(project, cfgDes, data);
                if (binErrParserIds != null) {
                    data.getTargetPlatformData().setBinaryParserIds(binErrParserIds);
                    cfgDes.get(OLD_BINARY_PARSER_ID);
                }
                try {
                    ConfigurationDataProvider.writeConfiguration(cfgDes, data);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                ++i;
            }
            if (changeEDes) {
                cmds = list.toArray(new ICommand[list.size()]);
                eDes.setBuildSpec(cmds);
            }
            info.setValid(true);
            try {
                ManagedBuildManager.setLoaddedBuildInfo(project, info);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return newDes;
    }

    static void displayInfo(IProject proj, String id, String title, String message) {
        if (PROPS.getProperty((IResource)proj, id) == null) {
            ProjectConverter.openInformation((IResource)proj, id, title, message, false);
            PROPS.setProperty((IResource)proj, id, Boolean.TRUE);
        }
    }

    public static boolean getBooleanFromQueryAnswer(String answer) {
        return "ALL".equalsIgnoreCase(answer) || "YES".equalsIgnoreCase(answer);
    }

    public static boolean openQuestion(IResource rc, String id, String title, String message, IOverwriteQuery query, boolean multiple) {
        if (query != null) {
            return ProjectConverter.getBooleanFromQueryAnswer(query.queryOverwrite(message));
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            window = windows[0];
        }
        Shell shell = window.getShell();
        boolean[] answer = new boolean[1];
        shell.getDisplay().syncExec(() -> {
            Boolean ob = PROPS.getProperty(rc, id);
            if (multiple || ob == null) {
                PROPS.setProperty(rc, id, Boolean.TRUE);
                blArray[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
                PROPS.setProperty(rc, id, answer[0] ? Boolean.TRUE : Boolean.FALSE);
            } else {
                blArray[0] = ob;
            }
        });
        return answer[0];
    }

    private static void openInformation(IResource rc, String id, String title, String message, boolean multiple) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            window = windows[0];
        }
        Shell shell = window.getShell();
        shell.getDisplay().syncExec(() -> {
            if (multiple || PROPS.getProperty(rc, id) == null) {
                PROPS.setProperty(rc, id, Boolean.TRUE);
                MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
            }
        });
    }

    private static void convertMakeTargetInfo(IProject project, ICProjectDescription des, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        CCorePlugin.getDefault().getCDescriptorManager().runDescriptorOperation(project, des, (descriptor, monitor1) -> {
            IMakeTargetManager mngr = MakeCorePlugin.getDefault().getTargetManager();
            project.accept(resource -> {
                if (resource.getType() == 1) {
                    return false;
                }
                try {
                    IContainer cr = (IContainer)resource;
                    IMakeTarget[] targets = mngr.getTargets(cr);
                    int i = 0;
                    while (i < targets.length) {
                        IMakeTarget t = targets[i];
                        if (OLD_MAKE_TARGET_BUIDER_ID.equals(t.getTargetBuilderID())) {
                            IMakeTarget newT = mngr.createTarget(project, t.getName(), NEW_MAKE_TARGET_BUIDER_ID);
                            ProjectConverter.copySettings(t, newT);
                            mngr.removeTarget(t);
                            mngr.addTarget(cr, newT);
                        }
                        ++i;
                    }
                }
                catch (CoreException e) {
                    ManagedBuilderCorePlugin.log(e);
                }
                return true;
            });
        }, monitor);
    }

    private static void copySettings(IMakeTarget fromTarget, IMakeTarget toTarget) throws CoreException {
        toTarget.setAppendEnvironment(fromTarget.appendEnvironment());
        toTarget.setAppendProjectEnvironment(fromTarget.appendProjectEnvironment());
        toTarget.setBuildAttribute(IMakeTarget.BUILD_LOCATION, fromTarget.getBuildAttribute(IMakeTarget.BUILD_LOCATION, null));
        toTarget.setBuildAttribute(IMakeTarget.BUILD_COMMAND, fromTarget.getBuildAttribute(IMakeTarget.BUILD_COMMAND, null));
        toTarget.setBuildAttribute(IMakeTarget.BUILD_ARGUMENTS, fromTarget.getBuildAttribute(IMakeTarget.BUILD_ARGUMENTS, null));
        toTarget.setBuildAttribute(IMakeTarget.BUILD_TARGET, fromTarget.getBuildAttribute(IMakeTarget.BUILD_TARGET, null));
        Map fromMap = fromTarget.getEnvironment();
        if (fromMap != null) {
            toTarget.setEnvironment(new HashMap(fromMap));
        }
        toTarget.setRunAllBuilders(fromTarget.runAllBuilders());
        toTarget.setStopOnError(fromTarget.isStopOnError());
        toTarget.setUseDefaultBuildCmd(fromTarget.isDefaultBuildCmd());
        toTarget.setContainer(fromTarget.getContainer());
    }

    private void loadPathEntryInfo(IProject project, ICConfigurationDescription des, CConfigurationData data) {
        try {
            ICStorageElement el = des.getStorage(OLD_PATH_ENTRY_ID, false);
            if (el != null) {
                IPathEntry[] entries = PathEntryTranslator.decodePathEntries((IProject)project, (ICStorageElement)el);
                if (entries.length != 0) {
                    ArrayList<IPathEntry> list = new ArrayList<IPathEntry>(Arrays.asList(entries));
                    Iterator iter = list.iterator();
                    while (iter.hasNext()) {
                        IPathEntry entry = (IPathEntry)iter.next();
                        if (entry.getEntryKind() != 32) continue;
                        iter.remove();
                    }
                    if (list.size() != 0) {
                        IPath[] projPaths;
                        PathEntryTranslator tr = new PathEntryTranslator(project, data);
                        entries = list.toArray(new IPathEntry[list.size()]);
                        PathEntryTranslator.ReferenceSettingsInfo refInfo = tr.applyPathEntries(entries, null, 3);
                        ICExternalSetting[] extSettings = refInfo.getExternalSettings();
                        des.removeExternalSettings();
                        if (extSettings.length != 0) {
                            int i = 0;
                            while (i < extSettings.length) {
                                ICExternalSetting setting = extSettings[i];
                                des.createExternalSetting(setting.getCompatibleLanguageIds(), setting.getCompatibleContentTypeIds(), setting.getCompatibleExtensions(), setting.getEntries());
                                ++i;
                            }
                        }
                        if ((projPaths = refInfo.getReferencedProjectsPaths()).length != 0) {
                            HashMap<String, String> map = new HashMap<String, String>(projPaths.length);
                            int i = 0;
                            while (i < projPaths.length) {
                                map.put(projPaths[i].segment(0), "");
                                ++i;
                            }
                            des.setReferenceInfo(map);
                        }
                    }
                }
                des.removeStorage(OLD_PATH_ENTRY_ID);
            }
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
        }
    }

    private void loadBuilderSettings(IConfiguration cfg, ICommand cmd) {
        Builder builder = (Builder)BuilderFactory.createBuilderFromCommand(cfg, cmd);
        if (builder.getCommand() != null && builder.getCommand().length() != 0) {
            String[] errParserIds = builder.getCustomizedErrorParserIds();
            builder.setCustomizedErrorParserIds(null);
            ((ToolChain)cfg.getToolChain()).setBuilder(builder);
            if (errParserIds != null && errParserIds.length != 0) {
                cfg.setErrorParserList(errParserIds);
            }
        }
    }

    private static boolean convertOldStdMakeToNewStyle(final IProject project, boolean checkOnly, IProgressMonitor monitor, boolean throwExceptions) throws CoreException {
        block20: {
            ICProjectDescription newDes;
            IProjectDescription eDes;
            block22: {
                ICProjectDescription oldDes;
                ProjectConverter instance;
                block21: {
                    block19: {
                        block18: {
                            ICConfigurationDescription[] cfgs;
                            block17: {
                                ICProjectDescription des;
                                block16: {
                                    try {
                                        des = CCorePlugin.getDefault().getProjectDescription(project, false);
                                        if (des != null) break block16;
                                        if (throwExceptions) {
                                            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), DataProviderMessages.getString("ProjectConverter.9")));
                                        }
                                        return false;
                                    }
                                    catch (CoreException e) {
                                        if (throwExceptions) {
                                            throw e;
                                        }
                                        ManagedBuilderCorePlugin.log(e);
                                        if (throwExceptions) {
                                            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), DataProviderMessages.getString("ProjectConverter.8")));
                                        }
                                        return false;
                                    }
                                }
                                cfgs = des.getConfigurations();
                                if (cfgs.length == 1) break block17;
                                if (throwExceptions) {
                                    throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), DataProviderMessages.getString("ProjectConverter.2") + cfgs.length));
                                }
                                return false;
                            }
                            if ("org.eclipse.cdt.core.defaultConfigDataProvider".equals(cfgs[0].getBuildSystemId())) break block18;
                            if (throwExceptions) {
                                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), DataProviderMessages.getString("ProjectConverter.3") + cfgs.length));
                            }
                            return false;
                        }
                        eDes = project.getDescription();
                        String[] natureIds = eDes.getNatureIds();
                        HashSet<String> set = new HashSet<String>(Arrays.asList(natureIds));
                        if (set.contains(OLD_MAKE_NATURE_ID)) break block19;
                        if (throwExceptions) {
                            throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), DataProviderMessages.getString("ProjectConverter.4") + natureIds.toString()));
                        }
                        return false;
                    }
                    if (checkOnly) break block20;
                    instance = new ProjectConverter();
                    oldDes = CCorePlugin.getDefault().getProjectDescription(project);
                    if (instance.canConvertProject(project, MakeCorePlugin.MAKE_PROJECT_ID, oldDes)) break block21;
                    if (throwExceptions) {
                        throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), DataProviderMessages.getString("ProjectConverter.5")));
                    }
                    return false;
                }
                newDes = instance.convertProject(project, eDes, MakeCorePlugin.MAKE_PROJECT_ID, oldDes);
                if (newDes != null) break block22;
                if (throwExceptions) {
                    throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), DataProviderMessages.getString("ProjectConverter.6")));
                }
                return false;
            }
            IWorkspace wsp = ResourcesPlugin.getWorkspace();
            wsp.run(monitor1 -> {
                project.setDescription(eDes, monitor1);
                CCorePlugin.getDefault().setProjectDescription(project, newDes);
                Job job = new Job(DataProviderMessages.getString("ProjectConverter.7")){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            ICProjectDescription des = CCorePlugin.getDefault().getProjectDescription(project);
                            ProjectConverter.convertMakeTargetInfo(project, des, monitor);
                            CCorePlugin.getDefault().setProjectDescription(project, des);
                        }
                        catch (CoreException e) {
                            return e.getStatus();
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setRule((ISchedulingRule)wsp.getRoot());
                job.schedule();
            }, (ISchedulingRule)wsp.getRoot(), 1, monitor);
        }
        return true;
    }

    public static boolean isOldStyleMakeProject(IProject project) {
        try {
            return ProjectConverter.convertOldStdMakeToNewStyle(project, true, null, false);
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
            return false;
        }
    }

    public static void convertOldStdMakeToNewStyle(IProject project, IProgressMonitor monitor) throws CoreException {
        ProjectConverter.convertOldStdMakeToNewStyle(project, false, monitor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IManagedBuildInfo convertManagedBuildInfo(IProject project, ICProjectDescription newDes) throws CoreException {
        IManagedBuildInfo info = ManagedBuildManager.getOldStyleBuildInfo(project);
        ResourcePropertyHolder resourcePropertyHolder = PROPS;
        synchronized (resourcePropertyHolder) {
            if (info != null && info.isValid()) {
                IManagedProject mProj = info.getManagedProject();
                IConfiguration[] cfgs = mProj.getConfigurations();
                if (cfgs.length != 0) {
                    UserDefinedVariableSupplier usrSupplier = UserDefinedVariableSupplier.getInstance();
                    int i = 0;
                    while (i < cfgs.length) {
                        Configuration cfg = (Configuration)cfgs[i];
                        CConfigurationData data = cfg.getConfigurationData();
                        ICConfigurationDescription cfgDes = newDes.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data);
                        if (cfg.getConfigurationDescription() != null) {
                            cfg = ConfigurationDataProvider.copyCfg(cfg, cfgDes);
                            cfgDes.setConfigurationData("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", cfg.getConfigurationData());
                        }
                        cfg.setConfigurationDescription(cfgDes);
                        StorableCdtVariables vars = ((ToolChain)cfg.getToolChain()).getResetOldStyleProjectVariables();
                        if (vars != null) {
                            ICdtVariable[] vs = vars.getMacros();
                            int k = 0;
                            while (k < vs.length) {
                                usrSupplier.createMacro(vs[k], 3, (Object)cfgDes);
                                ++k;
                            }
                        }
                        cfg.exportArtifactInfo();
                        ++i;
                    }
                }
            } else {
                throw new CoreException((IStatus)new Status(4, ManagedBuilderCorePlugin.getUniqueIdentifier(), DataProviderMessages.getString("ProjectConverter.13")));
            }
        }
        return info;
    }
}

