/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.cdt.internal.ui.text.CWordFinder;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.FindNextAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class FindWordAction
extends TextEditorAction {
    public static final String FIND_WORD = "FindWord";
    private ITextViewer fViewer;
    private FindNextAction fFindNext;

    public FindWordAction(ResourceBundle bundle, String prefix, ITextEditor editor, ITextViewer viewer) {
        super(bundle, prefix, editor);
        this.fViewer = viewer;
        this.fFindNext = new FindNextAction(bundle, prefix, (IWorkbenchPart)editor, true);
    }

    public void run() {
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        ISelectionProvider selectionProvider = editor.getSelectionProvider();
        if (selectionProvider == null) {
            return;
        }
        ITextSelection selection = (ITextSelection)selectionProvider.getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        IDocumentProvider docProvider = editor.getDocumentProvider();
        IEditorInput input = editor.getEditorInput();
        if (docProvider == null || input == null) {
            return;
        }
        IDocument document = docProvider.getDocument((Object)input);
        if (document == null) {
            return;
        }
        IResource resource = (IResource)input.getAdapter(IResource.class);
        if (resource == null || !(resource instanceof IFile)) {
            return;
        }
        int offset = selection.getOffset();
        IRegion region = CWordFinder.findWord(document, offset);
        if (region == null || region.getLength() == 0) {
            return;
        }
        this.fViewer.setSelectedRange(region.getOffset(), region.getLength());
        this.fFindNext.run();
    }
}

