/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.console.profile.internal;

import java.io.File;
import org.eclipse.datatools.connectivity.console.profile.internal.ProfileFileProcessor;
import org.eclipse.datatools.connectivity.console.profile.internal.SystemIOUtil;
import org.eclipse.datatools.connectivity.console.profile.nls.Messages;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class EditorCmdAppl
implements IApplication {
    private static final String INPUT_FILE_ARG_KEY = "-in";
    private static final String OUTPUT_FILE_ARG_KEY = "-out";
    private static final String PROFILE_NAME_ARG_KEY = "-profile";
    private static final String HELP_SYNTAX = "-?";
    private static final String APPLICATION_ID = "StorageFileEditor";
    private static final int NUM_PROMPT_FILE_RETRY = 3;
    private File m_inFile;
    private File m_outFile;
    private String m_editProfileName;
    private SystemIOUtil m_ioUtil = new SystemIOUtil();

    public Object start(IApplicationContext context) throws Exception {
        ProfileFileProcessor handler;
        int numProfiles;
        this.m_ioUtil.printNewLine(Messages.bind((String)Messages.editorAppl_startAppl, (Object)APPLICATION_ID));
        this.processCmdArguments(context);
        if (this.m_inFile == null) {
            this.m_inFile = this.promptForInputFile();
            if (this.m_inFile == null) {
                return this.normalExit();
            }
        }
        if (this.m_outFile == null) {
            this.m_outFile = this.promptForOutputFile();
            if (this.m_outFile == null) {
                return this.normalExit();
            }
        }
        if (this.m_editProfileName == null) {
            this.m_editProfileName = this.promptForProfileName();
        }
        if ((numProfiles = (handler = new ProfileFileProcessor(this.m_ioUtil)).loadProfileFile(this.m_inFile)) == 0) {
            return this.normalExit();
        }
        boolean hasUpdates = handler.updateProfiles(this.m_editProfileName);
        if (hasUpdates) {
            handler.saveUpdatedProfiles(this.m_outFile);
        } else {
            this.m_ioUtil.println(Messages.editorAppl_noProfileChanges);
        }
        return this.normalExit();
    }

    private Object normalExit() {
        this.m_ioUtil.println(Messages.bind((String)Messages.editorAppl_exitAppl, (Object)APPLICATION_ID));
        this.m_ioUtil.close();
        return EXIT_OK;
    }

    public void stop() {
        this.m_ioUtil.close();
    }

    private void processCmdArguments(IApplicationContext context) {
        String[] args = (String[])context.getArguments().get("application.args");
        if (args.length == 0) {
            return;
        }
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equalsIgnoreCase(INPUT_FILE_ARG_KEY)) {
                if (i + 1 >= args.length) {
                    this.printMissingArgumentError(INPUT_FILE_ARG_KEY);
                } else {
                    String inFileName = args[++i];
                    this.printArgumentValue(INPUT_FILE_ARG_KEY, inFileName);
                    this.m_inFile = this.validateInputFile(inFileName);
                }
            } else if (arg.equalsIgnoreCase(OUTPUT_FILE_ARG_KEY)) {
                if (i + 1 >= args.length) {
                    this.printMissingArgumentError(OUTPUT_FILE_ARG_KEY);
                } else {
                    String outFileName = args[++i];
                    this.printArgumentValue(OUTPUT_FILE_ARG_KEY, outFileName);
                    this.m_outFile = this.validateOutputFile(outFileName);
                }
            } else if (arg.equalsIgnoreCase(PROFILE_NAME_ARG_KEY)) {
                if (i + 1 >= args.length) {
                    this.printMissingArgumentError(PROFILE_NAME_ARG_KEY);
                } else {
                    this.m_editProfileName = args[++i];
                    this.printArgumentValue(PROFILE_NAME_ARG_KEY, this.m_editProfileName);
                }
            } else if (arg.equalsIgnoreCase(HELP_SYNTAX)) {
                this.printCommandSyntax();
            }
            ++i;
        }
    }

    private void printMissingArgumentError(String argKey) {
        this.m_ioUtil.println(Messages.bind((String)Messages.editorAppl_missingArgValue, (Object)argKey));
    }

    private void printArgumentValue(String argKey, String argValue) {
        this.m_ioUtil.println(Messages.bind((String)Messages.editorAppl_argKeyValue, (Object)argKey, (Object)argValue));
    }

    private File validateInputFile(String inFileName) {
        if (inFileName.trim().length() == 0) {
            this.m_ioUtil.println(Messages.bind((String)Messages.editorAppl_invalidFileName, (Object)inFileName));
            return null;
        }
        File inFile = new File(inFileName);
        if (inFile.exists() && inFile.isFile()) {
            return inFile;
        }
        String errorMsg = Messages.bind((String)Messages.editorAppl_invalidInputFile, (Object)inFile.getAbsoluteFile());
        this.m_ioUtil.println(errorMsg);
        return null;
    }

    private File validateOutputFile(String outFileName) {
        if (outFileName.trim().length() == 0) {
            this.m_ioUtil.println(Messages.bind((String)Messages.editorAppl_invalidFileName, (Object)outFileName));
            return null;
        }
        File outFile = new File(outFileName);
        if (!outFile.exists()) {
            return outFile;
        }
        if (outFile.isFile() && this.m_ioUtil.promptYesNoResponse(Messages.bind((String)Messages.editorAppl_overwriteExistingFile, (Object)outFile.getAbsoluteFile()))) {
            return outFile;
        }
        String errorMsg = Messages.bind((String)Messages.editorAppl_invalidOutputFile, (Object)outFile.getAbsoluteFile());
        this.m_ioUtil.println(errorMsg);
        return null;
    }

    private File promptForInputFile() {
        File inFile = null;
        this.m_ioUtil.printNewLine();
        int i = 0;
        while (inFile == null && i < 3) {
            String inFileName = this.m_ioUtil.promptForInput(Messages.editorAppl_promptInputFile);
            inFile = this.validateInputFile(inFileName);
            ++i;
        }
        return inFile;
    }

    private File promptForOutputFile() {
        File outFile = null;
        this.m_ioUtil.printNewLine();
        int i = 0;
        while (outFile == null && i < 3) {
            String outFileName = this.m_ioUtil.promptForInput(Messages.editorAppl_promptOutputFile);
            outFile = this.validateOutputFile(outFileName);
            ++i;
        }
        return outFile;
    }

    private String promptForProfileName() {
        this.m_ioUtil.printNewLine();
        return this.m_ioUtil.promptForInput(Messages.editorAppl_promptEditProfileName);
    }

    private void printCommandSyntax() {
        this.m_ioUtil.printNewLine(Messages.editorAppl_syntaxUsage);
        this.m_ioUtil.println("    eclipse[c] -nosplash -application org.eclipse.datatools.connectivity.console.profile.StorageFileEditor");
        this.m_ioUtil.println("      [ -? |");
        this.m_ioUtil.println("        -in <connectionProfileFile> |");
        this.m_ioUtil.println("        -out <saveAsFile> |");
        this.m_ioUtil.println("        -profile <profileName> ]");
        this.m_ioUtil.printNewLine(Messages.editorAppl_syntaxCommand);
        this.m_ioUtil.printNewLine(Messages.editorAppl_syntaxArguments);
        this.m_ioUtil.println("    -? : " + Messages.editorAppl_syntaxHelpInstruction);
        this.m_ioUtil.println("    -in <connectionProfileFile> : " + Messages.editorAppl_syntaxInArgInstruction);
        this.m_ioUtil.println("    -out <saveAsFile> : " + Messages.editorAppl_syntaxOutArgInstruction);
        this.m_ioUtil.println("    -profile <profileName> : " + Messages.editorAppl_syntaxProfileNameInstruction1);
        this.m_ioUtil.println("                             " + Messages.editorAppl_syntaxProfileNameInstruction2);
        this.m_ioUtil.println("    " + Messages.editorAppl_syntaxNullArgInstruction);
        this.m_ioUtil.printNewLine();
    }
}

