/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.deltaddl;

import java.util.List;
import java.util.Map;
import org.eclipse.datatools.enablement.ase.ISybaseASEDdlConstants;
import org.eclipse.datatools.enablement.ase.ddl.ASEDdlUtils;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.CacheInfo;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEBaseTable;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASECache;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEIndex;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASESegment;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseasesqlmodelPackage;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlUtils;
import org.eclipse.datatools.enablement.sybase.deltaddl.AbstractDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.PrimaryKey;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsPackage;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;

public class SybaseASEIndexDeltaDdlGenProvider
extends AbstractDeltaDdlGenProvider
implements IDeltaDdlGenProvider,
ISybaseASEDdlConstants {
    public void analyze(SQLObject element, Map changeMap, Map modificationRecords) {
        List records;
        int flag;
        boolean isSysGenIndex;
        super.analyze(element, changeMap, modificationRecords);
        SybaseASEIndex index = (SybaseASEIndex)element;
        boolean bl = isSysGenIndex = index.isSystemGenerated() || index.eContainer() instanceof UniqueConstraint;
        if (isSysGenIndex && ((flag = ((Integer)changeMap.get(element)).intValue()) & 3) != 0) {
            changeMap.remove(element);
        }
        if ((records = (List)modificationRecords.get(element)) != null) {
            int i = records.size() - 1;
            while (i >= 0) {
                SybaseDeltaDdlGeneration.FeatureChangeRecord rc = (SybaseDeltaDdlGeneration.FeatureChangeRecord)records.get(i);
                EStructuralFeature feature = rc.feature;
                if (this.needRecreate(feature) && !SybaseDdlUtils.isEqualIndexMembers((Object)rc.newValue, (Object)rc.oldValue)) {
                    changeMap.remove(element);
                    if (element instanceof SybaseASEIndex) {
                        if (isSysGenIndex) {
                            int flag2;
                            EObject container = element.eContainer();
                            if (container.eContainer() instanceof PrimaryKey) {
                                container = container.eContainer();
                            }
                            if (changeMap.get(element = (SQLObject)container) != null && ((flag2 = ((Integer)changeMap.get(element)).intValue()) & 3) == 0) {
                                changeMap.put(element, 3);
                            }
                        } else {
                            changeMap.put(element, 3);
                        }
                    }
                }
                --i;
            }
        }
    }

    protected boolean needRecreate(EStructuralFeature feature) {
        if (feature != null) {
            switch (feature.getFeatureID()) {
                case 1: {
                    return false;
                }
                case 3: {
                    return false;
                }
                case 10: {
                    return false;
                }
                case 17: {
                    return false;
                }
                case 18: {
                    return false;
                }
                case 29: {
                    return false;
                }
                case 8: {
                    return false;
                }
                case 22: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    protected void addCreateStatement(SybaseDdlScript script, String statement) {
        script.addCreateIndexStatement(statement);
    }

    protected void addDropStatement(SybaseDdlScript script, String statement) {
        script.addDropIndexStatement(statement);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void getModificationResult(SQLObject e, EStructuralFeature feature, Object oldValue, Object newValue, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script) {
        SybaseASEIndex index = (SybaseASEIndex)e;
        feature.getFeatureID();
        Table table = index.getTable();
        String owner = table.getSchema().getName();
        String tableName = table.getName();
        String oldIndexFullName = SQLUtil.quote((String)(String.valueOf(SQLDevToolsUtil.quoteWhenNecessary((String)index.getTable().getName(), (DatabaseIdentifier)((DatabaseIdentifier)this.getParameter()))) + "." + SQLDevToolsUtil.quoteWhenNecessary((String)index.getName(), (DatabaseIdentifier)((DatabaseIdentifier)this.getParameter()))), (String)"'");
        StringBuffer result = new StringBuffer(256);
        if (feature == SybaseasesqlmodelPackage.eINSTANCE.getCacheInfo_Cache()) {
            result.append(ASEDdlUtils.getCacheBindStatement(((SybaseASECache)newValue).getName(), (Index)index, qualifyNames, fullSyntax, (DatabaseIdentifier)this.getParameter()));
        } else if (feature == EcorePackage.eINSTANCE.getENamedElement_Name()) {
            result.append("sp_rename ");
            result.append(SQLUtil.quote((String)(String.valueOf(tableName) + "." + oldValue), (String)"'"));
            result.append(", ");
            if (quoteIdentifiers) {
                result.append(SQLDevToolsUtil.quoteWhenNecessary((String)String.valueOf(newValue), (DatabaseIdentifier)((DatabaseIdentifier)this.getParameter())));
            } else {
                result.append(SQLUtil.quote((String)String.valueOf(newValue), (String)"'"));
            }
            result.append(", ");
            result.append("'" + "INDEX".toLowerCase() + "'");
        } else if (feature == SQLConstraintsPackage.eINSTANCE.getIndex_Clustered()) {
            result.append("ALTER INDEX ");
            result.append(oldIndexFullName);
            result.append(", ");
            result.append(SQLUtil.quote((String)String.valueOf(newValue), (String)"'"));
        } else if (feature == SQLConstraintsPackage.eINSTANCE.getIndex_FillFactor()) {
            if (!(((Integer)newValue).intValue() == ((Integer)oldValue).intValue() || this.isEqualToServerWideDefault((Integer)oldValue) && this.isEqualToServerWideDefault((Integer)newValue))) {
                String value = (Integer)newValue > 0 ? newValue.toString() : "0";
                result.append(ASEDdlUtils.getChangeAttributeStatement(oldIndexFullName, SQLUtil.quote((String)"fillfactor", (String)"'"), value));
            }
        } else if (feature == SybaseasesqlmodelPackage.eINSTANCE.getSybaseASEIndex_MaxRowPerPage()) {
            if (!(((Integer)newValue).intValue() == ((Integer)oldValue).intValue() || this.isEqualToServerWideDefault((Integer)newValue) && this.isEqualToServerWideDefault((Integer)oldValue))) {
                String value = (Integer)newValue > 0 ? newValue.toString() : "0";
                result.append(ASEDdlUtils.getChangeAttributeStatement(oldIndexFullName, SQLUtil.quote((String)"max_rows_per_page", (String)"'"), value));
            }
        } else if (feature == SybaseasesqlmodelPackage.eINSTANCE.getSybaseASEIndex_ReversePageGap()) {
            if (!(((Integer)newValue).intValue() == ((Integer)oldValue).intValue() || this.isEqualToServerWideDefault((Integer)newValue) && this.isEqualToServerWideDefault((Integer)oldValue))) {
                String value = (Integer)newValue > 0 ? newValue.toString() : "0";
                result.append(ASEDdlUtils.getChangeAttributeStatement(oldIndexFullName, SQLUtil.quote((String)"reservepagegap", (String)"'"), value));
            }
        } else if (feature == SybaseasesqlmodelPackage.eINSTANCE.getSybaseASEIndex_Segment()) {
            String segName;
            if (oldValue == null && newValue != null) {
                segName = ((SybaseASESegment)newValue).getName();
            } else if (oldValue != null && newValue == null) {
                if (((SybaseASEBaseTable)table).getSegment().getName().equalsIgnoreCase(((SybaseASESegment)oldValue).getName())) return;
                segName = ((SybaseASEBaseTable)table).getSegment().getName();
            } else {
                if (oldValue == null || newValue == null) return;
                if (((SybaseASESegment)oldValue).getName().equalsIgnoreCase(((SybaseASESegment)newValue).getName())) return;
                segName = ((SybaseASESegment)newValue).getName();
            }
            result.append("EXEC sp_placeobject ");
            result.append(SQLUtil.quote((String)segName, (String)"'"));
            result.append(", ");
            result.append(SQLUtil.quote((String)(String.valueOf(owner) + "." + tableName + "." + index.getName()), (String)"'"));
        } else if (feature == SybaseasesqlmodelPackage.eINSTANCE.getSybaseASEIndex_CacheInfo()) {
            CacheInfo cfr_ignored_0 = (CacheInfo)newValue;
            String[] statments = ASEDdlUtils.getAllCacheStatement(index, qualifyNames, fullSyntax, (DatabaseIdentifier)this.getParameter());
            int i = 0;
            while (i < statments.length) {
                script.addAlterOtherStatements(statments[i]);
                ++i;
            }
        } else if (feature == SybaseasesqlmodelPackage.eINSTANCE.getCacheInfo_CacheStrategy()) {
            int newCacheStr = (Integer)newValue;
            int oldCacheStr = (Integer)oldValue;
            int changes = newCacheStr ^ oldCacheStr;
            int mru_status = changes & 2;
            int fetch_status = changes & 1;
            if (mru_status != 0) {
                if ((newCacheStr & mru_status) != 0) {
                    script.addAlterOtherStatements(ASEDdlUtils.getCacheStrategyStatement("mru", (Index)index, true, (DatabaseIdentifier)this.getParameter()));
                } else {
                    script.addAlterOtherStatements(ASEDdlUtils.getCacheStrategyStatement("mru", (Index)index, false, (DatabaseIdentifier)this.getParameter()));
                }
            }
            if (fetch_status != 0) {
                if ((newCacheStr & fetch_status) != 0) {
                    script.addAlterOtherStatements(ASEDdlUtils.getCacheStrategyStatement("prefetch", (Index)index, true, (DatabaseIdentifier)this.getParameter()));
                } else {
                    script.addAlterOtherStatements(ASEDdlUtils.getCacheStrategyStatement("prefetch", (Index)index, false, (DatabaseIdentifier)this.getParameter()));
                }
            }
        }
        if (result.toString().equals("")) return;
        script.addAlterOtherStatements(result.toString());
    }

    private boolean isEqualToServerWideDefault(Integer value) {
        int intValue = value;
        return intValue == 0 || intValue == -1;
    }
}

