/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ssh.internal.core;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.ssh.core.ISshConnection;
import org.eclipse.dltk.ssh.core.ISshFileHandle;
import org.eclipse.dltk.ssh.internal.core.Activator;
import org.eclipse.dltk.ssh.internal.core.ChannelPool;
import org.eclipse.dltk.ssh.internal.core.IOutputStreamCloseListener;
import org.eclipse.dltk.ssh.internal.core.SshFileHandle;

public class SshConnection
extends ChannelPool
implements ISshConnection {
    private long disabledTime = 0L;
    private static final int STREAM_BUFFER_SIZE = 32000;
    private static final int DEFAULT_RETRY_COUNT = 2;
    private static final long DEFAULT_ACQUIRE_TIMEOUT = 30000L;
    private static final long DEFAULT_INACTIVITY_TIMEOUT = 60000L;
    private static boolean DEBUG = false;

    public SshConnection(String userName, String hostName, int port) {
        super(userName, hostName, port, 60000L);
    }

    @Override
    public boolean connect() {
        try {
            ChannelSftp channel = this.acquireChannel("connect()");
            this.releaseChannel(channel);
            return true;
        }
        catch (JSchException e) {
            return false;
        }
    }

    private void performOperation(Operation op) {
        this.performOperation(op, 2);
    }

    private void performOperation(Operation op, int tryCount) {
        ChannelSftp channel = this.acquireChannel(op, 30000L);
        if (channel != null) {
            try {
                try {
                    if (DEBUG) {
                        this.log(" [do] " + String.valueOf(op));
                    }
                    op.perform(channel);
                    op.setFinished();
                }
                catch (SftpException e) {
                    if (e.id == 4 && e.getCause() instanceof JSchException) {
                        Activator.log(e);
                        this.destroyChannel(channel);
                        this.disconnect();
                        if (tryCount > 0) {
                            this.performOperation(op, tryCount - 1);
                        }
                    } else if (e.id != 2) {
                        if (e.id == 3) {
                            Activator.log("Permission denied to perform:" + op.toString());
                        } else {
                            Activator.log(e);
                        }
                    }
                    if (!op.isLongRunning() || !op.isFinished()) {
                        this.releaseChannel(channel);
                    }
                }
            }
            finally {
                if (!op.isLongRunning() || !op.isFinished()) {
                    this.releaseChannel(channel);
                }
            }
        }
    }

    @Override
    protected boolean canClose(Object context) {
        return context instanceof StreamOperation;
    }

    @Override
    protected long getLastActivity(Object context) {
        if (context instanceof StreamOperation) {
            return ((StreamOperation)context).getLastActivity();
        }
        return super.getLastActivity(context);
    }

    @Override
    public ISshFileHandle getHandle(IPath path) throws Exception {
        if (this.isDisabled()) {
            return null;
        }
        return new SshFileHandle(this, path, null);
    }

    @Override
    public boolean isDisabled() {
        return this.disabledTime > System.currentTimeMillis();
    }

    @Override
    public void setDisabled(int timeout) {
        this.disabledTime = System.currentTimeMillis() + (long)timeout;
    }

    SftpATTRS getAttrs(IPath path) {
        GetStatOperation op = new GetStatOperation(path);
        this.performOperation(op);
        if (op.isFinished()) {
            return op.getAttrs();
        }
        return null;
    }

    SftpATTRS getLAttrs(IPath path) {
        GetLStatOperation op = new GetLStatOperation(path);
        this.performOperation(op);
        if (op.isFinished()) {
            return op.getAttrs();
        }
        return null;
    }

    IPath getResolvedPath(IPath path) {
        ResolveLinkOperation op = new ResolveLinkOperation(path);
        this.performOperation(op);
        if (op.isFinished()) {
            return op.getResolvedPath();
        }
        return null;
    }

    Vector<ChannelSftp.LsEntry> list(IPath path) {
        ListFolderOperation op = new ListFolderOperation(path);
        this.performOperation(op);
        if (op.isFinished()) {
            return op.getVector();
        }
        return null;
    }

    void setLastModified(final IPath path, final long timestamp) {
        Operation op = new Operation(){

            @Override
            public void perform(ChannelSftp channel) throws SftpException {
                Date date = new Date(timestamp);
                System.out.println(date.toString());
                channel.setMtime(path.toString(), (int)(timestamp / 1000L));
            }

            public String toString() {
                return "setLastModified " + String.valueOf(path);
            }
        };
        this.performOperation(op);
    }

    void delete(final IPath path, final boolean dir) {
        Operation op = new Operation(){

            @Override
            public void perform(ChannelSftp channel) throws SftpException {
                if (!dir) {
                    channel.rm(path.toString());
                } else {
                    channel.rmdir(path.toString());
                }
            }

            public String toString() {
                return "delete " + String.valueOf(path);
            }
        };
        this.performOperation(op);
    }

    void mkdir(final IPath path) {
        Operation op = new Operation(){

            @Override
            public void perform(ChannelSftp channel) throws SftpException {
                channel.mkdir(path.toString());
            }

            public String toString() {
                return "mkdir " + String.valueOf(path);
            }
        };
        this.performOperation(op);
    }

    InputStream get(IPath path) {
        GetOperation op = new GetOperation(path);
        this.performOperation(op);
        if (op.isFinished()) {
            return op.getStream();
        }
        return null;
    }

    String readLink(IPath path) {
        ReadLinkOperation op = new ReadLinkOperation(path);
        this.performOperation(op);
        if (op.isFinished()) {
            return op.getLink();
        }
        return null;
    }

    OutputStream put(IPath path) {
        return this.put(path, null);
    }

    OutputStream put(IPath path, IOutputStreamCloseListener closeListener) {
        PutOperation op = new PutOperation(path, closeListener);
        this.performOperation(op);
        if (op.isFinished()) {
            return op.getStream();
        }
        return null;
    }

    void move(IPath source, IPath destination) throws CoreException {
        MoveOperation op = new MoveOperation(source, destination);
        this.performOperation(op);
        if (!op.isFinished()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.dltk.ssh", "Error moving " + String.valueOf(source) + " to " + String.valueOf(destination)));
        }
    }

    private static class GetLStatOperation
    extends GetStatOperation {
        public GetLStatOperation(IPath path) {
            super(path);
        }

        @Override
        public void perform(ChannelSftp channel) throws SftpException {
            this.attrs = channel.lstat(this.path.toString());
        }
    }

    private class GetOperation
    extends Operation
    implements StreamOperation {
        private IPath path;
        private GetOperationInputStream stream;

        public GetOperation(IPath path) {
            this.path = path;
        }

        @Override
        public boolean isLongRunning() {
            return true;
        }

        @Override
        public void perform(ChannelSftp channel) throws SftpException {
            this.stream = new GetOperationInputStream(channel.get(this.path.toString()), channel);
        }

        public String toString() {
            return "Get input stream for file:" + String.valueOf(this.path);
        }

        public InputStream getStream() {
            return this.stream;
        }

        @Override
        public boolean isActiveCall() {
            return this.stream != null && this.stream.activeCalls != 0;
        }

        @Override
        public long getLastActivity() {
            if (this.stream != null) {
                return this.stream.lastActivity;
            }
            return Long.MIN_VALUE;
        }
    }

    private class GetOperationInputStream
    extends BufferedInputStream {
        private final ChannelSftp channel;
        private int activeCalls;
        private long lastActivity;

        public GetOperationInputStream(InputStream in, ChannelSftp channel) {
            super(in, 32000);
            this.channel = channel;
            this.updateLastActivity();
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                SshConnection.this.releaseChannel(this.channel);
            }
        }

        private void updateLastActivity() {
            this.lastActivity = System.currentTimeMillis();
        }

        private void beginActivity() {
            ++this.activeCalls;
            this.updateLastActivity();
        }

        private void endActivity() {
            --this.activeCalls;
            this.updateLastActivity();
        }

        @Override
        public synchronized int read() throws IOException {
            this.beginActivity();
            try {
                int n = super.read();
                return n;
            }
            finally {
                this.endActivity();
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.beginActivity();
            try {
                int n = super.read(b);
                return n;
            }
            finally {
                this.endActivity();
            }
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            this.beginActivity();
            try {
                int n = super.read(b, off, len);
                return n;
            }
            finally {
                this.endActivity();
            }
        }
    }

    private static class GetStatOperation
    extends Operation {
        protected IPath path;
        protected SftpATTRS attrs;

        public GetStatOperation(IPath path) {
            this.path = path;
        }

        public String toString() {
            return "Get information for file:" + String.valueOf(this.path);
        }

        @Override
        public void perform(ChannelSftp channel) throws SftpException {
            this.attrs = channel.stat(this.path.toString());
        }

        public SftpATTRS getAttrs() {
            return this.attrs;
        }
    }

    private static class ListFolderOperation
    extends Operation {
        private IPath path;
        private Vector<ChannelSftp.LsEntry> v;

        public ListFolderOperation(IPath path) {
            this.path = path;
        }

        public String toString() {
            return "List folder:" + String.valueOf(this.path) + " for files";
        }

        @Override
        public void perform(ChannelSftp channel) throws SftpException {
            this.v = channel.ls(this.path.toString());
        }

        public Vector<ChannelSftp.LsEntry> getVector() {
            return this.v;
        }
    }

    static class MoveOperation
    extends Operation {
        final IPath source;
        final IPath destination;

        public MoveOperation(IPath source, IPath destination) {
            this.source = source;
            this.destination = destination;
        }

        @Override
        public void perform(ChannelSftp channel) throws SftpException {
            channel.rename(this.source.toString(), this.destination.toString());
        }
    }

    private static abstract class Operation {
        private boolean finished = false;

        private Operation() {
        }

        public boolean isLongRunning() {
            return false;
        }

        public abstract void perform(ChannelSftp var1) throws SftpException;

        public void setFinished() {
            this.finished = true;
        }

        public boolean isFinished() {
            return this.finished;
        }
    }

    private class PutOperation
    extends Operation
    implements StreamOperation {
        private final IPath path;
        private final IOutputStreamCloseListener closeListener;
        private PutOperationOutputStream stream;

        public PutOperation(IPath path, IOutputStreamCloseListener closeListener) {
            this.path = path;
            this.closeListener = closeListener;
        }

        public String toString() {
            return "Get output stream for file:" + String.valueOf(this.path);
        }

        @Override
        public boolean isLongRunning() {
            return true;
        }

        @Override
        public void perform(ChannelSftp channel) throws SftpException {
            OutputStream rawStream = channel.put(this.path.toString(), 0);
            this.stream = new PutOperationOutputStream(rawStream, channel, this.closeListener);
        }

        public OutputStream getStream() {
            return this.stream;
        }

        @Override
        public boolean isActiveCall() {
            return this.stream != null && this.stream.activeCalls != 0;
        }

        @Override
        public long getLastActivity() {
            if (this.stream != null) {
                return this.stream.lastActivity;
            }
            return Long.MIN_VALUE;
        }
    }

    private class PutOperationOutputStream
    extends BufferedOutputStream {
        private final ChannelSftp channel;
        private final IOutputStreamCloseListener closeListener;
        private int activeCalls;
        private long lastActivity;

        public PutOperationOutputStream(OutputStream out, ChannelSftp channel, IOutputStreamCloseListener closeListener) {
            super(out, 32000);
            this.channel = channel;
            this.closeListener = closeListener;
            this.updateActivity();
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
                if (this.closeListener != null) {
                    this.closeListener.streamClosed();
                }
            }
            finally {
                SshConnection.this.releaseChannel(this.channel);
            }
        }

        private void updateActivity() {
            this.lastActivity = System.currentTimeMillis();
        }

        private void beginActivity() {
            ++this.activeCalls;
            this.updateActivity();
        }

        private void endActivity() {
            --this.activeCalls;
            this.updateActivity();
        }

        @Override
        public synchronized void write(int b) throws IOException {
            this.beginActivity();
            try {
                super.write(b);
            }
            finally {
                this.endActivity();
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.beginActivity();
            try {
                super.write(b);
            }
            finally {
                this.endActivity();
            }
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) throws IOException {
            this.beginActivity();
            try {
                super.write(b, off, len);
            }
            finally {
                this.endActivity();
            }
        }
    }

    private static class ReadLinkOperation
    extends Operation {
        protected IPath path;
        protected String link;

        public ReadLinkOperation(IPath path) {
            this.path = path;
        }

        public String toString() {
            return "Get information for file:" + String.valueOf(this.path);
        }

        @Override
        public void perform(ChannelSftp channel) throws SftpException {
            if (this.path.segmentCount() == 0) {
                return;
            }
            String spath = this.path.toString();
            this.link = channel.readlink(spath);
            if (this.link != null && !this.link.equals(spath)) {
                SftpATTRS attrs;
                String curDir = channel.pwd();
                String parentPath = this.path.removeLastSegments(1).toString();
                if (!parentPath.equals(curDir)) {
                    channel.cd(parentPath);
                }
                if ((attrs = channel.stat(this.link)).isDir()) {
                    channel.cd(spath);
                    this.link = channel.pwd();
                }
            }
        }

        public String getLink() {
            return this.link;
        }
    }

    private static class ResolveLinkOperation
    extends Operation {
        private IPath path;
        private IPath resolvedPath;

        public ResolveLinkOperation(IPath path) {
            this.path = path;
        }

        public String toString() {
            return "Resolve link information for file:" + String.valueOf(this.path);
        }

        @Override
        public void perform(ChannelSftp channel) throws SftpException {
            SftpATTRS attrs = channel.stat(this.path.toString());
            boolean isRoot = this.path.segmentCount() == 0;
            Object linkTarget = null;
            String parentPath = this.path.removeLastSegments(1).toString();
            if (attrs.isLink() && !isRoot) {
                block9: {
                    try {
                        String fullPath = this.path.toString();
                        boolean readlinkDone = false;
                        try {
                            linkTarget = channel.readlink(fullPath);
                            readlinkDone = true;
                        }
                        catch (Throwable t) {
                            channel.cd(fullPath);
                            linkTarget = channel.pwd();
                        }
                        if (linkTarget != null && !((String)linkTarget).equals(fullPath)) {
                            String curdir;
                            if (readlinkDone && !parentPath.equals(curdir = channel.pwd())) {
                                channel.cd(parentPath);
                            }
                            SftpATTRS attrsTarget = channel.stat((String)linkTarget);
                            if (readlinkDone && attrsTarget.isDir()) {
                                channel.cd(fullPath);
                            }
                        } else {
                            linkTarget = null;
                        }
                    }
                    catch (Exception e) {
                        if (!(e instanceof SftpException) || ((SftpException)e).id != 2) break block9;
                        linkTarget = linkTarget == null ? ":dangling link" : ":dangling link:" + (String)linkTarget;
                    }
                }
                this.resolvedPath = new Path(linkTarget);
            }
        }

        public IPath getResolvedPath() {
            return this.resolvedPath;
        }
    }

    private static interface StreamOperation {
        public boolean isActiveCall();

        public long getLastActivity();
    }
}

