/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.language.fontname;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Weight implements Enumerator
{
    NORMAL(0, "NORMAL", "Regular"),
    THIN(1, "THIN", "Thin"),
    ULTRALIGHT(2, "ULTRALIGHT", "Ultra-Light"),
    LIGHT(3, "LIGHT", "Light"),
    SEMILIGHT(4, "SEMILIGHT", "Semi-Light"),
    BOOK(5, "BOOK", "Book"),
    MEDIUM(6, "MEDIUM", "Medium"),
    SEMIBOLD(7, "SEMIBOLD", "Semi-Bold"),
    BOLD(8, "BOLD", "Bold"),
    ULTRABOLD(9, "ULTRABOLD", "Ultra-Bold"),
    HEAVY(10, "HEAVY", "Heavy"),
    ULTRAHEAVY(11, "ULTRAHEAVY", "Ultra-Heavy");

    public static final int NORMAL_VALUE = 0;
    public static final int THIN_VALUE = 1;
    public static final int ULTRALIGHT_VALUE = 2;
    public static final int LIGHT_VALUE = 3;
    public static final int SEMILIGHT_VALUE = 4;
    public static final int BOOK_VALUE = 5;
    public static final int MEDIUM_VALUE = 6;
    public static final int SEMIBOLD_VALUE = 7;
    public static final int BOLD_VALUE = 8;
    public static final int ULTRABOLD_VALUE = 9;
    public static final int HEAVY_VALUE = 10;
    public static final int ULTRAHEAVY_VALUE = 11;
    private static final Weight[] VALUES_ARRAY;
    public static final List<Weight> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Weight[]{NORMAL, THIN, ULTRALIGHT, LIGHT, SEMILIGHT, BOOK, MEDIUM, SEMIBOLD, BOLD, ULTRABOLD, HEAVY, ULTRAHEAVY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Weight get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Weight result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Weight getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Weight result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Weight get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return THIN;
            }
            case 2: {
                return ULTRALIGHT;
            }
            case 3: {
                return LIGHT;
            }
            case 4: {
                return SEMILIGHT;
            }
            case 5: {
                return BOOK;
            }
            case 6: {
                return MEDIUM;
            }
            case 7: {
                return SEMIBOLD;
            }
            case 8: {
                return BOLD;
            }
            case 9: {
                return ULTRABOLD;
            }
            case 10: {
                return HEAVY;
            }
            case 11: {
                return ULTRAHEAVY;
            }
        }
        return null;
    }

    private Weight(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

