/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.layout.algorithms;

import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Point;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.layout.ILayoutAlgorithm;
import org.eclipse.gef.layout.LayoutContext;
import org.eclipse.gef.layout.LayoutProperties;

public class GridLayoutAlgorithm
implements ILayoutAlgorithm {
    private static final double PADDING_PERCENTAGE = 0.95;
    private static final int MIN_ENTITY_SIZE = 5;
    private double aspectRatio = 1.0;
    private int rowPadding = 0;
    private boolean resize = false;
    private int rows;
    private int cols;
    private int numChildren;
    private double colWidth;
    private double rowHeight;
    private double offsetX;
    private double offsetY;
    private double childrenHeight;
    private double childrenWidth;

    @Override
    public void applyLayout(LayoutContext context, boolean clean) {
        if (!clean) {
            return;
        }
        this.numChildren = context.getNodes().length;
        Rectangle bounds = LayoutProperties.getBounds(context.getGraph());
        this.calculateGrid(bounds);
        int index = 0;
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                if (i * this.cols + j < this.numChildren) {
                    Node node = context.getNodes()[index++];
                    if (this.resize && LayoutProperties.isResizable(node).booleanValue()) {
                        LayoutProperties.setSize(node, new Dimension(Math.max(this.childrenWidth, 5.0), Math.max(this.childrenHeight, 5.0)));
                    }
                    Dimension size = LayoutProperties.getSize(node);
                    double xmove = bounds.getX() + (double)j * this.colWidth + this.offsetX + size.width / 2.0;
                    double ymove = bounds.getY() + (double)i * this.rowHeight + this.offsetY + size.height / 2.0;
                    if (LayoutProperties.isMovable(node).booleanValue()) {
                        LayoutProperties.setLocation(node, new Point(xmove, ymove));
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    protected void calculateGrid(Rectangle bounds) {
        int[] result = this.calculateNumberOfRowsAndCols(this.numChildren, bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        this.cols = result[0];
        this.rows = result[1];
        this.colWidth = bounds.getWidth() / (double)this.cols;
        this.rowHeight = bounds.getHeight() / (double)this.rows;
        double[] nodeSize = this.calculateNodeSize(this.colWidth, this.rowHeight);
        this.childrenWidth = nodeSize[0];
        this.childrenHeight = nodeSize[1];
        this.offsetX = (this.colWidth - this.childrenWidth) / 2.0;
        this.offsetY = (this.rowHeight - this.childrenHeight) / 2.0;
    }

    protected int[] calculateNumberOfRowsAndCols(int numChildren, double boundX, double boundY, double boundWidth, double boundHeight) {
        if (this.aspectRatio == 1.0) {
            return this.calculateNumberOfRowsAndCols_square(numChildren, boundX, boundY, boundWidth, boundHeight);
        }
        return this.calculateNumberOfRowsAndCols_rectangular(numChildren);
    }

    /*
     * Unable to fully structure code
     */
    protected int[] calculateNumberOfRowsAndCols_square(int numChildren, double boundX, double boundY, double boundWidth, double boundHeight) {
        block6: {
            rows = Math.max(1, (int)Math.sqrt((double)numChildren * boundHeight / boundWidth));
            cols = Math.max(1, (int)Math.sqrt((double)numChildren * boundWidth / boundHeight));
            if (!(boundWidth <= boundHeight)) ** GOTO lbl19
            while (rows * cols > numChildren) {
                if (rows > 1) {
                    --rows;
                }
                if (rows * cols <= numChildren || cols <= 1) continue;
                --cols;
            }
            while (rows * cols < numChildren) {
                if (++rows * cols >= numChildren) continue;
                ++cols;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                if (cols > 1) {
                    --cols;
                }
                if (rows * cols <= numChildren || rows <= 1) continue;
                --rows;
lbl19:
                // 3 sources

                ** while (rows * cols > numChildren)
            }
lbl20:
            // 3 sources

            while (rows * cols < numChildren) {
                if (rows * ++cols >= numChildren) continue;
                ++rows;
            }
        }
        result = new int[]{cols, rows};
        return result;
    }

    protected int[] calculateNumberOfRowsAndCols_rectangular(int numChildren) {
        int rows = Math.max(1, (int)Math.ceil(Math.sqrt(numChildren)));
        int cols = Math.max(1, (int)Math.ceil(Math.sqrt(numChildren)));
        int[] result = new int[]{cols, rows};
        return result;
    }

    protected double[] calculateNodeSize(double colWidth, double rowHeight) {
        double childW = Math.max(5.0, 0.95 * colWidth);
        double childH = Math.max(5.0, 0.95 * (rowHeight - (double)this.rowPadding));
        double whRatio = colWidth / rowHeight;
        if (whRatio < this.aspectRatio) {
            childH = childW / this.aspectRatio;
        } else {
            childW = childH * this.aspectRatio;
        }
        double[] result = new double[]{childW, childH};
        return result;
    }

    public void setRowPadding(int rowPadding) {
        if (rowPadding >= 0) {
            this.rowPadding = rowPadding;
        }
    }

    public void setAspectRatio(double aspectRatio) {
        if (aspectRatio > 0.0) {
            this.aspectRatio = aspectRatio;
        }
    }

    public boolean isResizing() {
        return this.resize;
    }

    public void setResizing(boolean resizing) {
        this.resize = resizing;
    }
}

