/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.policies;

import javafx.scene.Node;
import org.eclipse.gef.common.adapt.IAdaptable;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.policies.IPolicy;

public abstract class AbstractPolicy
extends IAdaptable.Bound.Impl<IVisualPart<? extends Node>>
implements IPolicy {
    private ITransactionalOperation operation;
    private boolean initialized;

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not yet initialized!");
        }
    }

    private void checkUninitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
    }

    @Override
    public ITransactionalOperation commit() {
        this.checkInitialized();
        ITransactionalOperation commit = null;
        try {
            this.locallyExecuteOperation();
            commit = this.getOperation();
        }
        finally {
            this.initialized = false;
            this.operation = null;
        }
        if (commit != null && !commit.isNoOp()) {
            return commit;
        }
        return null;
    }

    protected abstract ITransactionalOperation createOperation();

    protected final ITransactionalOperation getOperation() {
        return this.operation;
    }

    @Override
    public void init() {
        this.checkUninitialized();
        this.initialized = true;
        this.operation = this.createOperation();
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void locallyExecuteOperation() {
        try {
            if (this.operation != null) {
                this.operation.execute(null, null);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalArgumentException(e);
        }
    }

    private void locallyUndoOperation() {
        try {
            if (this.operation != null) {
                this.operation.undo(null, null);
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void rollback() {
        this.initialized = false;
        try {
            this.locallyUndoOperation();
        }
        finally {
            this.operation = null;
        }
    }
}

