/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.jeview.properties;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.jeview.JEViewPlugin;
import org.eclipse.jdt.jeview.properties.GenericProperty;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ClasspathEntryProperties
implements IPropertySource {
    private static HashMap<String, Property> fgIdToProperty = new HashMap();
    private static LinkedHashMap<Class<?>, List<Property>> fgTypeToProperty = new LinkedHashMap();
    protected IClasspathEntry fEntry;

    static {
        ClasspathEntryProperties.addProperty(new Property("combineAccessRules"){

            @Override
            public Object compute(IClasspathEntry entry) {
                return entry.combineAccessRules();
            }
        });
        ClasspathEntryProperties.addProperty(new Property("getContentKind"){

            @Override
            public Object compute(IClasspathEntry entry) {
                return ClasspathEntryProperties.getContentKindString(entry.getContentKind());
            }
        });
        ClasspathEntryProperties.addProperty(new Property("getEntryKind"){

            @Override
            public Object compute(IClasspathEntry entry) {
                return ClasspathEntryProperties.getEntryKindString(entry.getEntryKind());
            }
        });
        ClasspathEntryProperties.addProperty(new Property("getOutputLocation"){

            @Override
            public Object compute(IClasspathEntry entry) {
                return entry.getOutputLocation();
            }
        });
        ClasspathEntryProperties.addProperty(new Property("getPath"){

            @Override
            public Object compute(IClasspathEntry entry) {
                return entry.getPath();
            }
        });
        ClasspathEntryProperties.addProperty(new Property("getSourceAttachmentPath"){

            @Override
            public Object compute(IClasspathEntry entry) {
                return entry.getSourceAttachmentPath();
            }
        });
        ClasspathEntryProperties.addProperty(new Property("getSourceAttachmentRootPath"){

            @Override
            public Object compute(IClasspathEntry entry) {
                return entry.getSourceAttachmentRootPath();
            }
        });
        ClasspathEntryProperties.addProperty(new Property("isExported"){

            @Override
            public Object compute(IClasspathEntry entry) {
                return entry.isExported();
            }
        });
    }

    private static void addProperty(Property property) {
        fgIdToProperty.put(property.getId(), property);
        List<Property> properties = fgTypeToProperty.get(property.getType());
        if (properties == null) {
            properties = new ArrayList<Property>();
            fgTypeToProperty.put(property.getType(), properties);
        }
        properties.add(property);
    }

    static String getContentKindString(int kind) {
        return kind + " (" + (switch (kind) {
            case 1 -> "K_SOURCE";
            case 2 -> "K_BINARY";
            default -> "UNKNOWN";
        }) + ")";
    }

    static String getEntryKindString(int kind) {
        return kind + " (" + (switch (kind) {
            case 5 -> "CPE_CONTAINER";
            case 1 -> "CPE_LIBRARY";
            case 2 -> "CPE_PROJECT";
            case 3 -> "CPE_SOURCE";
            case 4 -> "CPE_VARIABLE";
            default -> "UNKNOWN";
        }) + ")";
    }

    public ClasspathEntryProperties(IClasspathEntry entry) {
        this.fEntry = entry;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
        for (Map.Entry<Class<?>, List<Property>> entry : fgTypeToProperty.entrySet()) {
            if (!entry.getKey().isAssignableFrom(this.fEntry.getClass())) continue;
            for (Property property : entry.getValue()) {
                result.add(property.getDescriptor());
            }
        }
        return result.toArray(new IPropertyDescriptor[result.size()]);
    }

    public Object getPropertyValue(Object id) {
        Property property = fgIdToProperty.get(id);
        if (property == null) {
            return null;
        }
        try {
            return property.compute(this.fEntry);
        }
        catch (JavaModelException e) {
            if (e.isDoesNotExist()) {
                return "JavaModelException: " + e.getLocalizedMessage();
            }
            JEViewPlugin.log("error calculating property '" + property.getType().getSimpleName() + "#" + property.getName() + "'", e);
            return "Error: " + e.getLocalizedMessage();
        }
    }

    public void setPropertyValue(Object name, Object value) {
    }

    public Object getEditableValue() {
        return this;
    }

    public boolean isPropertySet(Object property) {
        return false;
    }

    public void resetPropertyValue(Object property) {
    }

    private static abstract class Property
    extends GenericProperty<IClasspathEntry> {
        public Property(String name) {
            super(IClasspathEntry.class, name);
        }
    }
}

