/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOrdinaryClassFile;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;

public class JUnitPropertyTester
extends PropertyTester {
    private static final String PROPERTY_IS_TEST = "isTest";
    private static final String PROPERTY_CAN_LAUNCH_AS_JUNIT_TEST = "canLaunchAsJUnit";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        IResource resource;
        IJavaElement element;
        if (!(receiver instanceof IAdaptable)) {
            throw new IllegalArgumentException("Element must be of type 'IAdaptable', is " + (receiver == null ? "null" : receiver.getClass().getName()));
        }
        if (receiver instanceof IJavaElement) {
            element = (IJavaElement)receiver;
        } else if (receiver instanceof IResource ? (element = JavaCore.create((IResource)((IResource)receiver))) == null : (element = (IJavaElement)((IAdaptable)receiver).getAdapter(IJavaElement.class)) == null && (element = JavaCore.create((IResource)(resource = (IResource)((IAdaptable)receiver).getAdapter(IResource.class)))) == null) {
            return false;
        }
        if (PROPERTY_IS_TEST.equals(property)) {
            return this.isJUnitTest(element);
        }
        if (PROPERTY_CAN_LAUNCH_AS_JUNIT_TEST.equals(property)) {
            return this.canLaunchAsJUnitTest(element);
        }
        throw new IllegalArgumentException("Unknown test property '" + property + "'");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean canLaunchAsJUnitTest(IJavaElement element) {
        try {
            switch (element.getElementType()) {
                case 2: 
                case 3: {
                    return true;
                }
                case 4: {
                    return ((IPackageFragment)element).hasChildren() || ((IPackageFragment)element).hasSubpackages();
                }
                case 5: {
                    IType[] types;
                    IType[] iTypeArray = types = ((ICompilationUnit)element).getAllTypes();
                    int n = types.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return false;
                        }
                        IType type = iTypeArray[n2];
                        if (this.isJUnitTest((IJavaElement)type)) {
                            return true;
                        }
                        ++n2;
                    }
                }
                case 6: 
                case 7: 
                case 9: {
                    return this.isJUnitTest(element);
                }
            }
            return false;
        }
        catch (JavaModelException e) {
            return false;
        }
    }

    private boolean isJUnitTest(IJavaElement element) {
        try {
            IType testType = null;
            if (element instanceof ICompilationUnit) {
                testType = ((ICompilationUnit)element).findPrimaryType();
            } else if (element instanceof IOrdinaryClassFile) {
                testType = ((IOrdinaryClassFile)element).getType();
            } else if (element instanceof IType) {
                testType = (IType)element;
            } else if (element instanceof IMember) {
                testType = ((IMember)element).getDeclaringType();
            }
            if (testType != null && testType.exists()) {
                return CoreTestSearchEngine.isTestOrTestSuite(testType);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }
}

