/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.cdo.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.atl.emftvm.cdo.impl.CDOInstanceOfIterable;
import org.eclipse.m2m.atl.emftvm.impl.ModelImpl;
import org.eclipse.m2m.atl.emftvm.util.LazyCollection;
import org.eclipse.m2m.atl.emftvm.util.LazyList;

public class CDOModelImpl
extends ModelImpl {
    public void setResource(Resource newResource) {
        if (newResource != null && !(newResource instanceof CDOResource)) {
            throw new IllegalArgumentException("Resource should be a CDOResource, but was: " + newResource);
        }
        super.setResource(newResource);
    }

    public LazyList<EObject> allInstancesOf(EClass type) {
        if (!this.allInstancesMap.containsKey(type)) {
            this.allInstancesMap.put(type, new InResourceList(new CDOInstanceOfIterable((CDOResource)this.getResource(), type), this.getResource()));
        }
        return (LazyList)this.allInstancesMap.get(type);
    }

    public EObject newElement(EClass type) {
        EObject instance = type.getEPackage().getEFactoryInstance().create(type);
        this.getResource().getContents().add((Object)instance);
        assert (instance.eResource() == this.getResource());
        return instance;
    }

    public void deleteElement(EObject element) {
        assert (this.getResource() == element.eResource());
        EList resContents = this.getResource().getContents();
        if (!resContents.remove((Object)element)) {
            throw new IllegalArgumentException(String.format("Element %s not contained as a root element in this model", element));
        }
        for (EObject child : new ArrayList(element.eContents())) {
            assert (child.eResource() == null);
            resContents.add((Object)child);
        }
    }

    public static class InResourceList
    extends LazyList.NonCachingList<EObject> {
        protected final Resource resource;

        public InResourceList(Iterable<EObject> dataSource, Resource resource) {
            super(dataSource);
            this.resource = resource;
        }

        public Iterator<EObject> iterator() {
            if (this.dataSource == null) {
                return this.cache.iterator();
            }
            return new InResourceIterator();
        }

        public class InResourceIterator
        extends LazyCollection.WrappedIterator {
            protected EObject next;
            protected boolean nextSet;

            public InResourceIterator() {
                super((LazyCollection)InResourceList.this);
                this.next = null;
                this.nextSet = false;
            }

            public boolean hasNext() {
                if (!this.nextSet && this.inner.hasNext()) {
                    this.next = (EObject)this.inner.next();
                    this.nextSet = true;
                }
                while (this.inner.hasNext() && (this.next == null || this.next.eResource() != InResourceList.this.resource)) {
                    this.next = (EObject)this.inner.next();
                }
                return this.nextSet && this.next != null && this.next.eResource() == InResourceList.this.resource;
            }

            public EObject next() {
                if (!this.nextSet) {
                    this.next = (EObject)this.inner.next();
                } else {
                    this.nextSet = false;
                }
                while (this.next.eResource() != InResourceList.this.resource) {
                    this.next = (EObject)this.inner.next();
                }
                assert (!this.nextSet && this.next.eResource() == InResourceList.this.resource);
                return this.next;
            }
        }
    }
}

