/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.m2m.atl.engine.emfvm.lib.ASMModule;
import org.eclipse.m2m.atl.engine.emfvm.lib.ExecEnv;
import org.eclipse.m2m.atl.engine.emfvm.lib.Operation;

public abstract class AbstractStackFrame {
    protected ExecEnv execEnv;
    protected AbstractStackFrame caller;
    protected Operation operation;
    protected Object[] localVars;
    private ASMModule asmModule;

    public AbstractStackFrame(ExecEnv execEnv, ASMModule asmModule, Operation operation) {
        this(null, operation);
        this.execEnv = execEnv;
        this.asmModule = asmModule;
        this.localVars[0] = asmModule;
    }

    protected AbstractStackFrame(AbstractStackFrame caller, Operation frameOperation) {
        this.caller = caller;
        this.operation = frameOperation;
        if (caller != null) {
            this.execEnv = caller.execEnv;
            this.asmModule = caller.asmModule;
        }
        this.localVars = new Object[frameOperation.getMaxLocals()];
    }

    protected AbstractStackFrame(ExecEnv execEnv) {
        this.execEnv = execEnv;
    }

    public abstract AbstractStackFrame newFrame(Operation var1);

    public ASMModule getAsmModule() {
        return this.asmModule;
    }

    public Object[] getLocalVars() {
        return this.localVars;
    }

    public void setLocalVars(Object[] localVars) {
        this.localVars = localVars;
    }

    public ExecEnv getExecEnv() {
        return this.execEnv;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public AbstractStackFrame getCaller() {
        return this.caller;
    }

    public Map<String, Object> getLocalVariables() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        int i = 0;
        while (i < this.operation.getMaxLocals()) {
            if (this.localVars[i] != null) {
                ret.put(Integer.valueOf(i).toString(), this.localVars[i]);
            }
            ++i;
        }
        return ret;
    }

    public AbstractStackFrame enter() {
        this.execEnv.enterTools(this);
        return this;
    }

    public void leave() {
        this.execEnv.leaveTools(this);
    }

    public StackSequence getStack() {
        StackSequence res = new StackSequence();
        AbstractStackFrame tmp = this;
        while (tmp != null) {
            res.add(tmp);
            tmp = tmp.caller;
        }
        Collections.reverse(res);
        return res;
    }

    public String getSourceLocation() {
        return this.getOperation().resolveLineNumber(this.getLocation());
    }

    public String getOpName() {
        return this.operation.getName();
    }

    public abstract int getLocation();

    public class StackSequence
    extends ArrayList<AbstractStackFrame> {
        private static final long serialVersionUID = 1L;

        public AbstractStackFrame at(int index) {
            return (AbstractStackFrame)this.get(index - 1);
        }
    }
}

