/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.navigator;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.builds.core.IBuildModel;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.internal.core.BuildModel;
import org.eclipse.mylyn.commons.repositories.core.RepositoryCategory;
import org.eclipse.mylyn.internal.builds.ui.BuildsUiInternal;
import org.eclipse.mylyn.internal.builds.ui.view.BuildModelContentAdapter;

public class BuildNavigatorContentProvider
implements ITreeContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private BuildModel model;
    private Viewer viewer;
    private final Adapter modelListener = new BuildModelContentAdapter(){

        @Override
        public void doNotifyChanged(Notification msg) {
            int featureId;
            if (msg.getNotifier() instanceof IBuildModel && (featureId = msg.getFeatureID(IBuildModel.class)) != 0) {
                return;
            }
            if (msg.getNotifier() instanceof IBuildServer && ((featureId = msg.getFeatureID(IBuildServer.class)) == 2 || featureId == 4)) {
                return;
            }
            if (BuildNavigatorContentProvider.this.viewer != null && !BuildNavigatorContentProvider.this.viewer.getControl().isDisposed()) {
                BuildNavigatorContentProvider.this.viewer.refresh();
            }
        }

        @Override
        protected boolean observing(Notifier notifier) {
            return notifier instanceof IBuildServer || notifier instanceof IBuildModel;
        }
    };

    public void dispose() {
        if (this.model != null) {
            this.model.eAdapters().remove((Object)this.modelListener);
        }
    }

    public Object[] getChildren(Object parentElement) {
        RepositoryCategory category;
        if (parentElement instanceof RepositoryCategory && ("org.eclipse.mylyn.category.build".equals((category = (RepositoryCategory)parentElement).getId()) || "org.eclipse.mylyn.category.all".equals(category.getId()))) {
            return this.model.getServers().toArray();
        }
        return EMPTY_ARRAY;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (this.model != null) {
            this.model.eAdapters().remove((Object)this.modelListener);
        }
        this.model = newInput instanceof BuildModel ? (BuildModel)newInput : BuildsUiInternal.getModel();
        this.model.eAdapters().add((Object)this.modelListener);
    }
}

