/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.syntax;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.Segment;

public class Segments<T extends Segment<?>> {
    private List<T> list;

    public void add(T t) {
        if (this.list == null) {
            this.list = new ArrayList<T>();
        } else if (this.list.size() > 0) {
            Segment previousSegment = (Segment)this.list.get(this.list.size() - 1);
            int tOffset = ((Segment)t).getOffset();
            if (previousSegment.getOffset() > tOffset) {
                throw new IllegalArgumentException();
            }
            if (previousSegment.getEndOffset() > tOffset) {
                int newLength = tOffset - previousSegment.getOffset();
                previousSegment.setLength(newLength);
            }
        }
        this.list.add(t);
    }

    public void remove(T t) {
        this.list.remove(t);
    }

    public List<T> asList() {
        if (this.list == null) {
            return Collections.emptyList();
        }
        return this.list;
    }

    public boolean isEmpty() {
        return this.list == null || this.list.isEmpty();
    }

    public int size() {
        return this.list == null ? 0 : this.list.size();
    }
}

