/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ui.chat;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.function.Consumer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.net4j.util.internal.ui.bundle.OM;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.chat.ChatMessage;
import org.eclipse.net4j.util.ui.chat.ChatRenderer;
import org.eclipse.net4j.util.ui.widgets.EntryControlAdvisor;
import org.eclipse.net4j.util.ui.widgets.EntryField;
import org.eclipse.net4j.util.ui.widgets.ImageButton;
import org.eclipse.net4j.util.ui.widgets.SafeBrowser;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public final class ChatComposite
extends Composite {
    private static final ZoneId ZONE_ID = TimeZone.getDefault().toZoneId();
    private static final String SEND_MESSAGE = OM.BUNDLE.getTranslationSupport().getString("chat.send.message");
    private final Config config;
    private final SafeBrowser messageBrowser;
    private final EntryField entryField;
    private final Control sendButton;

    public ChatComposite(Composite parent, int style, Config config) {
        super(parent, style);
        this.config = new Config(config);
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, LayoutConstants.getSpacing().y).create());
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.messageBrowser = this.createMessageBrowser();
        this.messageBrowser.setLayoutData(GridDataFactory.fillDefaults().span(2, 1).grab(true, true).create());
        if (config.getSendHandler() != null) {
            this.entryField = this.createEntryField();
            this.entryField.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).create());
            this.sendButton = this.createSendButton();
            this.sendButton.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 0x1000008).indent(LayoutConstants.getSpacing().x, 0).exclude(true).create());
        } else {
            this.entryField = null;
            this.sendButton = null;
        }
        this.refreshMessageBrowser();
    }

    private boolean isMessageBrowserScrolledToBottom() {
        if (this.messageBrowser.isDocumentAvailable()) {
            int scrollHeight;
            int height;
            int scrollTop = this.messageBrowser.evaluateInt("return document.body.scrollTop;");
            return scrollTop + (height = this.messageBrowser.getSize().y) == (scrollHeight = this.messageBrowser.evaluateInt("return document.body.scrollHeight;"));
        }
        return false;
    }

    public String getOwnUserID() {
        return this.config.getOwnUserID();
    }

    public void setOwnUserID(String ownUserID) {
        this.config.setOwnUserID(ownUserID);
    }

    public Browser getMessageBrowser() {
        return this.messageBrowser;
    }

    public EntryField getEntryField() {
        return this.entryField;
    }

    public Control getSendButton() {
        return this.sendButton;
    }

    public boolean setFocus() {
        return this.entryField == null ? this.messageBrowser.setFocus() : this.entryField.setFocus();
    }

    public void refreshMessageBrowser() {
        List<ChatRenderer.Renderable> renderables = this.getRenderables();
        ChatRenderer renderer = this.config.getChatRenderer();
        String html = renderer.renderHTML(renderables, null);
        this.messageBrowser.setText(html, true);
    }

    public boolean revealLastMessage() {
        return this.messageBrowser.executeSafe("window.scrollTo(0, document.body.scrollHeight)");
    }

    private SafeBrowser createMessageBrowser() {
        SafeBrowser browser = UIUtil.createBrowser(this);
        browser.addLocationListener(LocationListener.changedAdapter(e -> {
            boolean bl = this.revealLastMessage();
        }));
        return browser;
    }

    private EntryField createEntryField() {
        final Display display = this.getDisplay();
        Color entryBackgroundColor = this.config.getEntryBackgroundColor();
        EntryControlAdvisor entryControlAdvisor = this.config.getEntryControlAdvisor();
        EntryControlAdvisor.ControlConfig controlConfig = new EntryControlAdvisor.ControlConfig();
        controlConfig.setOkHandler(control -> this.sendEntry());
        final boolean[] lastScrolledToBottom = new boolean[]{this.isMessageBrowserScrolledToBottom()};
        display.timerExec(500, new Runnable(){

            @Override
            public void run() {
                if (!ChatComposite.this.messageBrowser.isDisposed()) {
                    lastScrolledToBottom[0] = ChatComposite.this.isMessageBrowserScrolledToBottom();
                    display.timerExec(500, (Runnable)this);
                }
            }
        });
        EntryField.FieldConfig fieldConfig = new EntryField.FieldConfig();
        fieldConfig.setEntryBackground(entryBackgroundColor);
        fieldConfig.setEntryControlAdvisor(entryControlAdvisor);
        fieldConfig.setEntryControlConfig(controlConfig);
        fieldConfig.setEmptyHint("Type a message");
        fieldConfig.setPreviewProvider(this.config.getChatRenderer());
        fieldConfig.setInitialPreviewMode(false);
        fieldConfig.setDirtyHandler(entryField -> this.dirtyStateChanged());
        EntryField entryField2 = new EntryField(this, 0, fieldConfig);
        int[] lastEntryFieldHeight = new int[]{-1};
        entryField2.addControlListener(ControlListener.controlResizedAdapter(e -> {
            int height = entryField.getSize().y;
            if (height != lastEntryFieldHeight[0]) {
                if (lastScrolledToBottom[0]) {
                    this.revealLastMessage();
                }
                nArray[0] = height;
            }
        }));
        return entryField2;
    }

    private Control createSendButton() {
        ImageButton button = new ImageButton(this, OM.getImage("icons/send_message_hover.png"), OM.getImage("icons/send_message.png"));
        button.setToolTipText(SEND_MESSAGE);
        button.setSelectionMode(ImageButton.SelectionMode.MouseDown);
        button.setSelectionRunnable(this::sendEntry);
        button.setVisible(false);
        return button;
    }

    private void dirtyStateChanged() {
        boolean dirty = this.entryField.isDirty();
        this.sendButton.setVisible(dirty);
        GridData gridData = (GridData)this.sendButton.getLayoutData();
        gridData.exclude = !dirty;
        this.layout(true);
    }

    private void sendEntry() {
        String entry = this.entryField.getEntry().trim();
        if (entry.length() != 0) {
            this.config.getSendHandler().accept(entry);
            this.entryField.setPreviewMode(false);
            this.entryField.setEntry(null);
        }
    }

    private List<ChatRenderer.Renderable> getRenderables() {
        ChatMessage.Provider messageProvider = this.config.getMessageProvider();
        Object[] messages = messageProvider.getMessages();
        Arrays.sort(messages);
        ArrayList<ChatRenderer.Renderable> renderables = new ArrayList<ChatRenderer.Renderable>();
        ChatRenderer.DateLine lastDateLine = null;
        ChatRenderer.BubbleGroup lastBubbleGroup = null;
        Object[] objectArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            Object message = objectArray[n2];
            LocalDateTime creationTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(message.getCreationTime()), ZONE_ID);
            LocalDate date = creationTime.toLocalDate();
            if (lastDateLine == null || lastDateLine.getDate().isBefore(date)) {
                lastDateLine = new ChatRenderer.DateLine(date);
                renderables.add(lastDateLine);
                lastBubbleGroup = null;
            }
            ChatMessage.Author author = message.getAuthor();
            String ownUserID = this.config.getOwnUserID();
            boolean own = Objects.equals(author.getUserID(), ownUserID);
            LocalTime time = creationTime.toLocalTime();
            if (lastBubbleGroup == null || !lastBubbleGroup.getAuthor().equals(author) || time.minusMinutes(5L).isAfter(lastBubbleGroup.getLastBubbleTime())) {
                lastBubbleGroup = new ChatRenderer.BubbleGroup(author, own);
                renderables.add(lastBubbleGroup);
            }
            lastBubbleGroup.addBubble(time, message.getContent());
            ++n2;
        }
        return renderables;
    }

    public static final class Config {
        private String ownUserID;
        private ChatMessage.Provider messageProvider;
        private ChatRenderer chatRenderer;
        private Color entryBackgroundColor;
        private EntryControlAdvisor entryControlAdvisor;
        private Consumer<String> sendHandler;

        public Config(Config source) {
            this.ownUserID = source.ownUserID;
            this.messageProvider = source.messageProvider;
            this.chatRenderer = source.chatRenderer;
            this.entryBackgroundColor = source.entryBackgroundColor;
            this.entryControlAdvisor = source.entryControlAdvisor;
            this.sendHandler = source.sendHandler;
        }

        public Config() {
        }

        public String getOwnUserID() {
            return this.ownUserID;
        }

        public void setOwnUserID(String ownUserID) {
            this.ownUserID = ownUserID;
        }

        public ChatMessage.Provider getMessageProvider() {
            return this.messageProvider;
        }

        public void setMessageProvider(ChatMessage.Provider messageProvider) {
            this.messageProvider = messageProvider;
        }

        public ChatRenderer getChatRenderer() {
            return this.chatRenderer;
        }

        public void setChatRenderer(ChatRenderer chatRenderer) {
            this.chatRenderer = chatRenderer;
        }

        public Color getEntryBackgroundColor() {
            return this.entryBackgroundColor;
        }

        public void setEntryBackgroundColor(Color entryBackgroundColor) {
            this.entryBackgroundColor = entryBackgroundColor;
        }

        public EntryControlAdvisor getEntryControlAdvisor() {
            return this.entryControlAdvisor;
        }

        public void setEntryControlAdvisor(EntryControlAdvisor entryControlAdvisor) {
            this.entryControlAdvisor = entryControlAdvisor;
        }

        public Consumer<String> getSendHandler() {
            return this.sendHandler;
        }

        public void setSendHandler(Consumer<String> sendHandler) {
            this.sendHandler = sendHandler;
        }
    }
}

