/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.security;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.net4j.util.security.ICrypter;

public class MessageDigestCrypter
implements ICrypter {
    private final MessageDigest messageDigest;
    private final byte[] salt;

    public MessageDigestCrypter(MessageDigest messageDigest, String salt) {
        this.messageDigest = messageDigest;
        this.salt = salt == null ? null : salt.getBytes(StandardCharsets.UTF_8);
    }

    public MessageDigestCrypter(String algorithm, String salt) throws NoSuchAlgorithmException {
        this(MessageDigest.getInstance(algorithm), salt);
    }

    @Override
    public String getType() {
        return this.messageDigest.getAlgorithm();
    }

    @Override
    public String getParams() {
        return this.salt == null ? null : new String(this.salt, StandardCharsets.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] apply(byte[] data) {
        MessageDigest messageDigest = this.messageDigest;
        synchronized (messageDigest) {
            if (this.salt != null) {
                this.messageDigest.update(this.salt);
            }
            return this.messageDigest.digest(data);
        }
    }
}

