/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.deltaPropagation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.ocl.ecore.CallExp;
import org.eclipse.ocl.ecore.EcoreEnvironmentFactory;
import org.eclipse.ocl.ecore.IfExp;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.LoopExp;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.impactanalyzer.PartialEvaluator;
import org.eclipse.ocl.examples.impactanalyzer.ValueNotFoundException;
import org.eclipse.ocl.examples.impactanalyzer.deltaPropagation.DeltaPropagationStrategy;
import org.eclipse.ocl.examples.impactanalyzer.deltaPropagation.IdentityPropagationStrategy;
import org.eclipse.ocl.examples.impactanalyzer.deltaPropagation.IteratorSourcePropagationStrategy;
import org.eclipse.ocl.examples.impactanalyzer.deltaPropagation.OperationBodyPropagationStrategy;
import org.eclipse.ocl.examples.impactanalyzer.deltaPropagation.PartialEcoreEnvironmentFactory;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.Tuple;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;

public class PartialEvaluatorImpl
implements PartialEvaluator {
    private final OCL ocl;
    private final OCL.Helper helper;
    private PartialEcoreEnvironmentFactory factory;

    public PartialEvaluatorImpl(OCLFactory oclFactory) {
        this(new PartialEcoreEnvironmentFactory(), oclFactory);
    }

    public PartialEvaluatorImpl(OCLFactory oclFactory, OppositeEndFinder oppositeEndFinder) {
        this.factory = new PartialEcoreEnvironmentFactory(oppositeEndFinder);
        this.ocl = oclFactory.createOCL((EcoreEnvironmentFactory)this.factory);
        this.helper = this.ocl.createOCLHelper();
    }

    protected PartialEvaluatorImpl(PartialEcoreEnvironmentFactory factory, OCLFactory oclFactory) {
        this.factory = factory;
        this.ocl = oclFactory.createOCL((EcoreEnvironmentFactory)factory);
        this.helper = this.ocl.createOCLHelper();
    }

    public PartialEvaluatorImpl(Notification atPre, OCLFactory oclFactory) {
        this(new PartialEcoreEnvironmentFactory(atPre), oclFactory);
    }

    public PartialEvaluatorImpl(Notification atPre, OppositeEndFinder oppositeEndFinder, OCLFactory oclFactory) {
        this(new PartialEcoreEnvironmentFactory(atPre, oppositeEndFinder), oclFactory);
    }

    @Override
    public OCL getOcl() {
        return this.ocl;
    }

    @Override
    public OCL.Helper getHelper() {
        return this.helper;
    }

    @Override
    public Object evaluate(Object context, CallExp e, Object valueOfSourceExpression) {
        this.factory.setExpressionValue((org.eclipse.ocl.ecore.OCLExpression)e.getSource(), valueOfSourceExpression);
        return this.ocl.evaluate(context, (OCLExpression)e);
    }

    @Override
    public Object evaluate(Object context, org.eclipse.ocl.ecore.OCLExpression e) {
        return this.ocl.evaluate(context, (OCLExpression)e);
    }

    private EOperation getOperationFromBody(org.eclipse.ocl.ecore.OCLExpression bodyExpression, OperationBodyToCallMapper mapper) {
        EOperation result = null;
        Set<OperationCallExp> calls = mapper.getCallsOf(bodyExpression);
        if (!calls.isEmpty()) {
            result = (EOperation)calls.iterator().next().getReferredOperation();
        }
        return result;
    }

    public boolean hasNoEffectOnOverallExpression(org.eclipse.ocl.ecore.OCLExpression e, Object oldValue, Object newValue, OperationBodyToCallMapper mapper) {
        boolean result;
        block8: {
            boolean oldEqualsNew;
            boolean bl = oldEqualsNew = oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue);
            if (oldEqualsNew) {
                result = true;
            } else {
                try {
                    if (e.eContainer() != null && e.eContainer() instanceof CallExp && ((CallExp)e.eContainer()).getSource() == e) {
                        CallExp callExp = (CallExp)e.eContainer();
                        Object oldCallExpValue = this.evaluate(null, callExp, oldValue);
                        Object newCallExpValue = this.evaluate(null, callExp, newValue);
                        result = this.hasNoEffectOnOverallExpression((org.eclipse.ocl.ecore.OCLExpression)callExp, oldCallExpValue, newCallExpValue, mapper);
                        break block8;
                    }
                    EOperation op = this.getOperationFromBody(e, mapper);
                    if (op != null) {
                        result = true;
                        for (OperationCallExp call : mapper.getCallsOf(e)) {
                            result = this.hasNoEffectOnOverallExpression((org.eclipse.ocl.ecore.OCLExpression)call, oldValue, newValue, mapper);
                            if (result) {
                                continue;
                            }
                            break block8;
                        }
                        break block8;
                    }
                    Collection<Object> delta = this.symmetricDifference(oldValue, newValue);
                    result = this.transitivelyPropagateDelta(e, delta, mapper).isEmpty();
                }
                catch (ValueNotFoundException ex) {
                    result = false;
                }
            }
        }
        return result;
    }

    private Collection<Object> symmetricDifference(Object oldSourceValue, Object newSourceValue) {
        Set<Object> oldSourceValueAsCollection = oldSourceValue instanceof Collection ? (Set<Object>)oldSourceValue : Collections.singleton(oldSourceValue);
        Set<Object> newSourceValueAsCollection = newSourceValue instanceof Collection ? (Set<Object>)newSourceValue : Collections.singleton(newSourceValue);
        Collection<Object> result = oldSourceValueAsCollection instanceof List || newSourceValueAsCollection instanceof List ? this.computeOrderedSymmetricDifference(oldSourceValueAsCollection, newSourceValueAsCollection) : this.computeUnorderedSymmetricDifference(oldSourceValueAsCollection, newSourceValueAsCollection);
        return result;
    }

    private Set<Object> computeUnorderedSymmetricDifference(Collection<Object> oldSourceValueAsCollection, Collection<Object> newSourceValueAsCollection) {
        HashSet<Object> result = new HashSet<Object>();
        result.addAll(oldSourceValueAsCollection);
        result.removeAll(newSourceValueAsCollection);
        HashSet<Object> newSourceValueMinusOldSourceValue = new HashSet<Object>();
        newSourceValueMinusOldSourceValue.addAll(newSourceValueAsCollection);
        newSourceValueMinusOldSourceValue.removeAll(oldSourceValueAsCollection);
        result.addAll(newSourceValueMinusOldSourceValue);
        return result;
    }

    private List<Object> computeOrderedSymmetricDifference(Collection<Object> oldSourceValueAsCollection, Collection<Object> newSourceValueAsCollection) {
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator<Object> oldIt = oldSourceValueAsCollection.iterator();
        Iterator<Object> newIt = newSourceValueAsCollection.iterator();
        while (oldIt.hasNext() || newIt.hasNext()) {
            Object old = null;
            boolean oldItHadNext = oldIt.hasNext();
            if (oldIt.hasNext()) {
                old = oldIt.next();
            }
            Object nw = null;
            boolean newItHadNext = newIt.hasNext();
            if (newIt.hasNext()) {
                nw = newIt.next();
            }
            if (oldItHadNext && newItHadNext) {
                if (old == nw) continue;
                result.add(old);
                result.add(nw);
                continue;
            }
            if (oldItHadNext) {
                result.add(old);
                continue;
            }
            result.add(nw);
        }
        return result;
    }

    private DeltaPropagationStrategy getDeltaPropagationStrategy(org.eclipse.ocl.ecore.OCLExpression e, OperationBodyToCallMapper mapper) {
        DeltaPropagationStrategy result = null;
        if (e.eContainer() != null && e.eContainer() instanceof CallExp && ((CallExp)e.eContainer()).getSource() == e) {
            CallExp callExp = (CallExp)e.eContainer();
            if (callExp instanceof IteratorExp) {
                IteratorExp loopExp = (IteratorExp)callExp;
                switch (OCLStandardLibraryUtil.getOperationCode((String)loopExp.getName())) {
                    case 206: 
                    case 209: 
                    case 210: {
                        result = new IteratorSourcePropagationStrategy(loopExp, this);
                    }
                }
            } else if (callExp instanceof OperationCallExp) {
                switch (OCLStandardLibraryUtil.getOperationCode((String)((EOperation)((OperationCallExp)callExp).getReferredOperation()).getName())) {
                    case 2: 
                    case 149: 
                    case 150: 
                    case 151: 
                    case 152: 
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 161: 
                    case 163: 
                    case 165: {
                        result = new IdentityPropagationStrategy((org.eclipse.ocl.ecore.OCLExpression)callExp);
                    }
                }
            }
        } else if (e.eContainer() != null && e.eContainer() instanceof OperationCallExp && ((OperationCallExp)e.eContainer()).getArgument().contains((Object)e)) {
            OperationCallExp operationCall = (OperationCallExp)e.eContainer();
            if (e == operationCall.getArgument().get(operationCall.getArgument().size() - 1)) {
                switch (OCLStandardLibraryUtil.getOperationCode((String)((EOperation)operationCall.getReferredOperation()).getName())) {
                    case 155: 
                    case 156: 
                    case 157: 
                    case 161: 
                    case 163: 
                    case 165: {
                        result = new IdentityPropagationStrategy((org.eclipse.ocl.ecore.OCLExpression)operationCall);
                    }
                }
            }
        } else if (e.eContainer() != null && e.eContainer() instanceof IfExp && (((IfExp)e.eContainer()).getThenExpression() == e || ((IfExp)e.eContainer()).getElseExpression() == e)) {
            result = new IdentityPropagationStrategy((org.eclipse.ocl.ecore.OCLExpression)((IfExp)e.eContainer()));
        } else {
            LoopExp loopExp;
            Set<OperationCallExp> callsOfOperationBody = mapper.getCallsOf(e);
            if (!callsOfOperationBody.isEmpty()) {
                result = new OperationBodyPropagationStrategy(mapper);
            } else if (e.eContainer() != null && e.eContainer() instanceof IteratorExp && ((IteratorExp)e.eContainer()).getBody() == e && OCLStandardLibraryUtil.getOperationCode((String)(loopExp = (LoopExp)e.eContainer()).getName()) == 206) {
                result = new IdentityPropagationStrategy((org.eclipse.ocl.ecore.OCLExpression)loopExp);
            }
        }
        return result;
    }

    public Collection<Tuple.Pair<org.eclipse.ocl.ecore.OCLExpression, Collection<Object>>> transitivelyPropagateDelta(org.eclipse.ocl.ecore.OCLExpression e, Collection<Object> deltaForEValue, OperationBodyToCallMapper mapper) {
        return this.transitivelyPropagateDelta(e, deltaForEValue, mapper, new HashMap<org.eclipse.ocl.ecore.OCLExpression, Set<Collection<Object>>>());
    }

    private Collection<Tuple.Pair<org.eclipse.ocl.ecore.OCLExpression, Collection<Object>>> transitivelyPropagateDelta(org.eclipse.ocl.ecore.OCLExpression e, Collection<Object> deltaForEValue, OperationBodyToCallMapper mapper, Map<org.eclipse.ocl.ecore.OCLExpression, Set<Collection<Object>>> cache) {
        Collection<Tuple.Pair<org.eclipse.ocl.ecore.OCLExpression, Collection<Object>>> result;
        Set<Collection<Object>> cacheEntry = cache.get(e);
        if (cacheEntry != null && cacheEntry.contains(deltaForEValue)) {
            result = PartialEvaluatorImpl.getResultCollectionFromSingleDelta(e, deltaForEValue);
        } else {
            if (cacheEntry == null) {
                cacheEntry = new HashSet<Collection<Object>>();
                cache.put(e, cacheEntry);
            }
            cacheEntry.add(deltaForEValue);
            DeltaPropagationStrategy propagationStrategy = this.getDeltaPropagationStrategy(e, mapper);
            if (propagationStrategy == null) {
                result = PartialEvaluatorImpl.getResultCollectionFromSingleDelta(e, deltaForEValue);
            } else {
                Collection<Tuple.Pair<org.eclipse.ocl.ecore.OCLExpression, Collection<Object>>> propagated = null;
                try {
                    propagated = propagationStrategy.mapDelta(e, deltaForEValue);
                }
                catch (ValueNotFoundException valueNotFoundException) {
                    // empty catch block
                }
                if (propagated == null) {
                    result = PartialEvaluatorImpl.getResultCollectionFromSingleDelta(e, deltaForEValue);
                } else {
                    result = new HashSet<Tuple.Pair<org.eclipse.ocl.ecore.OCLExpression, Collection<Object>>>();
                    for (Tuple.Pair<org.eclipse.ocl.ecore.OCLExpression, Collection<Object>> singlePropagationResult : propagated) {
                        Collection<Tuple.Pair<org.eclipse.ocl.ecore.OCLExpression, Collection<Object>>> singleResult = this.transitivelyPropagateDelta(singlePropagationResult.getA(), singlePropagationResult.getB(), mapper, cache);
                        result.addAll(singleResult);
                    }
                }
            }
        }
        return result;
    }

    static Collection<Tuple.Pair<org.eclipse.ocl.ecore.OCLExpression, Collection<Object>>> getResultCollectionFromSingleDelta(org.eclipse.ocl.ecore.OCLExpression e, Collection<Object> delta) {
        Set<Tuple.Pair<org.eclipse.ocl.ecore.OCLExpression, Collection<Object>>> result = delta == null || delta.isEmpty() ? Collections.emptySet() : Collections.singleton(new Tuple.Pair<org.eclipse.ocl.ecore.OCLExpression, Collection<Object>>(e, delta));
        return result;
    }
}

