/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.internal.core.builders.DependencyLoop;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public class LoopDialog
extends TrayDialog {
    private final DependencyLoop[] fLoops;
    private TreeViewer fLoopViewer;
    private final Image fLoopImage;

    public LoopDialog(Shell parentShell, DependencyLoop[] loops) {
        super(parentShell);
        this.fLoops = loops;
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        this.fLoopImage = provider.get(PDEPluginImages.DESC_LOOP_OBJ);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.pde.doc.user.loop_dialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 9;
        layout.marginWidth = 9;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        gd.heightHint = 300;
        container.setLayoutData((Object)gd);
        this.fLoopViewer = new TreeViewer(container);
        this.fLoopViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fLoopViewer.setLabelProvider((IBaseLabelProvider)new LoopLabelProvider());
        Tree tree = this.fLoopViewer.getTree();
        gd = new GridData(1808);
        tree.setLayoutData((Object)gd);
        this.fLoopViewer.setInput((Object)PDEPlugin.getDefault());
        this.fLoopViewer.expandAll();
        this.getShell().setText(PDEUIMessages.LoopDialog_title);
        return container;
    }

    protected boolean isResizable() {
        return true;
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof DependencyLoop) {
                return ((DependencyLoop)parentElement).getMembers();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof DependencyLoop;
        }

        public Object[] getElements(Object inputElement) {
            return LoopDialog.this.fLoops;
        }
    }

    class LoopLabelProvider
    extends LabelProvider {
        LoopLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof DependencyLoop) {
                return LoopDialog.this.fLoopImage;
            }
            return PDEPlugin.getDefault().getLabelProvider().getImage(element);
        }

        public String getText(Object element) {
            return PDEPlugin.getDefault().getLabelProvider().getText(element);
        }
    }
}

