/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.contexts;

import org.eclipse.dltk.annotations.NonNull;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.php.internal.core.codeassist.contexts.FunctionParameterContext;
import org.eclipse.wst.sse.core.internal.Logger;

public class FunctionParameterTypeContext
extends FunctionParameterContext {
    private IMethod enclosingMethod;
    private IType enclosingType;

    @Override
    public boolean isValid(@NonNull ISourceModule sourceModule, int offset, CompletionRequestor requestor) {
        if (!super.isValid(sourceModule, offset, requestor)) {
            return false;
        }
        char triggerChar = this.getTriggerChar();
        if (triggerChar == '(' || triggerChar == ',') {
            IModelElement enclosingElement;
            block7: {
                enclosingElement = sourceModule.getElementAt(offset);
                while (enclosingElement instanceof IField) {
                    enclosingElement = enclosingElement.getParent();
                }
                if (enclosingElement instanceof IMethod) break block7;
                return false;
            }
            try {
                this.enclosingMethod = (IMethod)enclosingElement;
                enclosingElement = this.enclosingMethod;
                while (enclosingElement != null && !(enclosingElement instanceof IType)) {
                    enclosingElement = enclosingElement.getParent();
                }
                this.enclosingType = (IType)enclosingElement;
                return true;
            }
            catch (ModelException e) {
                Logger.logException((Throwable)e);
                return false;
            }
        }
        return false;
    }

    public IMethod getEnclosingMethod() {
        return this.enclosingMethod;
    }

    public IType getEnclosingType() {
        return this.enclosingType;
    }
}

